/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.openide.nodes.Node;

public class PFObjectSceneListener
implements ObjectSceneListener {
    private static final UnsupportedOperationException uoe = new UnsupportedOperationException("Not supported yet.");

    public void objectAdded(ObjectSceneEvent event, Object addedObject) {
        throw uoe;
    }

    public void objectRemoved(ObjectSceneEvent event, Object removedObject) {
        throw uoe;
    }

    public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState prevState, ObjectState newState) {
        throw uoe;
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> prevSelection, Set<Object> newSelection) {
        PageFlowScene scene = (PageFlowScene)event.getObjectScene();
        HashSet<NavigationCaseEdge> releventEdges = new HashSet<NavigationCaseEdge>();
        HashSet<Node> selected = new HashSet<Node>();
        for (Object obj : newSelection) {
            if (!(obj instanceof PageFlowSceneElement)) continue;
            PageFlowSceneElement element = (PageFlowSceneElement)obj;
            selected.add(element.getNode());
            releventEdges.addAll(this.getRelevantEdges(element, scene));
        }
        scene.setHighlightedObjects(releventEdges);
        if (selected.isEmpty()) {
            scene.getPageFlowView().setDefaultActivatedNode();
        } else {
            scene.getPageFlowView().setActivatedNodes(selected.toArray(new Node[0]));
        }
    }

    public void highlightingChanged(ObjectSceneEvent event, Set<Object> prevHighlighting, Set<Object> newHighlighting) {
        throw uoe;
    }

    public void hoverChanged(ObjectSceneEvent event, Object prevHoveredObject, Object newHoveredObject) {
        throw uoe;
    }

    public void focusChanged(ObjectSceneEvent event, Object prevFocusedObject, Object newFocusedObject) {
        throw uoe;
    }

    private Set<NavigationCaseEdge> getRelevantEdges(PageFlowSceneElement element, PageFlowScene scene) {
        HashSet<NavigationCaseEdge> edgeSet = new HashSet<NavigationCaseEdge>();
        if (element instanceof Page) {
            Page page = (Page)element;
            Collection pins = scene.getNodePins(page);
            for (Pin pin : pins) {
                Collection edges = scene.findPinEdges(pin, true, false);
                edgeSet.addAll(edges);
            }
        } else if (element instanceof Pin) {
            Collection edges = scene.findPinEdges((Pin)element, true, false);
            edgeSet.addAll(edges);
        }
        return edgeSet;
    }
}

