/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

final class ResourcePathItem
extends AbstractCompletionItem {
    private DataObject target;
    private ImageIcon icon;
    private String right;

    public ResourcePathItem(DataObject target, CompletionContext ctx, String text, String right) {
        super(ctx, text);
        this.target = target;
        this.right = right;
    }

    @Override
    protected String getLeftHtmlText() {
        String tn = this.target.getName();
        if (this.target.getPrimaryFile().isFolder()) {
            return "<i>" + tn + "/</i>";
        }
        return tn;
    }

    @Override
    protected int getCaretShift(Document d) {
        int pos = super.getCaretShift(d);
        if (!this.target.getPrimaryFile().isData()) {
            --pos;
        }
        return pos;
    }

    @Override
    protected ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = ImageUtilities.icon2ImageIcon((Icon)ImageUtilities.image2Icon((Image)this.target.getNodeDelegate().getIcon(1)));
        }
        return this.icon;
    }

    public String toString() {
        return "resource[" + super.getSubstituteText() + "]";
    }
}

