/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.jsf.editor.facelets.FunctionImpl;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.facelets.TagImpl;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Function;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class FaceletsLibraryDescriptor
implements LibraryDescriptor {
    private FileObject definitionFile;
    private String uri;
    private String prefix;
    private Map<String, Tag> tags = new HashMap<String, Tag>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private static final String STOP_PARSING_MGS = "regularly_stopped";

    static FaceletsLibraryDescriptor create(FileObject definitionFile) throws LibraryDescriptorException {
        return new FaceletsLibraryDescriptor(definitionFile);
    }

    private FaceletsLibraryDescriptor(FileObject definitionFile) throws LibraryDescriptorException {
        this.definitionFile = definitionFile;
        this.parseLibrary();
    }

    public FileObject getDefinitionFile() {
        return this.definitionFile;
    }

    @Override
    public String getNamespace() {
        return this.uri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Map<String, Tag> getTags() {
        return this.tags;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public static String parseNamespace(InputStream content) throws IOException {
        return FaceletsLibraryDescriptor.parseNamespace(content, "facelet-taglib", "namespace");
    }

    protected void parseLibrary() throws LibraryDescriptorException {
        try {
            this.parseLibrary(this.getDefinitionFile().getInputStream());
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void parseLibrary(InputStream content) throws LibraryDescriptorException {
        try {
            NodeList functionNodes;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(content);
            EntityResolver resolver = UserCatalog.getDefault().getEntityResolver();
            if (resolver != null) {
                docBuilder.setEntityResolver(resolver);
            }
            Document doc = docBuilder.parse(is);
            Node tagLib = FaceletsLibraryDescriptor.getNodeByName(doc, "facelet-taglib");
            this.uri = FaceletsLibraryDescriptor.getTextContent(tagLib, "namespace");
            if (this.uri == null) {
                throw new IllegalStateException("Missing namespace entry in " + this.getDefinitionFile().getPath() + " library.", null);
            }
            Node idAttrItem = tagLib.getAttributes().getNamedItem("id");
            this.prefix = idAttrItem != null ? idAttrItem.getNodeValue() : null;
            NodeList tagNodes = doc.getElementsByTagName("tag");
            if (tagNodes != null) {
                for (int i = 0; i < tagNodes.getLength(); ++i) {
                    Node tag = tagNodes.item(i);
                    String tagName = FaceletsLibraryDescriptor.getTextContent(tag, "tag-name");
                    String tagDescription = FaceletsLibraryDescriptor.getTextContent(tag, "description");
                    HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
                    for (Node attrNode : FaceletsLibraryDescriptor.getNodesByName(tag, "attribute")) {
                        String aName = FaceletsLibraryDescriptor.getTextContent(attrNode, "name");
                        String aType = FaceletsLibraryDescriptor.getTextContent(attrNode, "type");
                        String aDescription = FaceletsLibraryDescriptor.getTextContent(attrNode, "description");
                        String aMethodSignature = FaceletsLibraryDescriptor.getTextContent(attrNode, "method-signature");
                        boolean aRequired = Boolean.parseBoolean(FaceletsLibraryDescriptor.getTextContent(attrNode, "required"));
                        attrs.put(aName, (Attribute)new Attribute.DefaultAttribute(aName, aDescription, aType, aRequired, aMethodSignature));
                    }
                    this.tags.put(tagName, new TagImpl(tagName, tagDescription, attrs));
                }
            }
            if ((functionNodes = doc.getElementsByTagName("function")) != null) {
                for (int i = 0; i < functionNodes.getLength(); ++i) {
                    Node function = functionNodes.item(i);
                    String funcName = FaceletsLibraryDescriptor.getTextContent(function, "function-name");
                    String funcSignature = FaceletsLibraryDescriptor.getTextContent(function, "function-signature");
                    String funcDescription = FaceletsLibraryDescriptor.getTextContent(function, "description");
                    this.functions.put(funcName, new FunctionImpl(funcName, funcSignature, funcDescription));
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", ex);
        }
    }

    public static String parseNamespace(InputStream content, final String tagTagName, final String namespaceTagName) throws IOException {
        String[] ns;
        block3: {
            ns = new String[1];
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                class Handler
                extends DefaultHandler {
                    private boolean inTaglib = false;
                    private boolean inURI = false;

                    Handler() {
                    }

                    @Override
                    public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                        String tagName = qname.toLowerCase();
                        if (tagTagName.equals(tagName)) {
                            this.inTaglib = true;
                        }
                        if (this.inTaglib && namespaceTagName.equals(tagName)) {
                            this.inURI = true;
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.inURI) {
                            ns[0] = new String(ch, start, length).trim();
                            throw new SAXException(FaceletsLibraryDescriptor.STOP_PARSING_MGS);
                        }
                    }

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                }
                parser.parse(content, (DefaultHandler)new Handler());
            }
            catch (ParserConfigurationException ex) {
                throw new IOException(ex);
            }
            catch (SAXException ex) {
                if (STOP_PARSING_MGS.equals(ex.getMessage())) break block3;
                throw new IOException(ex);
            }
        }
        return ns[0];
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append((String)(this.getDefinitionFile() != null ? this.getDefinitionFile().getFileSystem().getRoot().toURL().toString() + ";" + this.getDefinitionFile().getPath() : ""));
            sb.append("; uri = ").append(this.getNamespace()).append("; tags={");
            for (Tag t : this.getTags().values()) {
                sb.append(t.toString());
            }
            sb.append("}]");
            return sb.toString();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    protected static String getTextContent(Node parent, String childName) {
        Node found = FaceletsLibraryDescriptor.getNodeByName(parent, childName);
        return found == null ? null : found.getTextContent().trim();
    }

    static Node getNodeByName(Node parent, String childName) {
        Collection<Node> found = FaceletsLibraryDescriptor.getNodesByName(parent, childName);
        if (!found.isEmpty()) {
            return found.iterator().next();
        }
        return null;
    }

    static Collection<Node> getNodesByName(Node parent, String childName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(childName)) continue;
            nodes.add(n);
        }
        return nodes;
    }
}

