/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class NoProjectNew
extends JPanel
implements ActionListener,
DocumentListener {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_FOLDER = 1;
    private static final String FILE_NAME = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_File_Name");
    private static final String FILE_TITLE = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_File_Title");
    private static final String FILE_TEXT_FIELD_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_File_TextField");
    private static final String FILE_DIALOG_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_File_Dialog");
    private static final String FOLDER_NAME = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Folder_Name");
    private static final String FOLDER_TITLE = NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Folder_Title");
    private static final String FOLDER_TEXT_FIELD_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_Folder_TextField");
    private static final String FOLDER_DIALOG_ACD = NbBundle.getMessage(NoProjectNew.class, (String)"ACD_NonProject_Folder_Dialog");
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    private static DataObject[] templates;
    private int type;
    private DataFolder targetFolder;
    private String result;
    private JButton okOption;
    public JLabel nameLabel;
    public JTextField nameTextField;

    public NoProjectNew(int type, DataFolder targetFolder, JButton okOption) {
        this.initComponents();
        this.nameTextField.getDocument().addDocumentListener(this);
        this.type = type;
        this.targetFolder = targetFolder;
        this.okOption = okOption;
        switch (type) {
            case 0: {
                Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)FILE_NAME);
                this.nameTextField.getAccessibleContext().setAccessibleDescription(FILE_TEXT_FIELD_ACD);
                this.getAccessibleContext().setAccessibleDescription(FILE_DIALOG_ACD);
                break;
            }
            case 1: {
                Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)FOLDER_NAME);
                this.nameTextField.getAccessibleContext().setAccessibleDescription(FOLDER_TEXT_FIELD_ACD);
                this.getAccessibleContext().setAccessibleDescription(FOLDER_DIALOG_ACD);
            }
        }
        this.okOption.setEnabled(false);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText("Folders:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(25);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameTextField, gridBagConstraints);
    }

    public static void showDialog(DataObject template, DataFolder targetFolder) {
        int type = template.getPrimaryFile().getName().equals("file") ? 0 : 1;
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_OK_Button")), new JButton(NbBundle.getMessage(NoProjectNew.class, (String)"LBL_NonProject_Cancel_Button"))};
        NoProjectNew npn = new NoProjectNew(type, targetFolder, options[0]);
        options[0].setActionCommand(COMMAND_OK);
        options[0].addActionListener(npn);
        options[1].setActionCommand(COMMAND_CANCEL);
        options[1].addActionListener(npn);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)npn, type == 0 ? FILE_TITLE : FOLDER_TITLE, true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        npn.createFile();
    }

    public static DataObject[] getTemplates() {
        if (templates == null) {
            ArrayList<DataObject> tList = new ArrayList<DataObject>(2);
            DataObject template = NoProjectNew.findTemplate("Templates/Other/file");
            if (template != null) {
                tList.add(template);
            }
            if ((template = NoProjectNew.findTemplate("Templates/Other/Folder")) != null) {
                tList.add(template);
            }
            templates = new DataObject[tList.size()];
            tList.toArray(templates);
        }
        return templates;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.result = COMMAND_OK.equals(e.getActionCommand()) ? this.getFileName() : null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.okOption.setEnabled(false);
            return;
        }
        FileObject fo = this.targetFolder.getPrimaryFile().getFileObject(fileName);
        if (fo != null) {
            this.okOption.setEnabled(false);
            return;
        }
        this.okOption.setEnabled(true);
    }

    private static DataObject findTemplate(String name) {
        FileObject tFo = FileUtil.getConfigFile((String)name);
        if (tFo == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)tFo);
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    private String getFileName() {
        String name = this.nameTextField.getText().trim();
        return name.replace(File.separatorChar, '/');
    }

    private void createFile() {
        if (this.result != null && this.result.indexOf(92) == -1) {
            DataObject rootDO;
            if (!this.targetFolder.getPrimaryFile().canWrite()) {
                return;
            }
            DataObject dObj = null;
            try {
                FileObject fo;
                FileObject fileObject = fo = this.type == 0 ? FileUtil.createData((FileObject)this.targetFolder.getPrimaryFile(), (String)this.result) : FileUtil.createFolder((FileObject)this.targetFolder.getPrimaryFile(), (String)this.result);
                if (fo != null) {
                    dObj = DataObject.find((FileObject)fo);
                }
            }
            catch (DataObjectNotFoundException fo) {
            }
            catch (IOException fo) {
                // empty catch block
            }
            if (this.result != null && (rootDO = NoProjectNew.findTemplate("/Templates")) != null && dObj != null && FileUtil.isParentOf((FileObject)rootDO.getPrimaryFile(), (FileObject)dObj.getPrimaryFile())) {
                try {
                    dObj.setTemplate(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (dObj != null) {
                ProjectUtilities.openAndSelectNewObject(dObj);
            }
        }
    }
}

