/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class FixDependencies
extends Task {
    private List<Replace> replaces = new ArrayList<Replace>();
    private FileSet set;
    private String tgt;
    private String clean;
    private String ant;
    private boolean onlyChanged;
    private boolean fail;
    private boolean doSanity = true;
    private boolean strip = true;
    private Pattern moduleFilter;

    public Replace createReplace() {
        Replace r = new Replace();
        this.replaces.add(r);
        return r;
    }

    public FileSet createFileset() throws BuildException {
        if (this.set != null) {
            throw new BuildException("Only one file set is allowed");
        }
        this.set = new FileSet();
        return this.set;
    }

    public void setSanityCheck(boolean s) {
        this.doSanity = s;
    }

    public void setBuildTarget(String s) {
        this.tgt = s;
    }

    public void setCleanTarget(String s) {
        this.clean = s;
    }

    public void setAntFile(String r) {
        this.ant = r;
    }

    public void setStripOnlyChanged(boolean b) {
        this.onlyChanged = b;
    }

    public void setFailOnError(boolean b) {
        this.fail = b;
    }

    public void setStrip(boolean b) {
        this.strip = b;
    }

    public void setModuleFilter(String s) {
        if (s == null || "".equals(s)) {
            return;
        }
        this.moduleFilter = Pattern.compile(s, 2);
    }

    public void execute() throws BuildException {
        DirectoryScanner scan = this.set.getDirectoryScanner(this.getProject());
        File dir = scan.getBasedir();
        for (String kid : scan.getIncludedFiles()) {
            boolean compiled;
            File xml = new File(dir, kid);
            if (!xml.exists()) {
                throw new BuildException("File does not exist: " + xml, this.getLocation());
            }
            this.log("Fixing " + xml, 2);
            File script = null;
            Ant task = null;
            Ant cleanTask = null;
            boolean bl = compiled = !this.doSanity;
            if (this.ant != null && this.tgt != null) {
                task = (Ant)this.getProject().createTask("ant");
                script = FileUtils.getFileUtils().resolveFile(xml, this.ant);
                if (!script.exists()) {
                    String msg = "Skipping. Cannot find file " + this.ant + " from + " + xml;
                    if (this.fail) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                    continue;
                }
                task.setAntfile(script.getPath());
                task.setDir(script.getParentFile());
                task.setTarget(this.tgt);
                if (this.clean != null) {
                    cleanTask = (Ant)this.getProject().createTask("ant");
                    cleanTask.setAntfile(script.getPath());
                    cleanTask.setDir(script.getParentFile());
                    cleanTask.setTarget(this.clean);
                }
                try {
                    if (this.doSanity || this.strip) {
                        if (cleanTask != null) {
                            this.log("Cleaning " + this.clean + " in " + script, 2);
                            cleanTask.execute();
                            compiled = false;
                        }
                        if (this.doSanity) {
                            this.log("Sanity check executes " + this.tgt + " in " + script, 2);
                            task.execute();
                            compiled = true;
                        }
                    } else {
                        compiled = true;
                    }
                }
                catch (BuildException ex) {
                    if (this.fail) {
                        throw ex;
                    }
                    this.log("Skipping. Could not execute " + this.tgt + " in " + script, 0);
                    continue;
                }
            }
            try {
                boolean change = this.fix(xml, script, task, cleanTask, compiled);
                if (!this.strip || this.onlyChanged && !change) continue;
                this.simplify(xml, script, task, cleanTask);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fix(File file, File script, Ant task, Ant cleanTask, boolean compiled) throws IOException, BuildException {
        String stream;
        int s = (int)file.length();
        byte[] data = new byte[s];
        try (FileInputStream is = new FileInputStream(file);){
            if (s != ((InputStream)is).read(data)) {
                throw new BuildException("Cannot read " + file);
            }
        }
        String old = stream = new String(data);
        data = null;
        try {
            block16: for (Replace r : this.replaces) {
                int md = stream.indexOf("<module-dependencies");
                if (md == -1) {
                    throw new BuildException("No module dependencies in " + file);
                }
                int ed = stream.indexOf("</module-dependencies>", md);
                int n = ed = ed == -1 ? stream.indexOf("<module-dependencies/>", md) : ed;
                if (ed == -1) {
                    ed = stream.length();
                }
                if (this.moduleFilter != null && !this.moduleFilter.matcher(r.codeNameBase).matches()) continue;
                String alldeps = stream.substring(md, ed);
                int idx = stream.indexOf("<code-name-base>" + r.codeNameBase + "</code-name-base>", md);
                if (idx == -1 || idx > ed) continue;
                int from = stream.lastIndexOf("<dependency>", idx);
                if (from == -1) {
                    throw new BuildException("No <dependency> tag before index " + idx + " in " + file);
                }
                int after = stream.indexOf("</dependency", idx);
                if (after == -1) {
                    throw new BuildException("No </dependency> tag after index " + idx + " in " + file);
                }
                String remove = stream.substring(from, after += "</dependency>".length());
                if (r.addCompileTime && remove.indexOf("compile-dependency") == -1) {
                    int fromAfter = "<dependency".length();
                    int nonSpace = FixDependencies.findNonSpace(remove, fromAfter);
                    String spaces = remove.substring(fromAfter, nonSpace);
                    remove = remove.substring(0, fromAfter) + spaces + "<compile-dependency/>" + remove.substring(fromAfter);
                }
                StringBuffer sb = new StringBuffer();
                sb.append(stream.substring(0, from));
                boolean prefix = false;
                StringBuffer save = new StringBuffer();
                int mods = r.modules.size();
                int changed = 0;
                Module triggerModule = null;
                boolean specVersionMissing = false;
                for (Module m : r.modules) {
                    if (!m.codeNameBase.equals(r.codeNameBase)) continue;
                    this.log("Checking dependency: " + r.codeNameBase, 2);
                    if (remove.contains("<implementation-version/>")) continue block16;
                    String b = "<specification-version>";
                    int specBeg = remove.indexOf(b);
                    int specEnd = remove.indexOf("</specification-version>");
                    if (specBeg != -1 && specEnd != -1) {
                        String v = remove.substring(specBeg + b.length(), specEnd);
                        if (FixDependencies.olderThanOrEqual(m.specVersion, v)) {
                            continue block16;
                        }
                    } else {
                        this.log("No specification version present for dependency: " + m.codeNameBase, 1);
                        specVersionMissing = true;
                    }
                    triggerModule = m;
                    break;
                }
                for (Module m : r.modules) {
                    if (m != triggerModule && alldeps.indexOf("<code-name-base>" + m.codeNameBase + "</code-name-base>") != -1) continue;
                    if (prefix) {
                        sb.append('\n');
                        int i = from - 1;
                        while (stream.charAt(i) == ' ') {
                            sb.append(' ');
                            --i;
                        }
                    }
                    ++changed;
                    this.log("Adding dependency: " + m, 2);
                    int beg = remove.indexOf(r.codeNameBase);
                    int aft = beg + r.codeNameBase.length();
                    sb.append(remove.substring(0, beg));
                    sb.append(m.codeNameBase);
                    String a = remove.substring(aft);
                    if (specVersionMissing) {
                        int rd = a.indexOf("<run-dependency");
                        StringBuilder rep = new StringBuilder("<run-dependency>");
                        if (m.releaseVersion != null) {
                            rep.append("<release-version>").append(m.releaseVersion).append("</release-version>");
                        }
                        if (m.specVersion != null) {
                            rep.append("<specification-version>").append(m.specVersion).append("</specification-version>");
                        }
                        if (rd != -1) {
                            int end = a.indexOf("</run-dependency>");
                            String newA = a.substring(0, rd) + rep.toString();
                            if (end != -1) {
                                newA = newA + a.substring(end);
                            } else {
                                end = a.indexOf("<run-dependency/>");
                                if (end != -1) {
                                    newA = newA + "</run-dependency>" + a.substring(end + 17);
                                }
                            }
                            a = newA;
                        } else {
                            rep.append("</run-dependency>");
                            a = a + rep.toString();
                        }
                    } else {
                        if (m.specVersion != null) {
                            a = a.replaceAll("<specification-version>[0-9\\.]*</specification-version>", "<specification-version>" + m.specVersion + "</specification-version>");
                        }
                        if (m.releaseVersion == null) {
                            a = a.replaceAll("<release-version>[0-9]*</release-version>[\n\r ]*", "");
                        }
                    }
                    sb.append(a);
                    prefix = true;
                    if (!remove.contains("<compile-dependency")) continue;
                    save = new StringBuffer(sb.toString());
                    save.append(stream.substring(after));
                    String x = save.toString();
                    if (old.equals(x)) continue;
                    FileWriter fw = new FileWriter(file);
                    fw.write(x);
                    fw.close();
                    try {
                        if (compiled && cleanTask != null) {
                            this.log("Cleaning " + this.clean + " in " + script, 2);
                            cleanTask.execute();
                            compiled = false;
                        }
                        if (!compiled && task != null) {
                            this.log("Executing target " + this.tgt + " in " + script, 2);
                            task.execute();
                            this.log("Dependency on " + m + " is sufficient, skipping the rest", 2);
                            compiled = true;
                            stream = x;
                            continue block16;
                        }
                        this.log("Cannot verify dependency on " + m + " no build target, clean target or build script set.", 2);
                    }
                    catch (BuildException ex) {
                        this.log("Compilation failed: ", ex, 2);
                        fw = new FileWriter(file);
                        fw.write(old);
                        fw.close();
                        if (changed != mods) continue;
                        throw new BuildException("Could not fix dependencies.");
                    }
                }
                sb.append(stream.substring(after));
                stream = sb.toString();
            }
            if (!old.equals(stream)) {
                try (FileWriter fw = new FileWriter(file);){
                    fw.write(stream);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!compiled && task != null) {
                this.log("Executing target " + this.tgt + " in " + script, 2);
                task.execute();
            }
        }
    }

    private void simplify(File file, File script, Ant task, Ant cleanTask) throws IOException, BuildException {
        String stream;
        if (this.ant == null || this.tgt == null) {
            return;
        }
        int s = (int)file.length();
        byte[] data = new byte[s];
        try (FileInputStream is = new FileInputStream(file);){
            if (s != ((InputStream)is).read(data)) {
                throw new BuildException("Cannot read " + file);
            }
        }
        String old = stream = new String(data);
        int first = -1;
        int last = -1;
        int begin = -1;
        StringBuffer success = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        while (true) {
            String result;
            int after;
            int from;
            if (cleanTask != null) {
                this.log("Cleaning " + this.clean + " in " + script, 2);
                cleanTask.execute();
            }
            if ((from = stream.indexOf("<dependency>", begin)) == -1) break;
            if (first == -1) {
                first = from;
            }
            if ((after = stream.indexOf("</dependency", from)) == -1) {
                throw new BuildException("No </dependency> tag after index " + from + " in " + file);
            }
            begin = last = (after = FixDependencies.findNonSpace(stream, after + "</dependency".length()));
            try (FileWriter fw = new FileWriter(file);){
                fw.write(stream.substring(0, from) + stream.substring(after));
            }
            String dep = stream.substring(from, after);
            if (dep.indexOf("compile-dependency") == -1) {
                sb.append(stream.substring(from, after));
                continue;
            }
            if (dep.indexOf("org.netbeans.libs.javacapi") != -1) {
                sb.append(stream.substring(from, after));
                continue;
            }
            int cnbBeg = dep.indexOf("<code-name-base>");
            int cnbEnd = dep.indexOf("</code-name-base>");
            if (cnbBeg != -1 && cnbEnd != -1) {
                dep = dep.substring(cnbBeg + "<code-name-base>".length(), cnbEnd);
            }
            try {
                this.log("Executing target " + this.tgt + " in " + script, 2);
                task.execute();
                result = "Ok";
                success.append(dep);
                success.append("\n");
            }
            catch (BuildException ex) {
                result = "Failure";
                sb.append(stream.substring(from, after));
            }
            this.log("Removing dependency " + dep + ": " + result, 2);
        }
        if (first != -1) {
            try (FileWriter fw = new FileWriter(file);){
                fw.write(stream.substring(0, first) + sb.toString() + stream.substring(last));
            }
        }
        this.log("Final verification runs " + this.tgt + " in " + script, 2);
        task.execute();
        if (success.length() == 0) {
            this.log("No dependencies removed from " + script);
        } else {
            this.log("Removed dependencies from " + script + ":\n" + success);
        }
    }

    private static int findNonSpace(String where, int from) {
        if (from < where.length() && where.charAt(from) == '>') {
            ++from;
        }
        while (from < where.length() && Character.isWhitespace(where.charAt(from))) {
            ++from;
        }
        return from;
    }

    private static boolean olderThanOrEqual(String v1, String v2) {
        String[] arr1 = v1.split("\\.");
        String[] arr2 = v2.split("\\.");
        int min = Math.min(arr1.length, arr2.length);
        for (int i = 0; i < min; ++i) {
            int i2;
            int i1 = Integer.parseInt(arr1[i]);
            if (i1 == (i2 = Integer.parseInt(arr2[i]))) continue;
            return i1 < i2;
        }
        return arr1.length <= arr2.length;
    }

    public static final class Replace {
        String codeNameBase;
        List<Module> modules = new ArrayList<Module>();
        boolean addCompileTime;

        public void setCodeNameBase(String s) {
            this.codeNameBase = s;
        }

        public void setAddCompileTime(boolean b) {
            this.addCompileTime = b;
        }

        public Module createModule() {
            Module m = new Module();
            this.modules.add(m);
            return m;
        }
    }

    public static final class Module {
        String codeNameBase;
        String specVersion;
        String releaseVersion;

        public void setCodeNameBase(String s) {
            this.codeNameBase = s;
        }

        public void setSpec(String s) {
            this.specVersion = s;
        }

        public void setRelease(String r) {
            this.releaseVersion = r;
        }

        public String toString() {
            return this.codeNameBase + (this.releaseVersion != null ? this.releaseVersion : "") + " > " + this.specVersion;
        }
    }
}

