/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.AsyncGUIJob;
import org.openide.util.AsyncInitSupport;
import org.openide.util.BaseUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.UtilitiesCompositeActionMap;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public final class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final int CTRL_WILDCARD_MASK = 32768;
    private static final int ALT_WILDCARD_MASK = 65536;
    private static final Map<GraphicsConfiguration, Map<Rectangle, Long>> screenBoundsCache;
    private static Lookup global;
    private static Reference<NamesAndValues> namesAndValues;

    private Utilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return BaseUtilities.activeReferenceQueue();
    }

    public static int getOperatingSystem() {
        return BaseUtilities.getOperatingSystem();
    }

    public static boolean isWindows() {
        return BaseUtilities.isWindows();
    }

    public static boolean isMac() {
        return BaseUtilities.isMac();
    }

    public static boolean isUnix() {
        return BaseUtilities.isUnix();
    }

    public static boolean isJavaIdentifier(String id) {
        return BaseUtilities.isJavaIdentifier((String)id);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ie) {
            Exceptions.attachMessage((Throwable)ie, (String)("Encountered while introspecting " + clazz.getName()));
            throw ie;
        }
        catch (Error e) {
            Exceptions.attachMessage((Throwable)e, (String)("Encountered while introspecting " + clazz.getName()));
            throw e;
        }
        if (Component.class.isAssignableFrom(clazz)) {
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].getName().equals("cursor")) continue;
                try {
                    Method getter = Component.class.getDeclaredMethod("getCursor", new Class[0]);
                    Method setter = Component.class.getDeclaredMethod("setCursor", Cursor.class);
                    pds[i] = new PropertyDescriptor("cursor", getter, setter);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (bi != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, stopClass);
    }

    @Deprecated
    public static String[] wrapStringToArray(String original, int width, boolean wrapWords, boolean removeNewLines) {
        BreakIterator bi = wrapWords ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(original, width, bi, removeNewLines);
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        return BaseUtilities.wrapStringToArray((String)original, (int)width, (BreakIterator)breakIterator, (boolean)removeNewLines);
    }

    public static String wrapString(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        return BaseUtilities.wrapString((String)original, (int)width, (BreakIterator)breakIterator, (boolean)removeNewLines);
    }

    @Deprecated
    public static String wrapString(String original, int width, boolean wrapWords, boolean removeNewLines) {
        if (removeNewLines) {
            while (original.startsWith("\n")) {
                original = original.substring(1);
            }
            while (original.endsWith("\n")) {
                original = original.substring(0, original.length() - 1);
            }
            original = original.replace('\n', ' ');
        }
        if (width < 1) {
            width = 1;
        }
        if (original.length() <= width) {
            return original;
        }
        Vector<String> lines = new Vector<String>();
        int lineStart = 0;
        int lastSpacePos = -1;
        for (int i = 0; i < original.length() && lineStart < original.length() - 1; ++i) {
            if (original.charAt(i) == '\n') {
                lines.addElement(original.substring(lineStart, i));
                lineStart = i + 1;
                lastSpacePos = -1;
                continue;
            }
            if (Character.isSpaceChar(original.charAt(i))) {
                lastSpacePos = i;
            }
            if (i == original.length() - 1) {
                lines.addElement(original.substring(lineStart));
                break;
            }
            if (i - lineStart != width) continue;
            if (wrapWords && lastSpacePos != -1) {
                lines.addElement(original.substring(lineStart, lastSpacePos));
                lineStart = lastSpacePos + 1;
                lastSpacePos = -1;
                continue;
            }
            lines.addElement(original.substring(lineStart, i));
            lineStart = i;
            lastSpacePos = -1;
        }
        StringBuilder retBuf = new StringBuilder();
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            retBuf.append((String)e.nextElement());
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    @Deprecated
    public static String replaceString(String original, String replaceFrom, String replaceTo) {
        int pos;
        int index = 0;
        if ("".equals(replaceFrom)) {
            return original;
        }
        StringBuilder buf = new StringBuilder();
        do {
            if ((pos = original.indexOf(replaceFrom, index)) == -1) {
                buf.append(original.substring(index));
                return buf.toString();
            }
            buf.append(original.substring(index, pos));
            buf.append(replaceTo);
        } while ((index = pos + replaceFrom.length()) != original.length());
        return buf.toString();
    }

    public static String pureClassName(String fullName) {
        return BaseUtilities.pureClassName((String)fullName);
    }

    @Deprecated
    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    @Deprecated
    public static int arrayHashCode(Object[] arr) {
        int c = 0;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            Object o = arr[i];
            int v = o == null ? 1 : o.hashCode();
            c += v ^ i;
        }
        return c;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return BaseUtilities.compareObjects((Object)o1, (Object)o2);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        return BaseUtilities.compareObjectsImpl((Object)o1, (Object)o2, (int)checkArraysDepth);
    }

    public static String getClassName(Class<?> clazz) {
        return BaseUtilities.getClassName(clazz);
    }

    public static String getShortClassName(Class<?> clazz) {
        return BaseUtilities.getShortClassName(clazz);
    }

    public static Object toPrimitiveArray(Object[] array) {
        return BaseUtilities.toPrimitiveArray((Object[])array);
    }

    public static Object[] toObjectArray(Object array) {
        return BaseUtilities.toObjectArray((Object)array);
    }

    public static Class<?> getObjectType(Class<?> c) {
        return BaseUtilities.getObjectType(c);
    }

    public static Class<?> getPrimitiveType(Class<?> c) {
        return BaseUtilities.getPrimitiveType(c);
    }

    public static Component getFocusTraversableComponent(Component c) {
        if (c.isFocusable()) {
            return c;
        }
        if (!(c instanceof Container)) {
            return null;
        }
        int k = ((Container)c).getComponentCount();
        for (int i = 0; i < k; ++i) {
            Component v = ((Container)c).getComponent(i);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String[] parseParameters(String s) {
        return BaseUtilities.parseParameters((String)s);
    }

    public static String escapeParameters(String[] params) {
        return BaseUtilities.escapeParameters((String[])params);
    }

    private static synchronized NamesAndValues initNameAndValues() {
        NamesAndValues nav;
        if (namesAndValues != null && (nav = namesAndValues.get()) != null) {
            return nav;
        }
        Field[] fields = KeyEvent.class.getDeclaredFields();
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> values = new HashMap<Integer, String>(fields.length * 4 / 3 + 5, 0.75f);
        for (Field f : fields) {
            String name;
            if (!Modifier.isStatic(f.getModifiers()) || !(name = f.getName()).startsWith("VK_")) continue;
            name = name.substring(3);
            try {
                int numb = f.getInt(null);
                names.put(name, numb);
                values.put(numb, name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (names.get("CONTEXT_MENU") == null) {
            names.put("CONTEXT_MENU", 524);
            values.put(524, "CONTEXT_MENU");
            names.put("WINDOWS", 525);
            values.put(525, "WINDOWS");
        }
        names.put("MOUSE_WHEEL_UP", 656);
        names.put("MOUSE_WHEEL_DOWN", 657);
        values.put(656, "MOUSE_WHEEL_UP");
        values.put(657, "MOUSE_WHEEL_DOWN");
        for (int button = 4; button < 10; ++button) {
            String name = "MOUSE_BUTTON" + button;
            int code = 658 + (button - 1);
            names.put(name, code);
            values.put(code, name);
        }
        NamesAndValues nav2 = new NamesAndValues(values, names);
        namesAndValues = new SoftReference<NamesAndValues>(nav2);
        return nav2;
    }

    public static boolean isMouseKeyCode(int keycode) {
        return keycode >= 656 && keycode <= 671;
    }

    public static int mouseWheelUpKeyCode() {
        return 656;
    }

    public static int mouseWheelDownKeyCode() {
        return 657;
    }

    public static int mouseButtonKeyCode(int button) {
        if (button >= 4 && button < 10) {
            return 658 + (button - 1);
        }
        return 0;
    }

    public static String keyToString(KeyStroke stroke) {
        StringBuilder sb = new StringBuilder();
        if (Utilities.addModifiers(sb, stroke.getModifiers())) {
            sb.append('-');
        }
        Utilities.appendRest(sb, stroke);
        return sb.toString();
    }

    private static void appendRest(StringBuilder sb, KeyStroke stroke) {
        String c = Utilities.initNameAndValues().keyToString.get(stroke.getKeyCode());
        if (c == null) {
            sb.append(stroke.getKeyChar());
        } else {
            sb.append(c);
        }
    }

    public static String keyToString(KeyStroke stroke, boolean portable) {
        if (portable) {
            StringBuilder sb = new StringBuilder();
            if (Utilities.addModifiersPortable(sb, stroke.getModifiers())) {
                sb.append('-');
            }
            Utilities.appendRest(sb, stroke);
            return sb.toString();
        }
        return Utilities.keyToString(stroke);
    }

    public static KeyStroke stringToKey(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), "-", true);
        int needed = 0;
        Map<String, Integer> names = Utilities.initNameAndValues().stringToKey;
        int lastModif = -1;
        try {
            String el;
            while (true) {
                if ((el = st.nextToken()).equals("-")) {
                    if (lastModif == -1) continue;
                    needed |= lastModif;
                    lastModif = -1;
                    continue;
                }
                if (!st.hasMoreElements()) break;
                lastModif = Utilities.readModifiers(el);
            }
            Integer i = names.get(el);
            boolean wildcard = (needed & 0x8000) != 0;
            boolean macAlt = ((needed &= 0xFFFF7FFF) & 0x10000) != 0;
            needed &= 0xFFFEFFFF;
            if (i != null) {
                if (wildcard && Utilities.isMac() && !Utilities.usableKeyOnMac(i, macAlt ? needed | 2 : (needed |= Utilities.getMenuShortcutKeyMask()))) {
                    needed &= ~Utilities.getMenuShortcutKeyMask();
                    needed = macAlt ? (needed |= 8) : (needed |= 2);
                }
                if (macAlt) {
                    needed = Utilities.getOperatingSystem() == 4096 ? (needed |= 2) : (needed |= 8);
                }
                return KeyStroke.getKeyStroke(i, needed);
            }
            return null;
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    private static boolean usableKeyOnMac(int key, int mask) {
        boolean isOnlyMeta;
        if (key == 81) {
            return false;
        }
        boolean isMeta = (mask & 4) != 0 || (mask & 0x80) != 0;
        boolean isAlt = (mask & 8) != 0 || (mask & 0x200) != 0;
        boolean bl = isOnlyMeta = isMeta && (mask & 0xFFFFFEFB) == 0;
        if (isOnlyMeta) {
            return key != 72 && key != 32 && key != 9;
        }
        if (key == 68 && isMeta && isAlt) {
            return false;
        }
        return key != 32 || !isMeta || (mask & 2) == 0;
    }

    private static int getMenuShortcutKeyMask() {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 2;
    }

    public static KeyStroke[] stringToKeys(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arr = new ArrayList<KeyStroke>();
        while (st.hasMoreElements()) {
            s = st.nextToken();
            KeyStroke k = Utilities.stringToKey(s);
            if (k == null) {
                return null;
            }
            arr.add(k);
        }
        return arr.toArray(new KeyStroke[0]);
    }

    private static boolean addModifiers(StringBuilder buf, int modif) {
        boolean b = false;
        if ((modif & 2) != 0) {
            buf.append("C");
            b = true;
        }
        if ((modif & 8) != 0) {
            buf.append("A");
            b = true;
        }
        if ((modif & 1) != 0) {
            buf.append("S");
            b = true;
        }
        if ((modif & 4) != 0) {
            buf.append("M");
            b = true;
        }
        if ((modif & 0x8000) != 0) {
            buf.append("D");
            b = true;
        }
        if ((modif & 0x10000) != 0) {
            buf.append("O");
            b = true;
        }
        return b;
    }

    private static boolean addModifiersPortable(StringBuilder buf, int modifiers) {
        boolean b = false;
        if ((modifiers & 1) != 0) {
            buf.append('S');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 4) != 0 || !Utilities.isMac() && (modifiers & 2) != 0) {
            buf.append('D');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 2) != 0 || !Utilities.isMac() && (modifiers & 8) != 0) {
            buf.append('O');
            b = true;
        }
        if (Utilities.isMac() && (modifiers & 8) != 0) {
            buf.append('A');
            b = true;
        }
        if (!Utilities.isMac() && (modifiers & 4) != 0) {
            buf.append('M');
            b = true;
        }
        return b;
    }

    private static int readModifiers(String s) throws NoSuchElementException {
        int m = 0;
        block8: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'C': {
                    m |= 2;
                    continue block8;
                }
                case 'A': {
                    m |= 8;
                    continue block8;
                }
                case 'M': {
                    m |= 4;
                    continue block8;
                }
                case 'S': {
                    m |= 1;
                    continue block8;
                }
                case 'D': {
                    m |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    m |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(s);
                }
            }
        }
        return m;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            Window w = SwingUtilities.getWindowAncestor(focusOwner);
            if (w != null) {
                return w.getGraphicsConfiguration();
            }
            Frame f = Utilities.findMainWindow();
            if (f != null) {
                return f.getGraphicsConfiguration();
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (screenBoundsCache == null) {
            return Utilities.calculateUsableScreenBounds(gconf);
        }
        Map<GraphicsConfiguration, Map<Rectangle, Long>> map = screenBoundsCache;
        synchronized (map) {
            Map<Rectangle, Long> cacheEntry = screenBoundsCache.get(gconf);
            if (cacheEntry != null) {
                long now = System.currentTimeMillis();
                Map.Entry<Rectangle, Long> entry = cacheEntry.entrySet().iterator().next();
                if (entry.getValue() < now + 10000L) {
                    return new Rectangle(entry.getKey());
                }
            }
            Rectangle screenBounds = Utilities.calculateUsableScreenBounds(gconf);
            cacheEntry = new HashMap<Rectangle, Long>(1);
            cacheEntry.put(screenBounds, System.currentTimeMillis());
            if (screenBoundsCache.size() > 20) {
                screenBoundsCache.clear();
            }
            screenBoundsCache.put(gconf, cacheEntry);
            return new Rectangle(screenBounds);
        }
    }

    private static Rectangle calculateUsableScreenBounds(GraphicsConfiguration gconf) {
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            if (insets.left > bounds.x && bounds.x > 0) {
                insets.left -= bounds.x;
            }
            if (insets.top > bounds.y && bounds.y > 0) {
                insets.top -= bounds.y;
            }
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        if (bounds.width <= 0 || bounds.height <= 0) {
            bounds = new Rectangle(gconf.getBounds());
        }
        return bounds;
    }

    public static Rectangle findCenterBounds(Dimension componentSize) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), componentSize);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration gconf, Dimension componentSize) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = gconf.getBounds();
        return new Rectangle(bounds.x + (bounds.width - componentSize.width) / 2, bounds.y + (bounds.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    private static Frame findMainWindow() {
        Frame f = null;
        for (Frame f01 : Frame.getFrames()) {
            if (!"NbMainWindow".equals(f01.getName())) continue;
            if (f01.getWidth() == 0 && f01.getHeight() == 0) break;
            f = f01;
            break;
        }
        return f;
    }

    public static Component findDialogParent() {
        return Utilities.findDialogParent(null);
    }

    public static Component findDialogParent(Component suggestedParent) {
        Component parent = suggestedParent;
        if (parent == null) {
            parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (parent == null) {
            parent = active;
        } else if (active instanceof Dialog && ((Dialog)active).isModal()) {
            Window suggested;
            Window window = suggested = parent instanceof Window ? (Window)parent : SwingUtilities.windowForComponent(parent);
            if (suggested != active) {
                return active;
            }
        }
        if (parent == null) {
            parent = Utilities.findMainWindow();
        }
        return parent;
    }

    public static boolean isModalDialogOpen() {
        Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return active instanceof Dialog && ((Dialog)active).isModal();
    }

    @Deprecated
    public static Dimension getScreenSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            screenSize.height -= 27;
        } else if (Utilities.isMac()) {
            screenSize.height -= 24;
        }
        return screenSize;
    }

    @Deprecated
    public static int showJFileChooser(JFileChooser chooser, Component parent, String approveButtonText) {
        if (approveButtonText != null) {
            chooser.setApproveButtonText(approveButtonText);
            chooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog parentDlg = null;
        if (parent instanceof Dialog) {
            parentDlg = (Dialog)parent;
        } else {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        String title = chooser.getDialogTitle();
        if (title == null) {
            title = chooser.getUI().getDialogTitle(chooser);
        }
        final JDialog dialog = parentDlg != null ? new JDialog(parentDlg, title, true) : new JDialog(frame, title, true);
        dialog.setDefaultCloseOperation(2);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        dialog.pack();
        dialog.setBounds(Utilities.findCenterBounds(parent.getGraphicsConfiguration(), dialog.getSize()));
        chooser.rescanCurrentDirectory();
        final int[] retValue = new int[]{1};
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if ("ApproveSelection".equals(ev.getActionCommand())) {
                    retValue[0] = 0;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        chooser.addActionListener(l);
        dialog.show();
        return retValue[0];
    }

    @Deprecated
    public static List partialSort(List l, Comparator c, boolean stable) throws UnorderableException {
        HashSet s;
        HashMap deps = new HashMap();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                int cmp = c.compare(l.get(i), l.get(j));
                if (cmp == 0) continue;
                Object earlier = l.get(cmp < 0 ? i : j);
                Object later = l.get(cmp > 0 ? i : j);
                s = (HashSet)deps.get(later);
                if (s == null) {
                    s = new HashSet();
                    deps.put(later, s);
                }
                s.add(earlier);
            }
        }
        LinkedList left = new LinkedList(l);
        ArrayList sorted = new ArrayList(size);
        while (left.size() > 0) {
            boolean stillGoing = false;
            Iterator<Object> it = left.iterator();
            while (it.hasNext()) {
                Object elt = it.next();
                Set eltDeps = (Set)deps.get(elt);
                if (eltDeps != null && !eltDeps.isEmpty()) continue;
                it.remove();
                stillGoing = true;
                sorted.add(elt);
                for (Object elt2 : left) {
                    Set eltDeps2 = (Set)deps.get(elt2);
                    if (eltDeps2 == null) continue;
                    eltDeps2.remove(elt);
                }
                if (!stable) continue;
                break;
            }
            if (stillGoing) continue;
            it = deps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = (Map.Entry)it.next();
                if (!left.contains(me.getKey())) {
                    it.remove();
                    continue;
                }
                s = (Set)me.getValue();
                Iterator it2 = s.iterator();
                while (it2.hasNext()) {
                    if (left.contains(it2.next())) continue;
                    it2.remove();
                }
                if (!s.isEmpty()) continue;
                it.remove();
            }
            throw new UnorderableException(left, deps);
        }
        return sorted;
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> c, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        return BaseUtilities.topologicalSort(c, edges);
    }

    public static String translate(String className) {
        return BaseUtilities.translate((String)className);
    }

    @Deprecated
    public static Image mergeImages(Image image1, Image image2, int x, int y) {
        return ImageUtilities.mergeImages(image1, image2, x, y);
    }

    @Deprecated
    public static Image loadImage(String resourceID) {
        return ImageUtilities.loadImage(resourceID);
    }

    @Deprecated
    public static Image icon2Image(Icon icon) {
        return ImageUtilities.icon2Image(icon);
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Lookup context) {
        HashSet<Action> counted = new HashSet<Action>();
        ArrayList<Component> components = new ArrayList<Component>();
        for (Action action : actions) {
            if (action != null && counted.add(action)) {
                JMenuItem item;
                if (action instanceof ContextAwareAction) {
                    Action contextAwareAction = ((ContextAwareAction)action).createContextAwareInstance(context);
                    if (contextAwareAction == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{action, context});
                    } else {
                        action = contextAwareAction;
                    }
                }
                if (action instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)((Object)action)).getPopupPresenter();
                    if (item == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "findContextMenuImpl, getPopupPresenter returning null for {0}", action);
                        continue;
                    }
                } else {
                    item = ActionPresenterProvider.getDefault().createPopupPresenter(action);
                }
                for (Component c : ActionPresenterProvider.getDefault().convertComponents(item)) {
                    if (c instanceof JSeparator) {
                        components.add(null);
                        continue;
                    }
                    components.add(c);
                }
                continue;
            }
            components.add(null);
        }
        JPopupMenu menu = ActionPresenterProvider.getDefault().createEmptyPopup();
        boolean nonempty = false;
        boolean pendingSep = false;
        for (Component c : components) {
            try {
                if (c == null) {
                    pendingSep = nonempty;
                    continue;
                }
                nonempty = true;
                if (pendingSep) {
                    pendingSep = false;
                    menu.addSeparator();
                }
                menu.add(c);
            }
            catch (RuntimeException ex) {
                Exceptions.attachMessage((Throwable)ex, (String)("Current component: " + c));
                Exceptions.attachMessage((Throwable)ex, (String)("List of components: " + components));
                Exceptions.attachMessage((Throwable)ex, (String)("List of actions: " + Arrays.asList(actions)));
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return menu;
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Component component) {
        Lookup lookup = null;
        for (Component c = component; !(c == null || c instanceof Lookup.Provider && (lookup = ((Lookup.Provider)c).getLookup()) != null); c = c.getParent()) {
        }
        if (lookup == null) {
            UtilitiesCompositeActionMap map = new UtilitiesCompositeActionMap(component);
            lookup = Lookups.singleton((Object)map);
        }
        return Utilities.actionsToPopup(actions, lookup);
    }

    public static List<? extends Action> actionsForPath(String path) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Lookup.Item item : Lookups.forPath((String)path).lookupResult(Object.class).allItems()) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Object instance = item.getInstance();
                if (instance == null) continue;
                actions.add((Action)instance);
                continue;
            }
            if (JSeparator.class.isAssignableFrom(item.getType())) {
                actions.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Unrecognized object of {0} found in actions path {1}", new Object[]{item.getType(), path});
        }
        return actions;
    }

    public static List<? extends Action> actionsForPath(String path, Lookup context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Lookup.Item item : Lookups.forPath((String)path).lookupResult(Object.class).allItems()) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Object instance = item.getInstance();
                if (instance instanceof ContextAwareAction) {
                    Action contextAwareInstance = ((ContextAwareAction)instance).createContextAwareInstance(context);
                    if (contextAwareInstance == null) {
                        Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{instance, context});
                    } else {
                        instance = contextAwareInstance;
                    }
                }
                actions.add((Action)instance);
                continue;
            }
            if (JSeparator.class.isAssignableFrom(item.getType())) {
                actions.add(null);
                continue;
            }
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Unrecognized object of {0} found in actions path {1}", new Object[]{item.getType(), path});
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lookup actionsGlobalContext() {
        Class<ContextGlobalProvider> clazz = ContextGlobalProvider.class;
        synchronized (ContextGlobalProvider.class) {
            if (global != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return global;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ContextGlobalProvider p = (ContextGlobalProvider)Lookup.getDefault().lookup(ContextGlobalProvider.class);
            Lookup l = p == null ? Lookup.EMPTY : p.createGlobalContext();
            Class<ContextGlobalProvider> clazz2 = ContextGlobalProvider.class;
            synchronized (ContextGlobalProvider.class) {
                if (global == null) {
                    global = l;
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return global;
            }
        }
    }

    @Deprecated
    public static Image loadImage(String resource, boolean localized) {
        return ImageUtilities.loadImage(resource, localized);
    }

    public static Cursor createProgressCursor(Component component) {
        if (component == null) {
            throw new NullPointerException("Given component is null");
        }
        Image image = null;
        image = Utilities.isMac() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-mac.gif") : (Utilities.isUnix() ? ImageUtilities.loadImage("org/openide/util/progress-cursor-motif.gif") : ImageUtilities.loadImage("org/openide/util/progress-cursor-win.gif"));
        return Utilities.createCustomCursor(component, image, "PROGRESS_CURSOR");
    }

    public static Cursor createCustomCursor(Component component, Image icon, String name) {
        Toolkit t = component.getToolkit();
        Dimension d = t.getBestCursorSize(16, 16);
        Image i = icon;
        if (d.width != icon.getWidth(null)) {
            if (d.width == 0 && d.height == 0) {
                return Cursor.getPredefinedCursor(3);
            }
            BufferedImage empty = ImageUtilities.createBufferedImage(d.width, d.height);
            i = ImageUtilities.mergeImages(icon, empty, 0, 0);
        }
        return t.createCustomCursor(i, new Point(1, 1), name);
    }

    public static void attachInitJob(Component comp4Init, AsyncGUIJob initJob) {
        new AsyncInitSupport(comp4Init, initJob);
    }

    public static URI toURI(File f) {
        return BaseUtilities.toURI((File)f);
    }

    public static File toFile(URI u) throws IllegalArgumentException {
        return BaseUtilities.toFile((URI)u);
    }

    @Deprecated
    public static URL toURL(File f) throws MalformedURLException {
        if (f == null) {
            throw new NullPointerException();
        }
        if (!f.isAbsolute()) {
            throw new IllegalArgumentException("Relative path: " + f);
        }
        URI uri = Utilities.toURI(f);
        return uri.toURL();
    }

    @Deprecated
    public static File toFile(URL u) {
        if (u == null) {
            throw new NullPointerException();
        }
        try {
            URI uri = u.toURI();
            return Utilities.toFile(uri);
        }
        catch (URISyntaxException use) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static void disabledActionBeep() {
        if (Utilities.isWindows()) {
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        boolean cacheEnabled = !GraphicsEnvironment.isHeadless() && Utilities.isUnix() && !Utilities.isMac() && System.getProperty("netbeans.screen.insetsCache", "true").equalsIgnoreCase("true");
        screenBoundsCache = cacheEnabled ? new WeakHashMap<GraphicsConfiguration, Map<Rectangle, Long>>() : null;
    }

    private static final class NamesAndValues {
        final Map<Integer, String> keyToString;
        final Map<String, Integer> stringToKey;

        NamesAndValues(Map<Integer, String> keyToString, Map<String, Integer> stringToKey) {
            this.keyToString = keyToString;
            this.stringToKey = stringToKey;
        }
    }

    @Deprecated
    public static class UnorderableException
    extends RuntimeException {
        static final long serialVersionUID = 6749951134051806661L;
        private Collection unorderable;
        private Map deps;

        public UnorderableException(Collection unorderable, Map deps) {
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public UnorderableException(String message, Collection unorderable, Map deps) {
            super(message);
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }
}

