/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedItemIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedItemIterator;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.LineInfo;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.StringSequenceBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineAppendableImpl
implements LineAppendable {
    private static final char EOL = '\n';
    private final boolean passThrough;
    private final BitFieldSet<LineAppendable.Options> options;
    private int preFormattedNesting;
    private int preFormattedFirstLine;
    private int preFormattedFirstLineOffset;
    private int preFormattedLastLine;
    private int preFormattedLastLineOffset;
    private ISequenceBuilder<?, ?> appendable;
    final ArrayList<LineInfo> lines;
    private CharSequence prefix;
    private CharSequence prefixAfterEol;
    private CharSequence indentPrefix;
    private final Stack<CharSequence> prefixStack;
    private final Stack<Boolean> indentPrefixStack;
    private boolean allWhitespace;
    private boolean lastWasWhitespace;
    private int eolOnFirstText;
    private final ArrayList<Runnable> indentsOnFirstEol;
    private final Stack<Integer> optionStack = new Stack();
    int modificationCount;

    public LineAppendableImpl(int formatOptions) {
        this(null, LineAppendable.toOptionSet(formatOptions));
    }

    public LineAppendableImpl(@Nullable Appendable builder, int formatOptions) {
        this(builder, LineAppendable.toOptionSet(formatOptions));
    }

    public LineAppendableImpl(@Nullable Appendable appendable, BitFieldSet<LineAppendable.Options> formatOptions) {
        this.appendable = appendable instanceof ISequenceBuilder ? ((ISequenceBuilder)appendable).getBuilder() : (appendable instanceof LineAppendable ? ((LineAppendable)appendable).getBuilder() : StringSequenceBuilder.emptyBuilder());
        this.options = formatOptions;
        this.passThrough = this.any(F_PASS_THROUGH);
        this.preFormattedNesting = 0;
        this.preFormattedFirstLine = -1;
        this.preFormattedLastLine = -1;
        this.allWhitespace = true;
        this.lastWasWhitespace = false;
        this.lines = new ArrayList();
        this.prefixStack = new Stack();
        this.indentPrefixStack = new Stack();
        this.prefix = BasedSequence.EMPTY;
        this.prefixAfterEol = BasedSequence.EMPTY;
        this.indentPrefix = BasedSequence.EMPTY;
        this.eolOnFirstText = 0;
        this.indentsOnFirstEol = new ArrayList();
    }

    @Override
    @NotNull
    public LineAppendable getEmptyAppendable() {
        return new LineAppendableImpl((Appendable)this, this.getOptions());
    }

    @Override
    @NotNull
    public BitFieldSet<LineAppendable.Options> getOptionSet() {
        return this.options;
    }

    @Override
    @NotNull
    public LineAppendable setOptions(int flags) {
        this.options.setAll((long)flags);
        return this;
    }

    @Override
    @NotNull
    public LineAppendable pushOptions() {
        this.optionStack.push(this.options.toInt());
        return this;
    }

    @Override
    @NotNull
    public LineAppendable popOptions() {
        if (this.optionStack.isEmpty()) {
            throw new IllegalStateException("Option stack is empty");
        }
        Integer mask = this.optionStack.pop();
        this.options.setAll((long)mask.intValue());
        return this;
    }

    @Override
    @NotNull
    public LineAppendable changeOptions(int addFlags, int removeFlags) {
        if ((addFlags & removeFlags) != 0) {
            throw new IllegalStateException(String.format("Add flags:%d and remove flags:%d overlap:%d", addFlags, removeFlags, addFlags & removeFlags));
        }
        this.options.orMask((long)addFlags);
        this.options.andNotMask((long)removeFlags);
        return this;
    }

    private boolean any(int flags) {
        return this.options.any((long)flags);
    }

    private boolean isConvertingTabs() {
        return this.any(F_CONVERT_TABS | F_COLLAPSE_WHITESPACE);
    }

    private boolean isTrimTrailingWhitespace() {
        return this.any(F_TRIM_TRAILING_WHITESPACE);
    }

    private boolean isTrimLeadingWhitespace() {
        return this.any(F_TRIM_LEADING_WHITESPACE);
    }

    private boolean isCollapseWhitespace() {
        return this.any(F_COLLAPSE_WHITESPACE);
    }

    @Override
    @NotNull
    public BasedSequence getIndentPrefix() {
        return BasedSequence.of(this.indentPrefix);
    }

    @Override
    @NotNull
    public LineAppendable setIndentPrefix(@Nullable CharSequence prefix) {
        this.indentPrefix = prefix == null ? BasedSequence.NULL : prefix;
        return this;
    }

    @Override
    @NotNull
    public BasedSequence getPrefix() {
        return BasedSequence.of(this.prefixAfterEol);
    }

    @Override
    @NotNull
    public BasedSequence getBeforeEolPrefix() {
        return BasedSequence.of(this.prefix);
    }

    @Override
    @NotNull
    public LineAppendable addPrefix(@NotNull CharSequence prefix, boolean afterEol) {
        if (!this.passThrough && prefix.length() != 0) {
            this.prefixAfterEol = afterEol ? LineAppendable.combinedPrefix(this.prefixAfterEol, prefix) : (this.prefix = LineAppendable.combinedPrefix(this.prefixAfterEol, prefix));
        }
        return this;
    }

    @Override
    public int getAfterEolPrefixDelta() {
        return this.prefixAfterEol.length() - this.prefix.length();
    }

    @Override
    @NotNull
    public LineAppendable setPrefix(@Nullable CharSequence prefix, boolean afterEol) {
        if (!this.passThrough) {
            this.prefixAfterEol = afterEol ? (prefix == null ? BasedSequence.NULL : prefix) : (this.prefix = prefix == null ? BasedSequence.NULL : prefix);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable indent() {
        if (!this.passThrough) {
            this.line();
            this.rawIndent();
        }
        return this;
    }

    private void rawIndent() {
        this.prefixStack.push(this.prefixAfterEol);
        this.prefixAfterEol = this.prefix = LineAppendable.combinedPrefix(this.prefixAfterEol, this.indentPrefix);
        this.indentPrefixStack.push(true);
    }

    private void rawUnIndent() {
        if (this.prefixStack.isEmpty()) {
            throw new IllegalStateException("unIndent with an empty stack");
        }
        if (!this.indentPrefixStack.peek().booleanValue()) {
            throw new IllegalStateException("unIndent for an element added by pushPrefix(), use popPrefix() instead");
        }
        this.prefixAfterEol = this.prefix = this.prefixStack.pop();
        this.indentPrefixStack.pop();
    }

    @Override
    @NotNull
    public LineAppendable unIndent() {
        if (!this.passThrough) {
            this.line();
            this.rawUnIndent();
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable unIndentNoEol() {
        if (!this.passThrough) {
            if (this.endsWithEOL()) {
                this.rawUnIndent();
            } else {
                CharSequence prefix = this.prefix;
                this.rawUnIndent();
                this.prefixAfterEol = this.prefix;
                this.prefix = prefix;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable pushPrefix() {
        if (!this.passThrough) {
            this.prefixStack.push(this.prefixAfterEol);
            this.indentPrefixStack.push(false);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable popPrefix(boolean afterEol) {
        if (!this.passThrough) {
            if (this.prefixStack.isEmpty()) {
                throw new IllegalStateException("popPrefix with an empty stack");
            }
            if (this.indentPrefixStack.peek().booleanValue()) {
                throw new IllegalStateException("popPrefix for element added by indent(), use unIndent() instead");
            }
            this.prefixAfterEol = this.prefixStack.pop();
            if (!afterEol) {
                this.prefix = this.prefixAfterEol;
            }
            this.indentPrefixStack.pop();
        }
        return this;
    }

    @NotNull
    LineInfo getLastLineInfo() {
        return this.lines.isEmpty() ? LineInfo.NULL : this.lines.get(this.lines.size() - 1);
    }

    private boolean isTrailingBlankLine() {
        return this.appendable.length() == 0 && this.getLastLineInfo().isBlankText();
    }

    int lastNonBlankLine(int endLine) {
        LineInfo lineInfo;
        if (endLine > this.lines.size() && this.appendable.length() > 0 && !this.allWhitespace) {
            return this.lines.size();
        }
        int i = Math.min(this.lines.size(), endLine);
        while (i-- > 0 && (lineInfo = this.lines.get(i)).isBlankText()) {
        }
        return i;
    }

    @Override
    public int getTrailingBlankLines(int endLine) {
        endLine = Math.min(this.lines.size(), endLine);
        return endLine - this.lastNonBlankLine(endLine) - 1;
    }

    @Override
    public boolean endsWithEOL() {
        return this.appendable.length() == 0 && this.getLastLineInfo().isNotNull();
    }

    private LineInfo getLineRange(int start, int end, CharSequence prefix) {
        BasedSequence text;
        assert (start <= end);
        Object sequence = this.appendable.toSequence();
        Object eol = SequenceUtils.trimmedEOL(sequence);
        if (eol == null || eol.length() == 0) {
            eol = "\n";
        }
        CharSequence charSequence = text = start == Range.NULL.getStart() && end == Range.NULL.getEnd() ? BasedSequence.NULL : sequence.subSequence(start, Math.max(start, end - Math.max(0, eol.length() - 1)));
        if (start >= end) {
            prefix = SequenceUtils.trimEnd(prefix);
        }
        Object line = this.appendable.getBuilder().append(prefix).append(text).append((CharSequence)eol).toSequence();
        LineInfo.Preformatted preformatted = this.preFormattedNesting > 0 ? (this.preFormattedFirstLine == this.lines.size() ? LineInfo.Preformatted.FIRST : LineInfo.Preformatted.BODY) : (this.preFormattedFirstLine == this.lines.size() ? LineInfo.Preformatted.LAST : LineInfo.Preformatted.NONE);
        return LineInfo.create(line, this.getLastLineInfo(), prefix.length(), text.length(), line.length(), SequenceUtils.isBlank(prefix), this.allWhitespace || text.length() == 0, preformatted);
    }

    private void resetBuilder() {
        this.appendable = this.appendable.getBuilder();
        this.allWhitespace = true;
        this.lastWasWhitespace = true;
    }

    private void addLineRange(int start, int end, CharSequence prefix) {
        this.lines.add(this.getLineRange(start, end, prefix));
        this.resetBuilder();
    }

    private void appendEol(@NotNull CharSequence eol) {
        this.appendable.append(eol);
        int endOffset = this.appendable.length();
        this.addLineRange(0, endOffset - eol.length(), this.prefix);
        this.eolOnFirstText = 0;
        this.rawIndentsOnFirstEol();
    }

    private void rawIndentsOnFirstEol() {
        this.prefix = this.prefixAfterEol;
        while (!this.indentsOnFirstEol.isEmpty()) {
            Runnable runnable = this.indentsOnFirstEol.remove(this.indentsOnFirstEol.size() - 1);
            this.rawIndent();
            runnable.run();
        }
    }

    private void appendEol(int count) {
        while (count-- > 0) {
            this.appendEol(BasedSequence.EOL);
        }
    }

    private boolean isPrefixed(int currentLine) {
        return this.any(F_PREFIX_PRE_FORMATTED) || this.preFormattedFirstLine == currentLine || this.preFormattedNesting == 0 && this.preFormattedLastLine != currentLine;
    }

    private Pair<Range, CharSequence> getRangePrefixAfterEol() {
        int startOffset = 0;
        int endOffset = this.appendable.length() + 1;
        int currentLine = this.lines.size();
        boolean needPrefix = this.isPrefixed(currentLine);
        if (this.passThrough) {
            return new Pair((Object)Range.of(startOffset, endOffset - 1), (Object)(needPrefix ? this.prefix : BasedSequence.NULL));
        }
        if (this.allWhitespace && this.preFormattedNesting == 0 && this.preFormattedFirstLine != currentLine && this.preFormattedLastLine != currentLine) {
            if (!this.any(F_TRIM_LEADING_EOL) || !this.lines.isEmpty()) {
                return new Pair((Object)Range.of(startOffset, endOffset - 1), (Object)this.prefix);
            }
            return new Pair((Object)Range.NULL, (Object)BasedSequence.NULL);
        }
        if (this.isTrimTrailingWhitespace() && this.preFormattedNesting == 0) {
            if (this.allWhitespace) {
                startOffset = endOffset - 1;
            } else {
                endOffset -= SequenceUtils.countTrailingSpaceTab(this.appendable.toSequence(), endOffset - 1);
            }
        }
        if (this.preFormattedFirstLine == currentLine && startOffset > this.preFormattedFirstLineOffset) {
            startOffset = this.preFormattedFirstLineOffset;
        }
        if (this.preFormattedLastLine == currentLine && endOffset < this.preFormattedLastLineOffset + 1) {
            endOffset = this.preFormattedLastLineOffset + 1;
        }
        return new Pair((Object)Range.of(startOffset, endOffset - 1), (Object)(needPrefix ? this.prefix : BasedSequence.NULL));
    }

    private int offsetAfterEol() {
        Pair<Range, CharSequence> rangePrefixAfterEol = this.getRangePrefixAfterEol();
        LineInfo lastLineInfo = this.getLastLineInfo();
        if (((Range)rangePrefixAfterEol.getFirst()).isNull()) {
            return lastLineInfo.sumLength;
        }
        Range range = (Range)rangePrefixAfterEol.getFirst();
        CharSequence prefix = (CharSequence)rangePrefixAfterEol.getSecond();
        if (range.isEmpty() && prefix.length() != 0) {
            prefix = SequenceUtils.trimEnd(prefix);
        }
        return lastLineInfo.sumLength + ((Range)rangePrefixAfterEol.getFirst()).getSpan() + prefix.length();
    }

    private void doEolOnFirstTest() {
        if (this.eolOnFirstText > 0) {
            this.eolOnFirstText = 0;
            this.appendEol(BasedSequence.EOL);
        }
    }

    private void appendImpl(CharSequence s, int index) {
        char c = s.charAt(index);
        if (this.passThrough) {
            if (c == '\n') {
                this.appendEol(BasedSequence.EOL);
            } else {
                if (this.eolOnFirstText > 0) {
                    this.eolOnFirstText = 0;
                    this.appendEol(BasedSequence.EOL);
                }
                if (c != '\t' && c != ' ') {
                    this.allWhitespace = false;
                }
                this.appendable.append(c);
            }
        } else if (c == '\n') {
            Pair<Range, CharSequence> rangePrefixAfterEol = this.getRangePrefixAfterEol();
            Range textRange = (Range)rangePrefixAfterEol.getFirst();
            if (textRange.isNull()) {
                this.resetBuilder();
            } else {
                this.appendable.append(c);
                this.addLineRange(textRange.getStart(), textRange.getEnd(), (CharSequence)rangePrefixAfterEol.getSecond());
            }
            this.rawIndentsOnFirstEol();
        } else {
            this.doEolOnFirstTest();
            if (c == '\t') {
                if (this.preFormattedNesting == 0 && this.any(F_COLLAPSE_WHITESPACE)) {
                    if (!this.lastWasWhitespace) {
                        this.appendable.append(' ');
                        this.lastWasWhitespace = true;
                    }
                } else if (this.any(F_CONVERT_TABS)) {
                    int column = this.appendable.length();
                    int spaces = 4 - column % 4;
                    this.appendable.append(' ', spaces);
                } else {
                    this.appendable.append(s, index, index + 1);
                }
            } else if (c == ' ') {
                if (this.preFormattedNesting == 0) {
                    if (!this.any(F_TRIM_LEADING_WHITESPACE) || this.appendable.length() != 0 && !this.allWhitespace) {
                        if (this.any(F_COLLAPSE_WHITESPACE)) {
                            if (!this.lastWasWhitespace) {
                                this.appendable.append(' ');
                            }
                        } else {
                            this.appendable.append(' ');
                        }
                    }
                } else {
                    this.appendable.append(s.subSequence(index, index + 1));
                }
                this.lastWasWhitespace = true;
            } else {
                this.allWhitespace = false;
                this.lastWasWhitespace = false;
                this.appendable.append(s, index, index + 1);
            }
        }
    }

    private void appendImpl(CharSequence csq, int start, int end) {
        int i = start;
        while (i < end) {
            this.appendImpl(csq, i++);
        }
    }

    @Override
    @NotNull
    public LineAppendable append(@NotNull CharSequence csq) {
        if (csq.length() > 0) {
            this.appendImpl(csq, 0, csq.length());
        } else {
            this.appendable.append(csq);
        }
        return this;
    }

    @Override
    @NotNull
    public ISequenceBuilder<?, ?> getBuilder() {
        return this.appendable.getBuilder();
    }

    @Override
    @NotNull
    public LineAppendable append(@NotNull CharSequence csq, int start, int end) {
        if (start < end) {
            this.appendImpl(csq, start, end);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable append(char c) {
        this.appendImpl(Character.toString(c), 0);
        return this;
    }

    @Override
    @NotNull
    public LineAppendable append(char c, int count) {
        this.append(RepeatedSequence.repeatOf(c, count));
        return this;
    }

    @NotNull
    public LineAppendable repeat(@NotNull CharSequence csq, int count) {
        this.append(RepeatedSequence.repeatOf(csq, count));
        return this;
    }

    @NotNull
    public LineAppendable repeat(@NotNull CharSequence csq, int start, int end, int count) {
        this.append(RepeatedSequence.repeatOf(csq.subSequence(start, end), count));
        return this;
    }

    @Override
    @NotNull
    public LineAppendable line() {
        if (this.preFormattedNesting > 0 || this.appendable.length() != 0) {
            this.appendImpl("\n", 0);
        } else {
            CharSequence savedPrefix = this.prefix;
            boolean hadRawIndents = !this.indentsOnFirstEol.isEmpty();
            this.rawIndentsOnFirstEol();
            if (hadRawIndents || savedPrefix.length() > 0 && this.prefix.length() == 0) {
                this.prefix = savedPrefix;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable lineWithTrailingSpaces(int count) {
        if (this.preFormattedNesting > 0 || this.appendable.length() != 0) {
            int options = this.options.toInt();
            this.options.andNotMask((long)(F_TRIM_TRAILING_WHITESPACE | F_COLLAPSE_WHITESPACE));
            if (count > 0) {
                this.append(' ', count);
            }
            this.appendImpl("\n", 0);
            this.options.setAll((long)options);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable lineIf(boolean predicate) {
        if (predicate) {
            this.line();
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable blankLine() {
        this.line();
        if (!this.lines.isEmpty() && !this.isTrailingBlankLine() || this.lines.isEmpty() && !this.any(F_TRIM_LEADING_EOL)) {
            this.appendEol(BasedSequence.EOL);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable blankLineIf(boolean predicate) {
        if (predicate) {
            this.blankLine();
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable blankLine(int count) {
        this.line();
        if (!this.any(F_TRIM_LEADING_EOL) || !this.lines.isEmpty()) {
            int addBlankLines = count - this.getTrailingBlankLines(this.lines.size());
            this.appendEol(addBlankLines);
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable lineOnFirstText(boolean value) {
        if (value) {
            ++this.eolOnFirstText;
        } else if (this.eolOnFirstText > 0) {
            --this.eolOnFirstText;
        }
        return this;
    }

    @Override
    @NotNull
    public LineAppendable removeIndentOnFirstEOL(@NotNull Runnable listener) {
        this.indentsOnFirstEol.remove(listener);
        return this;
    }

    @Override
    @NotNull
    public LineAppendable addIndentOnFirstEOL(@NotNull Runnable listener) {
        this.indentsOnFirstEol.add(listener);
        return this;
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public int getLineCountWithPending() {
        return this.appendable.length() == 0 ? this.lines.size() : this.lines.size() + 1;
    }

    @Override
    public int column() {
        return this.appendable.length();
    }

    @Override
    @NotNull
    public LineInfo getLineInfo(int lineIndex) {
        if (lineIndex == this.lines.size()) {
            if (this.appendable.length() == 0) {
                return LineInfo.NULL;
            }
            Pair<Range, CharSequence> rangePrefixAfterEol = this.getRangePrefixAfterEol();
            Range textRange = (Range)rangePrefixAfterEol.getFirst();
            if (textRange.isNull()) {
                return LineInfo.NULL;
            }
            return this.getLineRange(textRange.getStart(), textRange.getEnd(), (CharSequence)rangePrefixAfterEol.getSecond());
        }
        return this.lines.get(lineIndex);
    }

    @Override
    @NotNull
    public BasedSequence getLine(int lineIndex) {
        return this.getLineInfo(lineIndex).getLine();
    }

    @Override
    public int offset() {
        return this.getLastLineInfo().sumLength;
    }

    @Override
    public int offsetWithPending() {
        return this.offsetAfterEol();
    }

    @Override
    public boolean isPendingSpace() {
        return this.appendable.length() > 0 && this.lastWasWhitespace;
    }

    @Override
    public int getPendingSpace() {
        if (this.lastWasWhitespace && this.appendable.length() != 0) {
            return SequenceUtils.countTrailingSpaceTab(this.appendable.toSequence());
        }
        return 0;
    }

    @Override
    public int getPendingEOL() {
        if (this.appendable.length() == 0) {
            return this.getTrailingBlankLines(this.lines.size()) + 1;
        }
        return 0;
    }

    @Override
    public boolean isPreFormatted() {
        return this.preFormattedNesting > 0;
    }

    @Override
    @NotNull
    public LineAppendable openPreFormatted(boolean addPrefixToFirstLine) {
        if (this.preFormattedNesting == 0 && this.preFormattedFirstLine != this.lines.size()) {
            this.preFormattedFirstLine = this.lines.size();
            this.preFormattedFirstLineOffset = this.appendable.length();
        }
        ++this.preFormattedNesting;
        return this;
    }

    @Override
    @NotNull
    public LineAppendable closePreFormatted() {
        if (this.preFormattedNesting <= 0) {
            throw new IllegalStateException("closePreFormatted called with nesting == 0");
        }
        --this.preFormattedNesting;
        if (this.preFormattedNesting == 0 && !this.endsWithEOL()) {
            this.preFormattedLastLine = this.lines.size();
            this.preFormattedLastLineOffset = this.appendable.length();
        }
        return this;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        try {
            this.appendToNoLine(out, true, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    @Override
    @NotNull
    public String toString(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        StringBuilder out = new StringBuilder();
        try {
            this.appendTo(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, 0, Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    @Override
    @NotNull
    public CharSequence toSequence(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        ISequenceBuilder<?, ?> out = this.getBuilder();
        try {
            this.appendTo(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, 0, Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toSequence();
    }

    @Override
    public <T extends Appendable> T appendTo(@NotNull T out, boolean withPrefixes, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) throws IOException {
        this.line();
        return this.appendToNoLine(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
    }

    public <T extends Appendable> T appendToNoLine(@NotNull T out, boolean withPrefixes, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) throws IOException {
        boolean tailEOL = maxTrailingBlankLines >= 0;
        maxBlankLines = Math.max(0, maxBlankLines);
        maxTrailingBlankLines = Math.max(0, maxTrailingBlankLines);
        int endLinePending = this.lines.size();
        int iMax = Utils.min((int)this.getLineCountWithPending(), (int[])new int[]{endLine});
        int lastNonBlankLine = this.lastNonBlankLine(iMax);
        int consecutiveBlankLines = 0;
        for (int i = startLine; i < iMax; ++i) {
            boolean notDanglingLine;
            LineInfo info = this.getLineInfo(i);
            boolean bl = notDanglingLine = i < endLinePending;
            if (info.textLength == 0 && !info.isPreformatted()) {
                if (i > lastNonBlankLine) {
                    if (consecutiveBlankLines >= maxTrailingBlankLines) continue;
                    ++consecutiveBlankLines;
                    if (withPrefixes) {
                        out.append(this.isTrimTrailingWhitespace() ? SequenceUtils.trimEnd(info.getPrefix()) : info.getPrefix());
                    }
                    if (!notDanglingLine || !tailEOL && consecutiveBlankLines == maxTrailingBlankLines) continue;
                    out.append('\n');
                    continue;
                }
                if (consecutiveBlankLines >= maxBlankLines) continue;
                ++consecutiveBlankLines;
                if (withPrefixes) {
                    out.append(this.isTrimTrailingWhitespace() ? SequenceUtils.trimEnd(info.getPrefix()) : info.getPrefix());
                }
                if (!notDanglingLine) continue;
                out.append('\n');
                continue;
            }
            consecutiveBlankLines = 0;
            if (notDanglingLine && (tailEOL || i < lastNonBlankLine || info.isPreformatted() && info.getPreformatted() != LineInfo.Preformatted.LAST)) {
                if (withPrefixes) {
                    out.append(info.lineSeq);
                    continue;
                }
                out.append(info.getText());
                continue;
            }
            if (withPrefixes) {
                out.append(info.getLineNoEOL());
                continue;
            }
            out.append(info.getText());
        }
        return out;
    }

    @Override
    @NotNull
    public LineAppendable append(@NotNull LineAppendable lineAppendable, int startLine, int endLine, boolean withPrefixes) {
        int iMax = Math.min(endLine, lineAppendable.getLineCountWithPending());
        for (int i = startLine = Math.max(0, startLine); i < iMax; ++i) {
            LineInfo info = lineAppendable.getLineInfo(i);
            BasedSequence text = info.getTextNoEOL();
            BasedSequence prefix = withPrefixes ? info.getPrefix() : BasedSequence.NULL;
            CharSequence combinedPrefix = this.any(F_PREFIX_PRE_FORMATTED) || !info.isPreformatted() || info.getPreformatted() == LineInfo.Preformatted.FIRST ? LineAppendable.combinedPrefix(this.prefix, prefix) : prefix;
            this.appendable.append(text);
            this.allWhitespace = info.isBlankText();
            boolean bl = this.lastWasWhitespace = info.textLength == 0 || CharPredicate.SPACE_TAB.test(text.safeCharAt(info.textLength - 1));
            if (i < lineAppendable.getLineCount()) {
                this.appendable.append('\n');
                this.allWhitespace = info.isBlankText();
                int endOffset = this.appendable.length();
                this.addLineRange(0, endOffset - 1, combinedPrefix);
                continue;
            }
            this.prefix = combinedPrefix;
        }
        return this;
    }

    private int removeLinesRaw(int startLine, int endLine) {
        int useEndLine;
        int useStartLine = Utils.minLimit((int)startLine, (int[])new int[]{0});
        if (useStartLine < (useEndLine = Utils.maxLimit((int)endLine, (int[])new int[]{this.getLineCountWithPending()}))) {
            this.lines.subList(useStartLine, useEndLine).clear();
            ++this.modificationCount;
            return useStartLine;
        }
        if (endLine >= this.getLineCountWithPending() && this.appendable.length() > 0) {
            this.resetBuilder();
        }
        return this.lines.size();
    }

    void recomputeLineInfo(int startLine) {
        int iMax = this.lines.size();
        if ((startLine = Math.max(0, startLine)) < iMax) {
            LineInfo lastInfo = startLine - 1 >= 0 ? this.lines.get(startLine - 1) : LineInfo.NULL;
            for (int i = startLine; i < iMax; ++i) {
                LineInfo info = this.lines.get(i);
                lastInfo = LineInfo.create(lastInfo, info);
                this.lines.set(i, lastInfo);
                if (!lastInfo.needAggregateUpdate(info)) break;
            }
        }
    }

    @Override
    @NotNull
    public LineAppendable removeLines(int startLine, int endLine) {
        int useStartLine = this.removeLinesRaw(startLine, endLine);
        this.recomputeLineInfo(useStartLine);
        return this;
    }

    @Override
    public LineAppendable removeExtraBlankLines(int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) {
        maxBlankLines = Math.max(0, maxBlankLines);
        maxTrailingBlankLines = Math.max(0, maxTrailingBlankLines);
        int iMax = Utils.min((int)endLine, (int[])new int[]{this.getLineCountWithPending()});
        int consecutiveBlankLines = 0;
        int maxConsecutiveBlankLines = maxTrailingBlankLines;
        int minRemovedLine = this.getLineCountWithPending();
        int i = iMax;
        while (i-- > 0) {
            LineInfo info = this.getLineInfo(i);
            if (info.isBlankText() && !info.isPreformatted()) {
                if (consecutiveBlankLines >= maxConsecutiveBlankLines) {
                    minRemovedLine = this.removeLinesRaw(i + consecutiveBlankLines, i + consecutiveBlankLines + 1);
                    continue;
                }
                ++consecutiveBlankLines;
                continue;
            }
            consecutiveBlankLines = 0;
            maxConsecutiveBlankLines = maxBlankLines;
        }
        this.recomputeLineInfo(minRemovedLine);
        return this;
    }

    @Override
    public void setPrefixLength(int lineIndex, int prefixLength) {
        if (lineIndex == this.lines.size() && this.appendable.length() > 0) {
            this.line();
        }
        LineInfo info = this.lines.get(lineIndex);
        CharSequence line = info.lineSeq;
        if (prefixLength < 0 || prefixLength > info.getTextEnd()) {
            throw new IllegalArgumentException(String.format("prefixLength %d is out of valid range [0, %d) for the line", prefixLength, info.getTextEnd() + 1));
        }
        if (prefixLength != info.prefixLength) {
            CharSequence prefix = line.subSequence(0, prefixLength);
            LineInfo newInfo = LineInfo.create(info.lineSeq, lineIndex == 0 ? LineInfo.NULL : this.lines.get(lineIndex - 1), prefix.length(), info.prefixLength + info.textLength - prefixLength, info.length, SequenceUtils.isBlank(prefix), SequenceUtils.isBlank(line.subSequence(prefixLength, info.getTextEnd())), info.getPreformatted());
            this.lines.set(lineIndex, newInfo);
            this.recomputeLineInfo(lineIndex + 1);
        }
    }

    private LineInfo createLineInfo(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence content) {
        LineInfo prevInfo = lineIndex == 0 ? LineInfo.NULL : this.lines.get(lineIndex - 1);
        LineInfo info = lineIndex == this.lines.size() ? LineInfo.NULL : this.lines.get(lineIndex);
        CharSequence text = content;
        CharSequence eol = SequenceUtils.trimmedEOL(content);
        if (eol == null) {
            eol = "\n";
        } else {
            text = text.subSequence(0, text.length() - eol.length());
        }
        if (text.length() == 0) {
            prefix = SequenceUtils.trimEnd(prefix);
        }
        assert (!SequenceUtils.containsAny(text, CharPredicate.ANY_EOL)) : String.format("Line text should not contain any EOL, text: %s", SequenceUtils.toVisibleWhitespaceString(text));
        Object line = this.appendable.getBuilder().append(prefix).append(text).append(eol).toSequence();
        LineInfo.Preformatted preformatted = info.isNotNull() ? info.getPreformatted() : (prevInfo.isPreformatted() && prevInfo.getPreformatted() != LineInfo.Preformatted.LAST ? LineInfo.Preformatted.BODY : LineInfo.Preformatted.NONE);
        return LineInfo.create(line, prevInfo, prefix.length(), text.length(), line.length(), SequenceUtils.isBlank(prefix), SequenceUtils.isBlank(text), preformatted);
    }

    @Override
    public void setLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence content) {
        if (lineIndex == this.lines.size() && this.appendable.length() > 0) {
            this.line();
        }
        this.lines.set(lineIndex, this.createLineInfo(lineIndex, prefix, content));
        this.recomputeLineInfo(lineIndex + 1);
    }

    @Override
    public void insertLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence content) {
        this.lines.add(lineIndex, this.createLineInfo(lineIndex, prefix, content));
        this.recomputeLineInfo(lineIndex + 1);
    }

    int tailBlankLinesToRemove(int endLine, int maxTrailingBlankLines) {
        return Utils.max((int)0, (int[])new int[]{this.getTrailingBlankLines(endLine) - Utils.max((int)0, (int[])new int[]{maxTrailingBlankLines})});
    }

    @NotNull
    IndexedLineInfoProxy getIndexedLineInfoProxy(int maxTrailingBlankLines, int startLine, int endLine) {
        return new IndexedLineInfoProxy(this, maxTrailingBlankLines, startLine, endLine);
    }

    @NotNull
    IndexedLineProxy getIndexedLineProxy(int maxTrailingBlankLines, int startLine, int endLine, boolean withPrefixes) {
        return new IndexedLineProxy(this.getIndexedLineInfoProxy(maxTrailingBlankLines, startLine, endLine), withPrefixes);
    }

    @Override
    @NotNull
    public Iterator<LineInfo> iterator() {
        return new IndexedItemIterator((Indexed)this.getIndexedLineInfoProxy(Integer.MAX_VALUE, 0, this.getLineCount()));
    }

    @Override
    @NotNull
    public Iterable<BasedSequence> getLines(int maxTrailingBlankLines, int startLine, int endLine, boolean withPrefixes) {
        return new IndexedItemIterable((Indexed)this.getIndexedLineProxy(maxTrailingBlankLines, startLine, endLine, withPrefixes));
    }

    @Override
    @NotNull
    public Iterable<LineInfo> getLinesInfo(int maxTrailingBlankLines, int startLine, int endLine) {
        return new IndexedItemIterable((Indexed)this.getIndexedLineInfoProxy(maxTrailingBlankLines, startLine, endLine));
    }

    static class IndexedLineProxy
    implements Indexed<BasedSequence> {
        @NotNull
        final IndexedLineInfoProxy proxy;
        final boolean withPrefixes;

        public IndexedLineProxy(@NotNull IndexedLineInfoProxy proxy, boolean withPrefixes) {
            this.proxy = proxy;
            this.withPrefixes = withPrefixes;
        }

        public BasedSequence get(int index) {
            if (this.proxy.maxTrailingBlankLines == -1 && index + 1 == this.proxy.size()) {
                return this.withPrefixes ? this.proxy.get(index).getLineNoEOL() : this.proxy.get(index).getTextNoEOL();
            }
            return this.withPrefixes ? this.proxy.get(index).getLine() : this.proxy.get(index).getText();
        }

        public void set(int index, BasedSequence item) {
            if (this.withPrefixes) {
                this.proxy.appendable.setLine(index + this.proxy.startLine, BasedSequence.NULL, item);
            } else {
                this.proxy.appendable.setLine(index + this.proxy.startLine, this.proxy.appendable.getLineInfo(index + this.proxy.startLine).getPrefix(), item);
            }
        }

        public void removeAt(int index) {
            this.proxy.removeAt(index);
        }

        public int size() {
            return this.proxy.size();
        }

        public int modificationCount() {
            return this.proxy.modificationCount();
        }
    }

    static class IndexedLineInfoProxy
    implements Indexed<LineInfo> {
        @NotNull
        final LineAppendableImpl appendable;
        final int startLine;
        final int endLine;
        final int maxTrailingBlankLines;

        public IndexedLineInfoProxy(@NotNull LineAppendableImpl appendable, int maxTrailingBlankLines, int startLine, int endLine) {
            this.appendable = appendable;
            this.startLine = startLine;
            this.endLine = Math.min(endLine, appendable.getLineCountWithPending());
            this.maxTrailingBlankLines = maxTrailingBlankLines;
        }

        @NotNull
        public LineInfo get(int index) {
            if (index + this.startLine >= this.endLine) {
                throw new IndexOutOfBoundsException(String.format("index %d is out of valid range [%d, %d)", index, this.startLine, this.endLine));
            }
            return this.appendable.getLineInfo(index + this.startLine);
        }

        public void set(int index, @NotNull LineInfo item) {
            if (index + this.startLine >= this.endLine) {
                throw new IndexOutOfBoundsException(String.format("index %d is out of valid range [%d, %d)", index, this.startLine, this.endLine));
            }
            this.appendable.lines.set(this.startLine + index, item);
            this.appendable.recomputeLineInfo(this.startLine + index + 1);
        }

        public void removeAt(int index) {
            if (index + this.startLine >= this.endLine) {
                throw new IndexOutOfBoundsException(String.format("index %d is out of valid range [%d, %d)", index, this.startLine, this.endLine));
            }
            this.appendable.removeLines(index + this.startLine, index + 1);
        }

        public int size() {
            int removeBlankLines = this.appendable.tailBlankLinesToRemove(this.endLine, this.maxTrailingBlankLines);
            return Math.max(0, this.endLine - this.startLine - removeBlankLines);
        }

        public int modificationCount() {
            return this.appendable.modificationCount;
        }
    }
}

