/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.bridge.BridgingServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

public class BridgingServerInstanceProvider
implements ServerInstanceProvider,
InstanceListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Server server;
    private Map<ServerInstance, BridgingServerInstance> instances = new HashMap<ServerInstance, BridgingServerInstance>();

    public BridgingServerInstanceProvider(Server server) {
        assert (server != null) : "Server must not be null";
        this.server = server;
    }

    public final void addInstanceListener() {
        ServerRegistry.getInstance().addInstanceListener(this);
    }

    public final void removeInstanceListener() {
        ServerRegistry.getInstance().removeInstanceListener(this);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
    }

    @Override
    public void instanceAdded(String serverInstanceID) {
        if (this.server.handlesUri(serverInstanceID)) {
            this.changeSupport.fireChange();
        }
    }

    @Override
    public void instanceRemoved(String serverInstanceID) {
        InstanceProperties props = InstanceProperties.getInstanceProperties(serverInstanceID);
        if (this.server.handlesUri(serverInstanceID) && (props == null || this.isRegisteredWithUI(props))) {
            this.changeSupport.fireChange();
        }
    }

    public synchronized List<org.netbeans.api.server.ServerInstance> getInstances() {
        this.refreshCache();
        ArrayList<org.netbeans.api.server.ServerInstance> instancesList = new ArrayList<org.netbeans.api.server.ServerInstance>(this.instances.size());
        for (BridgingServerInstance instance : this.instances.values()) {
            instancesList.add(instance.getCommonInstance());
        }
        return instancesList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgingServerInstanceProvider other = (BridgingServerInstanceProvider)obj;
        return this.server == other.server || this.server != null && this.server.equals(other.server);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.server != null ? this.server.hashCode() : 0);
        return hash;
    }

    public synchronized org.netbeans.api.server.ServerInstance getBridge(ServerInstance instance) {
        this.refreshCache();
        BridgingServerInstance bridgingInstance = this.instances.get(instance);
        return bridgingInstance == null ? null : bridgingInstance.getCommonInstance();
    }

    private synchronized void refreshCache() {
        ArrayList<ServerInstance> toRemove = new ArrayList<ServerInstance>(this.instances.keySet());
        for (ServerInstance instance : ServerRegistry.getInstance().getServerInstances()) {
            if (!instance.getServer().equals(this.server) || !this.isRegisteredWithUI(instance.getInstanceProperties())) continue;
            if (!this.instances.containsKey(instance)) {
                this.instances.put(instance, BridgingServerInstance.createInstance(instance));
                continue;
            }
            toRemove.remove(instance);
        }
        this.instances.keySet().removeAll(toRemove);
    }

    private boolean isRegisteredWithUI(InstanceProperties props) {
        String withoutUI = props.getProperty("registeredWithoutUI");
        if (withoutUI == null) {
            return true;
        }
        return Boolean.valueOf(withoutUI) == false;
    }
}

