/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;

public class StringFilter {
    ArrayList<Pattern> filter = new ArrayList();

    public void addReplaceFilter(String begin, String end, String replace) {
        this.filter.add(new Pattern(begin, end, replace));
    }

    public void addReplaceAllFilter(String find, String replace) {
        this.filter.add(new Pattern(find, find, replace));
    }

    public String filter(String str) {
        for (int i = 0; i < this.filter.size(); ++i) {
            Pattern p = this.filter.get(i);
            if (p == null) continue;
            str = StringFilter.replaceString(str, p.begin, p.end, p.replace);
        }
        return str;
    }

    public static String replaceString(String original, String begin, String end, String replace) {
        boolean replaceAll = false;
        int offset = 0;
        if (StringFilter.isEmpty(original) || StringFilter.isEmpty(begin) && StringFilter.isEmpty(end)) {
            return original;
        }
        if (begin.equals(end)) {
            replaceAll = true;
        }
        do {
            int to;
            int from;
            int n = from = StringFilter.isEmpty(begin) ? 0 : original.indexOf(begin, offset);
            if (from < 0) break;
            if (StringFilter.isEmpty(end)) {
                to = original.length();
            } else {
                to = original.indexOf(end, from);
                if (to < 0) break;
                to += end.length();
            }
            original = original.substring(0, from) + replace + original.substring(to);
            offset = from + replace.length();
        } while (replaceAll);
        return original;
    }

    public static String replaceStringAll(String original, String find, String replace) {
        return StringFilter.replaceString(original, find, find, replace);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterLinesToStream(String input, PrintStream output) {
        BufferedReader br = new BufferedReader(new StringReader(input));
        try {
            String str;
            while ((str = br.readLine()) != null) {
                str = this.filter(str);
                output.println(str);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class Pattern {
        private String begin;
        private String end;
        private String replace;

        public Pattern(String begin, String end, String replace) {
            this.begin = begin;
            this.end = end;
            this.replace = replace;
        }
    }
}

