/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Alsace for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_42 : {
					width : 63.03125,
					height : 109.81562,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -312.72695;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3237.8284;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-67" : "m 11.66,0.12 c -0.37,0.18 -0.73,0.31 -1.14,0.21 -0.68,0.44 0.56,1.19 -0.11,1.65 -0.69,0.67 -1.14,1.59 -0.98,2.54 -0.29,0.63 -0.73,1.22 -0.67,1.96 -0.33,0.39 -0.25,0.99 -0.34,1.4 -0.66,-0.01 -1.81,-0.58 -1.97,0.46 -0.11,0.85 -0.87,1.34 -1.19,2.05 -0.04,0.69 0.03,1.86 1,1.73 1.43,0.19 2.46,1.2 3.69,1.83 0.54,0.15 1.73,-0.26 1.61,0.67 -0.39,0.76 -1.6,0.18 -2.06,0.63 0.19,0.56 -0.32,1.43 0.15,1.84 0.4,0.19 1.52,0.06 1.44,0.7 -0.29,0.2 -1.21,0.56 -0.58,0.93 1.03,0.02 1.92,-0.67 2.44,-1.49 0.6,-0.25 0.74,-0.85 0.58,-1.41 0.12,-0.89 1.35,-0.35 1.78,-0.93 0.65,0.04 0.54,0.8 0.65,1.22 0.65,0.48 1.61,0.05 2.23,0.65 0.23,0.23 1.07,-0.27 0.72,0.29 -0.63,0.37 -0.04,1.21 0.53,0.97 0.79,0.18 0.98,0.91 1.28,1.53 0.44,0.57 0.93,1.1 0.14,1.58 -0.65,0.89 -0.78,2.04 -1.45,2.93 -0.1,0.53 -0.23,1.07 -0.85,1.23 -0.49,0.58 0.42,1.34 0.84,1.74 0.37,0.46 1.13,0.19 1.49,0.5 -0.23,0.88 -1.33,1.42 -1.25,2.43 -0.42,1.07 -0.55,2.26 -1.39,3.14 -0.53,0.66 -0.95,1.66 -1.94,1.58 -0.59,0.32 -0.59,1.24 -1.39,1.35 -0.89,0.44 -1.82,0.06 -2.68,-0.17 -0.59,0.16 -1.21,0.11 -1.79,0.27 -0.51,0.5 0.39,0.93 0.84,0.77 0.7,-0.19 1.89,0.26 1.42,1.13 -0.39,0.13 -1.66,-0.31 -1.28,0.5 0.35,0.37 1.38,0.41 1.05,1.13 -0.38,0.79 -0.63,1.62 -0.51,2.49 -0.42,0.71 -0.48,1.59 -0.59,2.39 -0.4,0.67 1.11,1.1 0.46,1.81 -0.21,0.57 -1.7,1.38 -0.65,1.72 0.91,0.31 1.62,1.44 2.69,0.93 0.39,-0.16 1.37,-0.73 1.55,-0.06 -0.22,0.63 0.45,0.86 0.66,1.38 1.32,0.89 3.56,-0.09 4.37,1.63 0.46,0.36 -0.04,1.42 0.76,1.32 0.22,0.04 1.08,-0.29 1.02,0.06 -0.42,0.3 -1.13,1.18 -0.29,1.45 0.87,-0.03 1.73,0.05 2.48,0.58 1.49,0.75 2.98,1.47 4.45,2.26 0.15,0.94 -0.48,2.32 0.18,2.99 0.48,0.34 1.55,0.2 1.77,0.82 -0.16,0.69 0.08,1.53 0.94,1.47 0.92,0.22 2.43,0.46 2.73,-0.77 0.65,-2.53 2.1,-4.78 3.78,-6.75 0.76,-1.3 0.16,-3.02 0.85,-4.31 0.76,-0.84 2.51,-1.21 2.22,-2.65 -0.54,-1.88 -0.81,-4 0.13,-5.82 0.51,-1.07 1.12,-2.22 0.84,-3.45 0.43,-1.03 2.25,-1.25 1.72,-2.64 -0.01,-1.97 -0.69,-4.11 0.42,-5.9 0.43,-1.06 0.86,-2.26 2.05,-2.66 1.61,-1.23 3.39,-2.52 4.38,-4.3 0.43,-0.67 -0.16,-2.04 0.91,-2.18 0.78,-0.21 2.18,0.3 2.04,-0.96 0.08,-1.56 2.11,-1.12 2.93,-2.04 1.34,-1.51 1.1,-3.77 2.18,-5.46 0.75,-1.55 1.8,-2.98 2.64,-4.45 0.35,-0.48 1.48,-0.64 1.4,-1.29 -0.98,-0.16 -2.08,-0.12 -3.08,-0.48 -1.13,-0.44 -2.41,-0.45 -3.49,-0.95 -1.44,-1.03 -2.93,-2.05 -4.7,-2.43 -0.74,-0.38 -1.15,-1.38 -2.15,-1.2 -0.55,-0.12 -0.77,0.8 -1.22,0.31 -1.02,-0.13 -2.17,0.62 -3.14,-0.1 -0.76,-0.34 -1.47,-1.35 -2.29,-0.59 -0.92,0.6 -2.04,0.62 -3.03,0.14 -1.08,-0.17 -2.14,0.85 -3.19,0.19 -0.87,0.05 -1.42,1.09 -1.69,1.83 -0.22,0.78 -0.88,1.41 -0.94,2.26 -0.33,0.69 -0.3,1.54 -1.04,2 -0.56,0.26 -0.33,1.28 -1.09,1.14 -0.68,-0.13 -1.19,-0.71 -1.94,-0.7 -0.84,-0.26 -1.19,-1.37 -2.2,-1.26 -1.04,-0.03 -2,0.42 -2.92,0.77 -0.94,-0.09 -1.89,-0.01 -2.73,0.44 -0.74,0.2 -1.04,-0.83 -1.74,-0.81 -0.04,-0.67 -0.44,-1.28 -1.17,-1.43 -0.8,-0.51 -1.7,-0.46 -2.5,-0.04 -0.38,-0.34 -0.77,-0.77 -1.25,-0.98 -0.47,-0.96 -1.79,-0.28 -2.48,-0.79 -0.42,-1.02 -0.72,-2.1 -1.22,-3.08 -0.2,-0.39 -0.02,-0.69 0.32,-0.88 0.13,-0.28 -0.2,-0.5 -0.44,-0.46 z",
					    "department-68" : "m 16.65,50.64 c -0.59,0.02 -0.78,0.77 -1.4,0.75 -0.44,0.18 0,0.74 -0.42,0.98 -0.37,0.45 -0.39,1.07 -0.91,1.42 -0.94,1.22 -0.91,2.92 -1.86,4.12 -0.1,0.68 -0.96,0.91 -1.18,1.57 -0.29,0.68 -0.45,1.41 -0.83,2.07 -0.27,0.43 7e-5,1.05 0.55,0.96 0.6,-0.04 0.2,0.78 0.11,1.08 -0.33,0.69 -0.83,1.27 -1.2,1.94 -0.52,0.52 -1.27,0.92 -1.36,1.72 -0.21,0.42 -0.74,0.89 -0.39,1.38 -0.16,0.67 -0.9,1.1 -1.32,1.62 -0.35,0.3 -0.7,0.56 -1.09,0.8 -0.42,0.1 -1.09,-0.1 -0.88,0.61 0.09,0.56 -0.07,1.05 -0.48,1.42 -0.59,0.99 -0.29,2.25 -0.58,3.28 0.21,0.34 0.4,0.73 0.14,1.11 -0.14,0.52 -0.78,0.66 -0.98,1.1 0.36,0.52 0.09,1.3 0.58,1.78 0.31,0.31 0.35,0.96 -0.19,1.01 -0.45,0.37 -0.72,0.97 -1.38,1.03 -0.51,0.25 -1.45,0.23 -1.61,0.88 0.19,0.76 0.5,1.62 1.13,2.11 0.82,0.42 1.79,0.3 2.55,0.83 1.24,0.22 2.03,1.45 3.29,1.69 0.6,0.08 1.02,0.47 1.3,0.98 0.25,0.3 0.72,0.65 0.37,1.06 -0.34,0.59 -0.01,1.15 0.22,1.69 0.22,0.67 0.29,1.42 -0.04,2.06 -0.07,0.28 0.11,0.77 -0.36,0.66 -0.49,-0.07 -0.72,0.36 -0.66,0.79 -0.31,0.66 -0.48,1.42 -0.23,2.14 0.08,0.55 0.69,0.96 1.11,0.44 0.72,-0.31 1.81,-0.28 2.33,0.36 0.06,0.56 0.32,1.14 0.75,1.47 0.39,0.39 0.09,1.13 0.54,1.44 1.16,0.4 1.57,1.96 0.9,2.97 -0.13,0.6 0.71,0.81 1.14,1.01 0.52,0.2 1.28,-0.38 1.65,0.11 -0.54,0.87 -0.99,2.02 -0.7,3.05 0.57,0.88 2.01,-0.05 2.52,0.84 0.08,0.53 0.4,1.23 0.96,0.6 0.95,-0.48 2.03,-0.83 3.07,-1 1.16,0.3 2.57,0.74 3.6,-0.11 0.84,-0.34 1.27,-1.31 2.11,-1.65 0.52,-0.57 -0.41,-1.08 -0.72,-1.5 -0.33,-0.38 0.19,-0.74 0.57,-0.56 0.66,0.14 1.35,0.98 2.03,0.38 0.67,-0.34 0.68,-1.17 0.26,-1.71 -0.24,-0.49 0.6,-0.32 0.84,-0.37 0.85,-0.02 0.57,-1.35 -0.17,-1.31 -0.4,0 -0.65,-0.29 -0.26,-0.54 0.56,-0.68 1.73,-0.55 2.11,-1.38 -0.03,-0.87 1.24,-0.7 1.72,-1.03 0.25,-1.14 -0.58,-2.03 -0.94,-3 -0.42,-1.27 -2.11,-1.71 -2.34,-3.1 -0.24,-0.85 -0.39,-1.97 0.5,-2.5 0.84,-0.6 1.02,-1.75 0.52,-2.63 -0.82,-1.67 -0.46,-3.7 0.71,-5.11 0.74,-0.83 0.08,-1.92 0.01,-2.85 0.26,-0.71 1.34,-0.86 1.31,-1.74 0.15,-0.82 -0.44,-1.8 0.4,-2.37 0.96,-1.01 1.95,-2.47 1.29,-3.9 -0.68,-1.43 -2.59,-2.27 -2.37,-4.06 0.01,-1.38 0.32,-2.75 0.41,-4.11 -0.43,-0.5 -1.27,-0.24 -1.84,-0.46 -0.53,-0.04 -1.15,-0.44 -0.95,-1.06 0.42,-0.91 -0.76,-0.84 -1.31,-1.08 -0.34,-0.15 -1.01,-0.2 -0.79,-0.75 0.02,-0.81 0.41,-1.81 -0.15,-2.51 -0.76,-0.44 -1.51,-0.92 -2.38,-1.19 -1.2,-0.64 -2.38,-1.75 -3.85,-1.45 -0.51,0 -0.99,-0.5 -0.77,-1.03 0.14,-0.64 -0.82,-0.34 -0.88,-0.8 0.39,-0.82 -0.44,-1.56 -1.03,-1.99 -0.75,-0.14 -1.56,0.01 -2.26,-0.38 -0.18,-0.05 -0.38,-0.09 -0.57,-0.08 z"
					}
				}
			}
		}
	);
})(jQuery);