/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateError;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;

public class OracleJdbcHelper {
    public static boolean isUsable(ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            classLoaderService.classForName("oracle.jdbc.OracleConnection");
            return true;
        }
        catch (ClassLoadingException ex) {
            return false;
        }
    }

    public static boolean isOsonAvailable(ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            classLoaderService.classForName("oracle.jdbc.provider.oson.OsonFactory");
            return true;
        }
        catch (ClassLoadingException ex) {
            return false;
        }
    }

    public static JdbcTypeConstructor getArrayJdbcTypeConstructor(ServiceRegistry serviceRegistry) {
        return (JdbcTypeConstructor)OracleJdbcHelper.create(serviceRegistry, "org.hibernate.dialect.type.OracleArrayJdbcTypeConstructor");
    }

    public static JdbcTypeConstructor getNestedTableJdbcTypeConstructor(ServiceRegistry serviceRegistry) {
        return (JdbcTypeConstructor)OracleJdbcHelper.create(serviceRegistry, "org.hibernate.dialect.type.OracleNestedTableJdbcTypeConstructor");
    }

    public static JdbcType getStructJdbcType(ServiceRegistry serviceRegistry) {
        return (JdbcType)OracleJdbcHelper.create(serviceRegistry, "org.hibernate.dialect.type.OracleStructJdbcType");
    }

    private static <X> X create(ServiceRegistry serviceRegistry, String className) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        try {
            return (X)classLoaderService.classForName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateError("Class does not have an empty constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateError("Could not construct JdbcType", e);
        }
    }
}

