/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.Comparator;
import java.util.stream.Stream;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.ResourceTypeSelector;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.provider.Provider;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.utils.StringUtil;

public interface WorkflowProvider
extends Provider {
    public ResourceTypeSelector getResourceTypeSelector(ResourceType var1);

    public Workflow toModel(WorkflowRepresentation var1);

    public Workflow getWorkflow(String var1);

    public void removeWorkflow(Workflow var1);

    public Stream<Workflow> getWorkflows();

    default public Stream<Workflow> getWorkflows(String search, Boolean exact, Integer first, Integer max) {
        return this.getWorkflows().sorted(Comparator.comparing(Workflow::getName)).filter(workflow -> {
            if (StringUtil.isBlank((String)search)) {
                return true;
            }
            return Boolean.TRUE.equals(exact) ? workflow.getName().equals(search) : workflow.getName().toLowerCase().contains(search.toLowerCase());
        }).skip(first.intValue()).limit(max.intValue());
    }

    public Stream<WorkflowRepresentation> getScheduledWorkflowsByResource(String var1);

    public WorkflowRepresentation toRepresentation(Workflow var1);

    public void updateWorkflow(Workflow var1, WorkflowRepresentation var2);

    public void activate(Workflow var1, ResourceType var2, String var3);

    public void deactivate(Workflow var1, String var2);

    public void submit(WorkflowEvent var1);

    public void runScheduledSteps();

    public void activateForAllEligibleResources(Workflow var1);
}

