/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.LinkedList;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@NamedQueries(value={@NamedQuery(name="getRealmUserByUsername", query="select u from UserEntity u where u.username = :username and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByEmail", query="select u from UserEntity u where u.email = :email and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByLastName", query="select u from UserEntity u where u.lastName = :lastName and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByFirstLastName", query="select u from UserEntity u where u.firstName = :first and u.lastName = :last and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByServiceAccount", query="select u from UserEntity u where u.serviceAccountClientLink = :clientInternalId and u.realmId = :realmId"), @NamedQuery(name="getRealmUsersByAttributeNameAndValue", query="select u from UserEntity u join u.attributes attr where u.realmId = :realmId and attr.name = :name and attr.value = :value"), @NamedQuery(name="getRealmUsersByAttributeNameAndLongValue", query="select u from UserEntity u join u.attributes attr where u.realmId = :realmId and attr.name = :name and attr.longValueHash = :longValueHash"), @NamedQuery(name="deleteUsersByRealm", query="delete from UserEntity u where u.realmId = :realmId"), @NamedQuery(name="deleteUsersByRealmAndLink", query="delete from UserEntity u where u.realmId = :realmId and u.federationLink=:link"), @NamedQuery(name="unlinkUsers", query="update UserEntity u set u.federationLink = null where u.realmId = :realmId and u.federationLink=:link")})
@Entity
@Table(name="USER_ENTITY", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "USERNAME"}), @UniqueConstraint(columnNames={"REALM_ID", "EMAIL_CONSTRAINT"})})
@EnhancementInfo(version="7.1.4.Final", includesDirtyChecking=true, includesAssociationManagement=false)
public class UserEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Nationalized
    @Column(name="USERNAME")
    protected String username;
    @Nationalized
    @Column(name="FIRST_NAME")
    protected String firstName;
    @Column(name="CREATED_TIMESTAMP")
    protected Long createdTimestamp;
    @Nationalized
    @Column(name="LAST_NAME")
    protected String lastName;
    @Column(name="EMAIL")
    protected String email;
    @Column(name="ENABLED")
    protected boolean enabled;
    @Column(name="EMAIL_VERIFIED")
    protected boolean emailVerified;
    @Column(name="EMAIL_CONSTRAINT")
    protected String emailConstraint;
    @Column(name="REALM_ID")
    protected String realmId;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=false, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserAttributeEntity> attributes;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserRequiredActionEntity> requiredActions;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<CredentialEntity> credentials;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<FederatedIdentityEntity> federatedIdentities;
    @Column(name="FEDERATION_LINK")
    protected String federationLink;
    @Column(name="SERVICE_ACCOUNT_CLIENT_LINK")
    protected String serviceAccountClientLink;
    @Column(name="NOT_BEFORE")
    protected int notBefore;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient int $$_hibernate_instanceId;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public UserEntity() {
        this.$$_hibernate_write_emailConstraint(KeycloakModelUtils.generateId());
        this.$$_hibernate_write_attributes(new LinkedList());
        this.$$_hibernate_write_requiredActions(new LinkedList());
        this.$$_hibernate_write_credentials(new LinkedList());
        this.$$_hibernate_write_federatedIdentities(new LinkedList());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getUsername() {
        return this.$$_hibernate_read_username();
    }

    public void setUsername(String username) {
        this.$$_hibernate_write_username(username);
    }

    public Long getCreatedTimestamp() {
        return this.$$_hibernate_read_createdTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.$$_hibernate_write_createdTimestamp(timestamp);
    }

    public String getFirstName() {
        return this.$$_hibernate_read_firstName();
    }

    public void setFirstName(String firstName) {
        this.$$_hibernate_write_firstName(firstName);
    }

    public String getLastName() {
        return this.$$_hibernate_read_lastName();
    }

    public void setLastName(String lastName) {
        this.$$_hibernate_write_lastName(lastName);
    }

    public String getEmail() {
        return this.$$_hibernate_read_email();
    }

    public void setEmail(String email, boolean allowDuplicate) {
        this.$$_hibernate_write_email(email);
        this.$$_hibernate_write_emailConstraint(email == null || allowDuplicate ? KeycloakModelUtils.generateId() : email);
    }

    public boolean isEnabled() {
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(boolean enabled) {
        this.$$_hibernate_write_enabled(enabled);
    }

    public String getEmailConstraint() {
        return this.$$_hibernate_read_emailConstraint();
    }

    public void setEmailConstraint(String emailConstraint) {
        this.$$_hibernate_write_emailConstraint(emailConstraint);
    }

    public boolean isEmailVerified() {
        return this.$$_hibernate_read_emailVerified();
    }

    public void setEmailVerified(boolean emailVerified) {
        this.$$_hibernate_write_emailVerified(emailVerified);
    }

    public Collection<UserAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<UserAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public Collection<UserRequiredActionEntity> getRequiredActions() {
        if (this.$$_hibernate_read_requiredActions() == null) {
            this.$$_hibernate_write_requiredActions(new LinkedList());
        }
        return this.$$_hibernate_read_requiredActions();
    }

    public void setRequiredActions(Collection<UserRequiredActionEntity> requiredActions) {
        this.$$_hibernate_write_requiredActions(requiredActions);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public Collection<CredentialEntity> getCredentials() {
        if (this.$$_hibernate_read_credentials() == null) {
            this.$$_hibernate_write_credentials(new LinkedList());
        }
        return this.$$_hibernate_read_credentials();
    }

    public void setCredentials(Collection<CredentialEntity> credentials) {
        this.$$_hibernate_write_credentials(credentials);
    }

    public Collection<FederatedIdentityEntity> getFederatedIdentities() {
        if (this.$$_hibernate_read_federatedIdentities() == null) {
            this.$$_hibernate_write_federatedIdentities(new LinkedList());
        }
        return this.$$_hibernate_read_federatedIdentities();
    }

    public void setFederatedIdentities(Collection<FederatedIdentityEntity> federatedIdentities) {
        this.$$_hibernate_write_federatedIdentities(federatedIdentities);
    }

    public String getFederationLink() {
        return this.$$_hibernate_read_federationLink();
    }

    public void setFederationLink(String federationLink) {
        this.$$_hibernate_write_federationLink(federationLink);
    }

    public String getServiceAccountClientLink() {
        return this.$$_hibernate_read_serviceAccountClientLink();
    }

    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.$$_hibernate_write_serviceAccountClientLink(serviceAccountClientLink);
    }

    public int getNotBefore() {
        return this.$$_hibernate_read_notBefore();
    }

    public void setNotBefore(int notBefore) {
        this.$$_hibernate_write_notBefore(notBefore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserEntity)) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return this.$$_hibernate_read_id().equals(that.$$_hibernate_read_id());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public int $$_hibernate_getInstanceId() {
        return this.$$_hibernate_instanceId;
    }

    public void $$_hibernate_setInstanceId(int n) {
        this.$$_hibernate_instanceId = n;
    }

    public EntityEntry $$_hibernate_setPersistenceInfo(EntityEntry entityEntry, ManagedEntity managedEntity, ManagedEntity managedEntity2, int n) {
        UserEntity userEntity = this;
        EntityEntry entityEntry2 = entityEntry;
        ManagedEntity managedEntity3 = managedEntity;
        ManagedEntity managedEntity4 = managedEntity2;
        int n2 = n;
        userEntity = null;
        userEntity = this.$$_hibernate_entityEntryHolder;
        this.$$_hibernate_entityEntryHolder = entityEntry;
        this.$$_hibernate_previousManagedEntity = managedEntity;
        this.$$_hibernate_nextManagedEntity = managedEntity2;
        this.$$_hibernate_instanceId = n;
        return userEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        UserEntity userEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block12: {
            int n2;
            block13: {
                int n3;
                UserEntity userEntity = this;
                UserEntity userEntity2 = userEntity;
                UserEntity userEntity3 = userEntity2;
                UserEntity userEntity4 = userEntity3;
                int n4 = 0;
                if (n4 == 0 && userEntity3.$$_hibernate_collectionTracker != null) {
                    int n5 = userEntity3.$$_hibernate_collectionTracker.getSize("attributes");
                    if (userEntity3.attributes == null && n5 != -1) {
                        n4 = 1;
                    } else if (userEntity3.attributes != null && (!(userEntity3.attributes instanceof PersistentCollection) || ((PersistentCollection)userEntity3.attributes).wasInitialized()) && n5 != userEntity3.attributes.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && userEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = userEntity2.$$_hibernate_collectionTracker.getSize("requiredActions");
                    if (userEntity2.requiredActions == null && n4 != -1) {
                        n3 = 1;
                    } else if (userEntity2.requiredActions != null && (!(userEntity2.requiredActions instanceof PersistentCollection) || ((PersistentCollection)userEntity2.requiredActions).wasInitialized()) && n4 != userEntity2.requiredActions.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && userEntity.$$_hibernate_collectionTracker != null) {
                    n3 = userEntity.$$_hibernate_collectionTracker.getSize("credentials");
                    if (userEntity.credentials == null && n3 != -1) {
                        n2 = 1;
                    } else if (userEntity.credentials != null && (!(userEntity.credentials instanceof PersistentCollection) || ((PersistentCollection)userEntity.credentials).wasInitialized()) && n3 != userEntity.credentials.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block12;
                n2 = this.$$_hibernate_collectionTracker.getSize("federatedIdentities");
                if (this.federatedIdentities != null || n2 == -1) break block13;
                n = 1;
                break block12;
            }
            if (this.federatedIdentities == null || this.federatedIdentities instanceof PersistentCollection && !((PersistentCollection)this.federatedIdentities).wasInitialized() || n2 == this.federatedIdentities.size()) break block12;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block12: {
            int n;
            block13: {
                UserEntity userEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                UserEntity userEntity2 = userEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                UserEntity userEntity3 = userEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                UserEntity userEntity4 = userEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                if (userEntity3.$$_hibernate_collectionTracker != null) {
                    int n2 = userEntity3.$$_hibernate_collectionTracker.getSize("attributes");
                    if (userEntity3.attributes == null && n2 != -1) {
                        dirtyTracker4.add("attributes");
                    } else if (userEntity3.attributes != null && (!(userEntity3.attributes instanceof PersistentCollection) || ((PersistentCollection)userEntity3.attributes).wasInitialized()) && n2 != userEntity3.attributes.size()) {
                        dirtyTracker4.add("attributes");
                    }
                }
                if (userEntity2.$$_hibernate_collectionTracker != null) {
                    int n3 = userEntity2.$$_hibernate_collectionTracker.getSize("requiredActions");
                    if (userEntity2.requiredActions == null && n3 != -1) {
                        dirtyTracker3.add("requiredActions");
                    } else if (userEntity2.requiredActions != null && (!(userEntity2.requiredActions instanceof PersistentCollection) || ((PersistentCollection)userEntity2.requiredActions).wasInitialized()) && n3 != userEntity2.requiredActions.size()) {
                        dirtyTracker3.add("requiredActions");
                    }
                }
                if (userEntity.$$_hibernate_collectionTracker != null) {
                    int n4 = userEntity.$$_hibernate_collectionTracker.getSize("credentials");
                    if (userEntity.credentials == null && n4 != -1) {
                        dirtyTracker2.add("credentials");
                    } else if (userEntity.credentials != null && (!(userEntity.credentials instanceof PersistentCollection) || ((PersistentCollection)userEntity.credentials).wasInitialized()) && n4 != userEntity.credentials.size()) {
                        dirtyTracker2.add("credentials");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block12;
                n = this.$$_hibernate_collectionTracker.getSize("federatedIdentities");
                if (this.federatedIdentities != null || n == -1) break block13;
                dirtyTracker.add("federatedIdentities");
                break block12;
            }
            if (this.federatedIdentities == null || this.federatedIdentities instanceof PersistentCollection && !((PersistentCollection)this.federatedIdentities).wasInitialized() || n == this.federatedIdentities.size()) break block12;
            dirtyTracker.add("federatedIdentities");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block12: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            UserEntity userEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            UserEntity userEntity2 = userEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            UserEntity userEntity3 = userEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            UserEntity userEntity4 = userEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("attributes")) {
                if (userEntity3.attributes == null || userEntity3.attributes instanceof PersistentCollection && !((PersistentCollection)userEntity3.attributes).wasInitialized()) {
                    userEntity3.$$_hibernate_collectionTracker.add("attributes", -1);
                } else {
                    userEntity3.$$_hibernate_collectionTracker.add("attributes", userEntity3.attributes.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("requiredActions")) {
                if (userEntity2.requiredActions == null || userEntity2.requiredActions instanceof PersistentCollection && !((PersistentCollection)userEntity2.requiredActions).wasInitialized()) {
                    userEntity2.$$_hibernate_collectionTracker.add("requiredActions", -1);
                } else {
                    userEntity2.$$_hibernate_collectionTracker.add("requiredActions", userEntity2.requiredActions.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("credentials")) {
                if (userEntity.credentials == null || userEntity.credentials instanceof PersistentCollection && !((PersistentCollection)userEntity.credentials).wasInitialized()) {
                    userEntity.$$_hibernate_collectionTracker.add("credentials", -1);
                } else {
                    userEntity.$$_hibernate_collectionTracker.add("credentials", userEntity.credentials.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("federatedIdentities")) break block12;
            if (this.federatedIdentities == null || this.federatedIdentities instanceof PersistentCollection && !((PersistentCollection)this.federatedIdentities).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("federatedIdentities", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("federatedIdentities", this.federatedIdentities.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_username() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "username", (Object)this.username);
        }
        return this.username;
    }

    public void $$_hibernate_write_username(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"username", (Object)string, (Object)this.username)) {
            this.$$_hibernate_trackChange("username");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "username", (Object)this.username, (Object)string);
            return;
        }
        this.username = string;
    }

    public String $$_hibernate_read_firstName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "firstName", (Object)this.firstName);
        }
        return this.firstName;
    }

    public void $$_hibernate_write_firstName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"firstName", (Object)string, (Object)this.firstName)) {
            this.$$_hibernate_trackChange("firstName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "firstName", (Object)this.firstName, (Object)string);
            return;
        }
        this.firstName = string;
    }

    public Long $$_hibernate_read_createdTimestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp);
        }
        return this.createdTimestamp;
    }

    public void $$_hibernate_write_createdTimestamp(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdTimestamp", (Object)l, (Object)this.createdTimestamp)) {
            this.$$_hibernate_trackChange("createdTimestamp");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp, (Object)l);
            return;
        }
        this.createdTimestamp = l;
    }

    public String $$_hibernate_read_lastName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastName", (Object)this.lastName);
        }
        return this.lastName;
    }

    public void $$_hibernate_write_lastName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastName", (Object)string, (Object)this.lastName)) {
            this.$$_hibernate_trackChange("lastName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastName", (Object)this.lastName, (Object)string);
            return;
        }
        this.lastName = string;
    }

    public String $$_hibernate_read_email() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "email", (Object)this.email);
        }
        return this.email;
    }

    public void $$_hibernate_write_email(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"email", (Object)string, (Object)this.email)) {
            this.$$_hibernate_trackChange("email");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "email", (Object)this.email, (Object)string);
            return;
        }
        this.email = string;
    }

    public boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "enabled", this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"enabled", (boolean)bl, (boolean)this.enabled)) {
            this.$$_hibernate_trackChange("enabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "enabled", this.enabled, bl);
            return;
        }
        this.enabled = bl;
    }

    public boolean $$_hibernate_read_emailVerified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "emailVerified", this.emailVerified);
        }
        return this.emailVerified;
    }

    public void $$_hibernate_write_emailVerified(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"emailVerified", (boolean)bl, (boolean)this.emailVerified)) {
            this.$$_hibernate_trackChange("emailVerified");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "emailVerified", this.emailVerified, bl);
            return;
        }
        this.emailVerified = bl;
    }

    public String $$_hibernate_read_emailConstraint() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "emailConstraint", (Object)this.emailConstraint);
        }
        return this.emailConstraint;
    }

    public void $$_hibernate_write_emailConstraint(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"emailConstraint", (Object)string, (Object)this.emailConstraint)) {
            this.$$_hibernate_trackChange("emailConstraint");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "emailConstraint", (Object)this.emailConstraint, (Object)string);
            return;
        }
        this.emailConstraint = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"realmId", (Object)string, (Object)this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }

    public Collection $$_hibernate_read_requiredActions() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActions = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredActions", this.requiredActions);
        }
        return this.requiredActions;
    }

    public void $$_hibernate_write_requiredActions(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActions = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredActions", this.requiredActions, (Object)collection);
            return;
        }
        this.requiredActions = collection;
    }

    public Collection $$_hibernate_read_credentials() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.credentials = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "credentials", this.credentials);
        }
        return this.credentials;
    }

    public void $$_hibernate_write_credentials(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.credentials = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "credentials", this.credentials, (Object)collection);
            return;
        }
        this.credentials = collection;
    }

    public Collection $$_hibernate_read_federatedIdentities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "federatedIdentities", this.federatedIdentities);
        }
        return this.federatedIdentities;
    }

    public void $$_hibernate_write_federatedIdentities(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federatedIdentities", this.federatedIdentities, (Object)collection);
            return;
        }
        this.federatedIdentities = collection;
    }

    public String $$_hibernate_read_federationLink() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "federationLink", (Object)this.federationLink);
        }
        return this.federationLink;
    }

    public void $$_hibernate_write_federationLink(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"federationLink", (Object)string, (Object)this.federationLink)) {
            this.$$_hibernate_trackChange("federationLink");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federationLink", (Object)this.federationLink, (Object)string);
            return;
        }
        this.federationLink = string;
    }

    public String $$_hibernate_read_serviceAccountClientLink() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountClientLink = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceAccountClientLink", (Object)this.serviceAccountClientLink);
        }
        return this.serviceAccountClientLink;
    }

    public void $$_hibernate_write_serviceAccountClientLink(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceAccountClientLink", (Object)string, (Object)this.serviceAccountClientLink)) {
            this.$$_hibernate_trackChange("serviceAccountClientLink");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountClientLink = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceAccountClientLink", (Object)this.serviceAccountClientLink, (Object)string);
            return;
        }
        this.serviceAccountClientLink = string;
    }

    public int $$_hibernate_read_notBefore() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().readInt((Object)this, "notBefore", this.notBefore);
        }
        return this.notBefore;
    }

    public void $$_hibernate_write_notBefore(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notBefore", (int)n, (int)this.notBefore)) {
            this.$$_hibernate_trackChange("notBefore");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().writeInt((Object)this, "notBefore", this.notBefore, n);
            return;
        }
        this.notBefore = n;
    }
}

