/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayRemoveFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;

public class GaussDBArrayRemoveFunction
extends AbstractArrayRemoveFunction {
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append((CharSequence)"CASE WHEN ");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)" IS NULL THEN NULL ELSE COALESCE(( SELECT array_agg(val) FROM unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)") AS val");
        if (indexExpression instanceof Literal) {
            Literal literal = (Literal)indexExpression;
            Object literalValue = literal.getLiteralValue();
            if (literalValue != null) {
                GaussDBArrayRemoveFunction.appendWhere(sqlAppender, walker, indexExpression);
            } else {
                sqlAppender.append((CharSequence)" where val IS NOT NULL");
            }
        } else {
            GaussDBArrayRemoveFunction.appendWhere(sqlAppender, walker, indexExpression);
        }
        sqlAppender.append((CharSequence)"),  CAST(ARRAY[] AS VARCHAR[]) ) END AS result_array");
    }

    private static void appendWhere(SqlAppender sqlAppender, SqlAstTranslator<?> walker, Expression indexExpression) {
        sqlAppender.append((CharSequence)" where val IS NULL OR val not in (");
        indexExpression.accept(walker);
        sqlAppender.append((CharSequence)")");
    }
}

