/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.GroupProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.jpa.JpaRealmProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class JpaGroupProviderFactory
implements GroupProviderFactory {
    private Set<String> groupSearchableAttributes = null;
    private boolean escapeSlashesInGroupPath;

    public void init(Config.Scope config) {
        this.escapeSlashesInGroupPath = config.getBoolean("escapeSlashesInGroupPath", Boolean.valueOf(false));
        String[] searchableAttrsArr = config.getArray("searchableAttributes");
        if (searchableAttrsArr == null) {
            String s = System.getProperty("keycloak.group.searchableAttributes");
            searchableAttrsArr = s == null ? null : s.split("\\s*,\\s*");
        }
        this.groupSearchableAttributes = searchableAttrsArr != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(searchableAttrsArr))) : Collections.emptySet();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "jpa";
    }

    public GroupProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaRealmProvider(session, em, null, this.groupSearchableAttributes);
    }

    public void close() {
    }

    public int order() {
        return 1;
    }

    public boolean escapeSlashesInGroupPath() {
        return this.escapeSlashesInGroupPath;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("escapeSlashesInGroupPath").helpText("If true slashes `/` in group names are escaped with the character `~` when converted to paths.").type("boolean").defaultValue((Object)false).add().property().name("searchableAttributes").helpText("The list of attributes separated by comma that are allowed in client attribute searches.").type("string").add().build();
    }
}

