/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.ProblemsInfrastructure;

@NonNullApi
public class DefaultProblem
implements Serializable,
InternalProblem {
    private final ProblemDefinition problemDefinition;
    private final String contextualLabel;
    private final List<String> solutions;
    private final List<ProblemLocation> originLocations;
    private final List<ProblemLocation> contextualLocations;
    private final String details;
    private final Throwable exception;
    private final AdditionalData additionalData;

    public DefaultProblem(ProblemDefinition problemDefinition, @Nullable String contextualLabel, List<String> solutions, List<ProblemLocation> originLocations, List<ProblemLocation> contextualLocations, @Nullable String details, @Nullable Throwable exception, @Nullable AdditionalData additionalData) {
        this.problemDefinition = problemDefinition;
        this.contextualLabel = contextualLabel;
        this.solutions = solutions;
        this.originLocations = originLocations;
        this.contextualLocations = contextualLocations;
        this.details = details;
        this.exception = exception;
        this.additionalData = additionalData;
    }

    @Override
    public ProblemDefinition getDefinition() {
        return this.problemDefinition;
    }

    @Override
    @Nullable
    public String getContextualLabel() {
        return this.contextualLabel;
    }

    @Override
    public List<String> getSolutions() {
        return this.solutions;
    }

    @Override
    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Override
    public List<ProblemLocation> getOriginLocations() {
        return this.originLocations;
    }

    @Override
    public List<ProblemLocation> getContextualLocations() {
        return this.contextualLocations;
    }

    @Override
    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    @Override
    @Nullable
    public AdditionalData getAdditionalData() {
        return this.additionalData;
    }

    @Override
    public InternalProblemBuilder toBuilder(ProblemsInfrastructure infrastructure) {
        return new DefaultProblemBuilder(this, infrastructure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblem that = (DefaultProblem)o;
        return Objects.equal((Object)this.problemDefinition, (Object)that.problemDefinition) && Objects.equal((Object)this.contextualLabel, (Object)that.contextualLabel) && Objects.equal(this.solutions, that.solutions) && Objects.equal(this.originLocations, that.originLocations) && Objects.equal((Object)this.details, (Object)that.details) && Objects.equal((Object)this.exception, (Object)that.exception) && Objects.equal((Object)this.additionalData, (Object)that.additionalData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.problemDefinition, this.contextualLabel, this.solutions, this.originLocations, this.details, this.exception, this.additionalData});
    }

    public String toString() {
        return "DefaultProblem{problemDefinition=" + this.problemDefinition + ", contextualLabel='" + this.contextualLabel + '\'' + ", solutions=" + this.solutions + ", originLocations=" + this.originLocations + ", contextualLocations=" + this.contextualLocations + ", details='" + this.details + '\'' + ", exception=" + (this.exception != null ? this.exception.toString() : "null") + ", additionalData=" + this.additionalData + '}';
    }
}

