/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Pattern;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarTypeProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.Pair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class VarExprent
extends Exprent
implements Pattern {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private static final boolean FORCE_VARVER_NAME = false;
    private int index;
    private VarType varType;
    private boolean definition = false;
    private final VarProcessor processor;
    private int version = 0;
    private boolean classDef = false;
    private boolean stack = false;
    private StructLocalVariableTableAttribute.LocalVariable lvt = null;
    private Instruction backing = null;
    private boolean isEffectivelyFinal = false;
    private boolean writingPattern = false;
    private VarType boundType;
    private boolean isIntersectionType = false;

    public VarExprent(int index, VarType varType, VarProcessor processor) {
        this(index, varType, processor, null);
    }

    public VarExprent(int index, VarType varType, VarProcessor processor, BitSet bytecode) {
        super(Exprent.Type.VAR);
        this.index = index;
        this.varType = varType;
        this.processor = processor;
        this.addBytecodeOffsets(bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.getVarType();
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.lvt != null && this.lvt.getSignature() != null) {
            try {
                return GenericType.parse(this.lvt.getSignature());
            }
            catch (StringIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        } else if (this.lvt != null) {
            return this.lvt.getVarType();
        }
        return this.getVarType();
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        return lst;
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVarType(), this.processor, this.bytecode);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassDef(this.classDef);
        var.setStack(this.stack);
        var.setLVT(this.lvt);
        var.setEffectivelyFinal(this.isEffectivelyFinal);
        return var;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buffer = new TextBuffer();
        buffer.addBytecodeMapping(this.bytecode);
        if (this.classDef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.varType.value);
            new ClassWriter().writeClass(child, buffer, indent);
        } else {
            VarVersionPair varVersion = this.getVarVersionPair();
            if (this.definition) {
                VarType definitionType;
                String name;
                if (!this.writingPattern && this.processor != null && this.processor.getVarFinal(varVersion) == VarTypeProcessor.FinalType.EXPLICIT_FINAL) {
                    buffer.append("final ");
                }
                if ((name = ExprProcessor.getCastTypeName(definitionType = this.getDefinitionVarType())).equals("<unrepresentable>") || this.isIntersectionType) {
                    buffer.append("var");
                } else {
                    buffer.appendCastTypeName(definitionType);
                }
                buffer.append(" ");
            }
            String name = this.getName();
            MethodWrapper method = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
            if (!(method == null || "this".equals(name) && this.index == 0)) {
                int varIndex = this.index;
                String thisVar = null;
                if (this.processor != null) {
                    Pair<String, VarVersionPair> source = this.processor.getVarSource(this.getVarVersionPair());
                    ClassesProcessor.ClassNode node = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
                    while (source != null && node != null) {
                        method = node.getWrapper().getMethods().getWithKey((String)source.a);
                        varIndex = ((VarVersionPair)source.b).var;
                        source = method.varproc != null ? method.varproc.getVarSource((VarVersionPair)source.b) : null;
                    }
                    thisVar = this.processor.getThisVars().get(this.getVarVersionPair());
                }
                boolean param = false;
                MethodDescriptor descriptor = MethodDescriptor.parseDescriptor(method.methodStruct.getDescriptor());
                if (method.varproc != null) {
                    Integer originalIndex = method.varproc.getVarOriginalIndex(varIndex);
                    int i = originalIndex != null ? originalIndex : varIndex;
                    Integer paramsSize = Arrays.stream(descriptor.params).map(v -> v.stackSize).reduce(0, Integer::sum);
                    boolean bl = param = i <= paramsSize - (method.methodStruct.hasModifier(8) ? 1 : 0);
                }
                if (thisVar == null || !name.contains(".this")) {
                    buffer.appendVariable(name, this.definition, param, method.classStruct.qualifiedName, method.methodStruct.getName(), descriptor, varIndex, name);
                } else {
                    int i = name.indexOf(".this");
                    buffer.appendClass(name.substring(0, i), false, thisVar);
                    buffer.append(name.substring(i));
                }
            } else {
                String thisVar = null;
                if (this.processor != null) {
                    thisVar = this.processor.getThisVars().get(this.getVarVersionPair());
                }
                if (thisVar != null && name.contains(".this")) {
                    int i = name.indexOf(".this");
                    buffer.appendClass(name.substring(0, i), false, thisVar);
                    buffer.append(name.substring(i));
                } else {
                    buffer.append(name);
                }
            }
        }
        return buffer;
    }

    public VarVersionPair getVarVersionPair() {
        return new VarVersionPair(this.index, this.version);
    }

    public String getDefinitionType() {
        String name = ExprProcessor.getCastTypeName(this.getDefinitionVarType());
        return name.equals("<unrepresentable>") ? "var" : name;
    }

    public VarType getDefinitionVarType() {
        if (DecompilerContext.getOption("use-lvt-names")) {
            if (this.lvt != null) {
                GenericFieldDescriptor descriptor;
                if (DecompilerContext.getOption("decompile-generics") && this.lvt.getSignature() != null && (descriptor = GenericMain.parseFieldSignature(this.lvt.getSignature())) != null) {
                    return descriptor.type;
                }
                return this.getVarType();
            }
            MethodWrapper method = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
            if (method != null) {
                int visibleOffset;
                Integer originalIndex = null;
                if (this.processor != null) {
                    originalIndex = this.processor.getVarOriginalIndex(this.index);
                }
                int n = visibleOffset = this.bytecode == null ? -1 : this.bytecode.length();
                if (originalIndex != null) {
                    String descriptor;
                    GenericFieldDescriptor descriptor2;
                    String signature;
                    StructGeneralAttribute attr;
                    if (DecompilerContext.getOption("decompile-generics") && (attr = method.methodStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE)) != null && (signature = ((StructLocalVariableTypeTableAttribute)attr).getSignature(originalIndex, visibleOffset)) != null && (descriptor2 = GenericMain.parseFieldSignature(signature)) != null) {
                        return descriptor2.type;
                    }
                    attr = method.methodStruct.getLocalVariableAttr();
                    if (attr != null && (descriptor = ((StructLocalVariableTableAttribute)attr).getDescriptor(originalIndex, visibleOffset)) != null) {
                        return new VarType(descriptor);
                    }
                }
            }
        }
        return this.getVarType();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && InterpreterUtil.equalObjects(this.getVarType(), ve.getVarType());
    }

    public boolean equalsVersions(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion();
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVarType() {
        if (DecompilerContext.getOption("use-lvt-names") && this.lvt != null) {
            return new VarType(this.lvt.getDescriptor());
        }
        VarType vt = null;
        if (this.processor != null) {
            String name = this.processor.getVarName(this.getVarVersionPair());
            vt = Exprent.inferredLambdaTypes.get().get(name);
            if (vt == null) {
                vt = this.processor.getVarType(this.getVarVersionPair());
                if (this.processor.getThisVars().containsKey(this.getVarVersionPair())) {
                    String qaulName = this.processor.getThisVars().get(this.getVarVersionPair());
                    StructClass cls = DecompilerContext.getStructContext().getClass(qaulName);
                    if (cls != null && cls.getSignature() != null) {
                        vt = cls.getSignature().genericType;
                    } else if (vt == null) {
                        vt = new VarType(CodeType.OBJECT, 0, qaulName);
                    }
                }
            }
        }
        if (vt == null || this.varType != null && this.varType.type != CodeType.UNKNOWN) {
            vt = this.varType;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVarType(VarType varType) {
        this.varType = varType;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassDef() {
        return this.classDef;
    }

    public void setClassDef(boolean classDef) {
        this.classDef = classDef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }

    public Instruction getBackingInstr() {
        return this.backing;
    }

    public void setBackingInstr(Instruction backing) {
        this.backing = backing;
    }

    public void setLVT(StructLocalVariableTableAttribute.LocalVariable var) {
        this.lvt = var;
        if (this.processor != null && this.lvt != null) {
            this.processor.setVarType(this.getVarVersionPair(), this.lvt.getVarType());
        }
    }

    public StructLocalVariableTableAttribute.LocalVariable getLVT() {
        return this.lvt;
    }

    public void setEffectivelyFinal(boolean isEffectivelyFinal) {
        this.isEffectivelyFinal = isEffectivelyFinal;
    }

    public boolean isEffectivelyFinal() {
        return this.isEffectivelyFinal;
    }

    public void setWritingPattern() {
        this.writingPattern = true;
    }

    public String getName() {
        String ret;
        String clashingName;
        VarVersionPair pair = this.getVarVersionPair();
        if (this.processor != null && (clashingName = this.processor.getClashingName(pair)) != null) {
            return clashingName;
        }
        if (this.lvt != null) {
            return this.lvt.getName();
        }
        if (this.processor != null && (ret = this.processor.getVarName(pair)) != null) {
            return ret;
        }
        return pair.version == 0 ? "var" + pair.var : "var" + pair.var + "_" + this.version;
    }

    public void setBoundType(VarType boundType) {
        this.boundType = boundType;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        if (this.lvt != null) {
            CheckTypesResult ret = new CheckTypesResult();
            ret.addMinTypeExprent(this, this.lvt.getVarType());
            return ret;
        }
        if (this.boundType != null) {
            CheckTypesResult ret = new CheckTypesResult();
            ret.addMinTypeExprent(this, this.boundType);
            return ret;
        }
        return null;
    }

    public boolean isVarReferenced(Statement stat, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (!(obj instanceof Statement ? this.isVarReferenced((Statement)obj, whitelist) : obj instanceof Exprent && this.isVarReferenced((Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                if (!this.isVarReferenced(exp, whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVarReferenced(Exprent exp, VarExprent ... whitelist) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        lst = lst.stream().filter(e -> e != this && e instanceof VarExprent && this.getVarVersionPair().equals(((VarExprent)e).getVarVersionPair())).collect(Collectors.toList());
        for (Exprent var : lst) {
            boolean allowed = false;
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowNewlineAfterQualifier() {
        return false;
    }

    @Override
    public void processSforms(SFormsConstructor sFormsConstructor, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        sFormsConstructor.varRead(varMaps, stat, calcLiveVars, this);
    }

    @Override
    public String toString() {
        return "VarExprent[" + this.index + "," + this.version + (this.definition ? " Def" : "") + "]: {" + super.toString() + "}";
    }

    public void setIntersectionType(boolean intersection) {
        this.isIntersectionType = intersection;
    }

    public boolean isIntersectionType() {
        return this.isIntersectionType;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRawRule(IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        if (rule != null) {
            if (rule.isVariable()) {
                return engine.checkAndSetVariableValue((String)rule.value, this.index);
            }
            return this.index == Integer.valueOf((String)rule.value);
        }
        return true;
    }

    @Override
    @NotNull
    public List<VarExprent> getPatternVars() {
        return List.of(this);
    }
}

