/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.traccar.geofence.GeofenceGeometry;
import org.traccar.helper.DistanceCalculator;

public class GeofencePolyline
extends GeofenceGeometry {
    private final List<GeofenceGeometry.Coordinate> coordinates;
    private final double polylineDistance;

    public GeofencePolyline(String wkt, double polylineDistance) throws ParseException {
        this.coordinates = this.fromWkt(wkt);
        this.calculateBoundary(this.coordinates, polylineDistance);
        this.polylineDistance = polylineDistance;
    }

    @Override
    protected boolean containsPointInternal(double latitude, double longitude) {
        for (int i = 1; i < this.coordinates.size(); ++i) {
            if (!(DistanceCalculator.distanceToLine(latitude, longitude, this.coordinates.get(i - 1).lat(), this.coordinates.get(i - 1).lon(), this.coordinates.get(i).lat(), this.coordinates.get(i).lon()) <= this.polylineDistance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double calculateArea() {
        return 0.0;
    }

    @Override
    public String toWkt() {
        StringBuilder buf = new StringBuilder();
        buf.append("LINESTRING (");
        for (GeofenceGeometry.Coordinate coordinate : this.coordinates) {
            buf.append(coordinate.lat());
            buf.append(" ");
            buf.append(coordinate.lon());
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2) + ")";
    }

    private List<GeofenceGeometry.Coordinate> fromWkt(String wkt) throws ParseException {
        ArrayList<GeofenceGeometry.Coordinate> coordinates = new ArrayList<GeofenceGeometry.Coordinate>();
        if (!wkt.startsWith("LINESTRING")) {
            throw new ParseException("Mismatch geometry type", 0);
        }
        String content = wkt.substring(wkt.indexOf("(") + 1, wkt.indexOf(")"));
        if (content.isEmpty()) {
            throw new ParseException("No content", 0);
        }
        String[] commaTokens = content.split(",");
        if (commaTokens.length < 2) {
            throw new ParseException("Not valid content", 0);
        }
        for (String commaToken : commaTokens) {
            double lon;
            double lat;
            String[] tokens = commaToken.trim().split("\\s");
            if (tokens.length != 2) {
                throw new ParseException("Here must be two coordinates: " + commaToken, 0);
            }
            try {
                lat = Double.parseDouble(tokens[0]);
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[0] + " is not a double", 0);
            }
            try {
                lon = Double.parseDouble(tokens[1]);
            }
            catch (NumberFormatException e) {
                throw new ParseException(tokens[1] + " is not a double", 0);
            }
            coordinates.add(new GeofenceGeometry.Coordinate(lat, lon));
        }
        return coordinates;
    }
}

