/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.GithubGistContentsCollector;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Condition<@Nullable VirtualFile> FILE_WITH_CONTENT = f -> f != null && !f.getFileType().isBinary();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GithubCreateGistAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean hasFilesWithContent;
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)ApplicationManager.getApplication().getService(GHAccountManager.class));
        GHHostedRepositoriesManager hostedRepositoriesManager = (GHHostedRepositoriesManager)project.getService(GHHostedRepositoriesManager.class);
        if (((Set)hostedRepositoriesManager.getKnownRepositoriesState().getValue()).isEmpty() && ((Set)accountManager.getAccountsState().getValue()).isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean bl = hasFilesWithContent = FILE_WITH_CONTENT.value((Object)file) || files != null && ContainerUtil.exists((Object[])files, FILE_WITH_CONTENT);
        if (!hasFilesWithContent || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, (VirtualFile)(FILE_WITH_CONTENT.value((Object)file) ? file : null), GithubCreateGistAction.filterFilesWithContent(files));
    }

    private static VirtualFile @Nullable [] filterFilesWithContent(@Nullable @Nullable VirtualFile @Nullable [] files) {
        if (files == null) {
            return null;
        }
        return ContainerUtil.filter((Object[])files, FILE_WITH_CONTENT).toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final VirtualFile @Nullable [] files) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(3);
        }
        GithubSettings settings = GithubSettings.getInstance();
        @Nullable String fileName = GithubGistContentsCollector.Companion.getGistFileName(editor, files);
        final GithubCreateGistDialog dialog = new GithubCreateGistDialog(project, fileName, settings.isPrivateGist(), settings.isOpenInBrowserGist(), settings.isCopyURLGist());
        if (!dialog.showAndGet()) {
            return;
        }
        settings.setPrivateGist(dialog.isSecret());
        settings.setOpenInBrowserGist(dialog.isOpenInBrowser());
        settings.setCopyURLGist(dialog.isCopyURL());
        final GithubAccount account = Objects.requireNonNull(dialog.getAccount());
        final Ref url = new Ref();
        new Task.Backgroundable(project, GithubBundle.message("create.gist.process", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                String token2;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((token2 = GHCompatibilityUtil.getOrRequestToken(account, project, GHLoginSource.GIST)) == null) {
                    return;
                }
                GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.getInstance().create(account.getServer(), token2);
                List<GithubGistRequest.FileContent> contents = GithubGistContentsCollector.Companion.collectContents(project, editor, file, files);
                if (contents.isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, requestExecutor, indicator, account.getServer(), contents, dialog.isSecret(), dialog.getDescription(), dialog.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog.isCopyURL()) {
                    StringSelection stringSelection = new StringSelection((String)url.get());
                    CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
                }
                if (dialog.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "github.gist.created", GithubBundle.message("create.gist.success", new Object[0]), GithubBundle.message("create.gist.url", new Object[0]), (String)url.get());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction$1", "run"));
            }
        }.queue();
    }

    @VisibleForTesting
    @Nullable
    public static String createGist(@NotNull Project project, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            GithubCreateGistAction.$$$reportNull$$$0(6);
        }
        if (server == null) {
            GithubCreateGistAction.$$$reportNull$$$0(7);
        }
        if (contents == null) {
            GithubCreateGistAction.$$$reportNull$$$0(8);
        }
        if (description == null) {
            GithubCreateGistAction.$$$reportNull$$$0(9);
        }
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.empty", new Object[0]));
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            return executor.execute(indicator, GithubApiRequests.Gists.create(server, contents, description, !isSecret)).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createGistAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

