/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0011\u0010\u0012\u001a\u00020\u0011*\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "build", "Lcom/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl;", "graph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "comparator", "Lit/unimi/dsi/fastutil/ints/IntComparator;", "branches", "", "", "sortCatching", "Lit/unimi/dsi/fastutil/ints/IntList;", "getHeads", "getHeads$intellij_platform_vcs_log_graph_impl", "sortedHeads", "intellij.platform.vcs.log.graph.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGraphLayoutBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphLayoutBuilder.kt\ncom/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n295#2,2:85\n*S KotlinDebug\n*F\n+ 1 GraphLayoutBuilder.kt\ncom/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder\n*L\n73#1:85,2\n*E\n"})
public final class GraphLayoutBuilder {
    @NotNull
    public static final GraphLayoutBuilder INSTANCE = new GraphLayoutBuilder();
    @NotNull
    private static final Logger LOG;

    private GraphLayoutBuilder() {
    }

    @JvmStatic
    @NotNull
    public static final GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull IntComparator comparator) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)comparator, (String)"comparator");
        return GraphLayoutBuilder.build(graph, SetsKt.emptySet(), comparator);
    }

    @JvmStatic
    @NotNull
    public static final GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Set<Integer> branches, @NotNull IntComparator comparator) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Intrinsics.checkNotNullParameter((Object)comparator, (String)"comparator");
        Set allHeads = SetsKt.plus(branches, (Iterable)((Iterable)INSTANCE.getHeads$intellij_platform_vcs_log_graph_impl(graph)));
        IntList sortedHeads = INSTANCE.sortCatching((IntList)new IntArrayList((Collection)allHeads), comparator);
        return INSTANCE.build(graph, sortedHeads);
    }

    private final IntList sortCatching(IntList $this$sortCatching, IntComparator comparator) {
        try {
            $this$sortCatching.sort(comparator);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return $this$sortCatching;
    }

    @NotNull
    public final IntList getHeads$intellij_platform_vcs_log_graph_impl(@NotNull LinearGraph $this$getHeads) {
        Intrinsics.checkNotNullParameter((Object)$this$getHeads, (String)"<this>");
        IntArrayList heads = new IntArrayList();
        int n = $this$getHeads.nodesCount();
        for (int i = 0; i < n; ++i) {
            if (!LinearGraphUtils.getUpNodes($this$getHeads, i).isEmpty()) continue;
            heads.add(i);
        }
        return (IntList)heads;
    }

    private final GraphLayoutImpl build(LinearGraph graph, IntList sortedHeads) {
        int[] layoutIndex = new int[graph.nodesCount()];
        IntArrayList importantHeads = new IntArrayList();
        Ref.IntRef currentLayoutIndex = new Ref.IntRef();
        currentLayoutIndex.element = 1;
        int n = ((Collection)sortedHeads).size();
        for (int i = 0; i < n; ++i) {
            int head = sortedHeads.getInt(i);
            if (layoutIndex[head] != 0) continue;
            importantHeads.add(head);
            DfsUtilKt.walk(head, (Function1<? super Integer, Integer>)((Function1)arg_0 -> GraphLayoutBuilder.build$lambda$1(layoutIndex, currentLayoutIndex, graph, arg_0)));
        }
        return new GraphLayoutImpl(layoutIndex, (IntList)importantHeads);
    }

    private static final int build$lambda$1(int[] $layoutIndex, Ref.IntRef $currentLayoutIndex, LinearGraph $graph, int currentNode) {
        Object v2;
        boolean firstVisit;
        block4: {
            boolean bl = firstVisit = $layoutIndex[currentNode] == 0;
            if (firstVisit) {
                $layoutIndex[currentNode] = $currentLayoutIndex.element;
            }
            List<Integer> list = LinearGraphUtils.getDownNodes($graph, currentNode);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDownNodes(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Integer it = (Integer)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!($layoutIndex[it] == 0)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Integer childWithoutLayoutIndex = v2;
        if (childWithoutLayoutIndex == null) {
            if (firstVisit) {
                int n = $currentLayoutIndex.element;
                $currentLayoutIndex.element = n + 1;
            }
            return -1;
        }
        return childWithoutLayoutIndex;
    }

    static {
        Logger logger = Logger.getInstance(GraphLayoutBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

