/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) << uvec4(16u, 24u, 23u, 25u)) => i64vec4(10813440l, 2231369728l, 1619001344l, 2550136832l)
 * (i64vec4(165l, 133l, 193l, 76l) << uvec4(23u, 12u, 14u, 19u)) => i64vec4(1384120320l, 544768l, 3162112l, 39845888l)
 * (i64vec4(80l, -15l, -51l, 0l) << uvec4(16u, 24u, 23u, 25u)) => i64vec4(5242880l, -251658240l, -427819008l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << uvec4(23u, 12u, 14u, 19u)) => i64vec4(671088640l, -61440l, -835584l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << uvec4(16u, 24u, 23u, 25u)), i64vec4(10813440l, 2231369728l, 1619001344l, 2550136832l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << uvec4(23u, 12u, 14u, 19u)), i64vec4(1384120320l, 544768l, 3162112l, 39845888l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << uvec4(16u, 24u, 23u, 25u)), i64vec4(5242880l, -251658240l, -427819008l, 0l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << uvec4(23u, 12u, 14u, 19u)), i64vec4(671088640l, -61440l, -835584l, 0l))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
