/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.StaticTypesTransformation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.NbGroovyErrorCollector;
import org.netbeans.modules.groovy.editor.compiler.ClassNodeCache;
import org.netbeans.modules.groovy.editor.compiler.ParsingCompilerCustomizer;
import org.netbeans.modules.groovy.editor.compiler.PerfData;
import org.netbeans.modules.groovy.editor.compiler.PerfStatCompilationUnit;
import org.netbeans.modules.groovy.editor.compiler.SimpleTransformationCustomizer;
import org.netbeans.modules.groovy.editor.compiler.error.CompilerErrorResolver;
import org.netbeans.modules.groovy.editor.compiler.error.GroovyError;
import org.netbeans.modules.groovy.editor.utils.GroovyUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class GroovyParser
extends Parser {
    private static final boolean STATIC_ERRORS = Boolean.getBoolean(GroovyParser.class.getName() + ".staticCompileErrors");
    private static final Logger LOG = Logger.getLogger(GroovyParser.class.getName());
    private static final AtomicLong PARSING_TIME = new AtomicLong(0L);
    private static final AtomicInteger PARSING_COUNT = new AtomicInteger(0);
    private static long maximumParsingTime;
    private GroovyParserResult lastResult;
    private AtomicBoolean cancelled = new AtomicBoolean();
    static Map<Integer, Long> phaseCounters;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void cancel() {
        LOG.log(Level.FINEST, "Parser cancelled");
        this.cancelled.set(true);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.cancelled.set(false);
        if (!GroovyUtils.isIndexingEnabled() && GroovyUtils.isIndexingTask(task)) {
            this.lastResult = this.createParseResult(snapshot, null, null);
            return;
        }
        Context context = new Context(snapshot, event);
        context.setIndexingTask(task);
        final HashSet errors = new HashSet();
        context.errorHandler = new ParseErrorHandler(){

            @Override
            public void error(Error error) {
                if (!errors.contains(error)) {
                    errors.add(error);
                }
            }
        };
        long t1 = System.currentTimeMillis();
        try {
            this.lastResult = this.parseBuffer(context, Sanitize.NONE);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error during parsing: ", t);
        }
        long t2 = System.currentTimeMillis();
        context.perfData.addPerfCounter("Total parsing time", t2 - t1);
        context.perfData.dumpStatsAndMerge();
        if (this.lastResult != null) {
            this.lastResult.setErrors(errors);
        } else {
            this.lastResult = this.createParseResult(snapshot, null, null);
        }
    }

    GroovyParserResult createParseResult0(Snapshot snapshot, CompilationUnit cu, ModuleNode rootNode, ErrorCollector errorCollector) {
        GroovyParserResult gpr = this.createParseResult(snapshot, rootNode, errorCollector);
        gpr.setUnit(cu);
        return gpr;
    }

    protected GroovyParserResult createParseResult(Snapshot snapshot, ModuleNode rootNode, ErrorCollector errorCollector) {
        GroovyParserResult parserResult = new GroovyParserResult(this, snapshot, rootNode, errorCollector);
        return parserResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitizing) {
        if (sanitizing == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + "}";
            int start = context.source.length();
            context.sanitizedRange = new OffsetRange(start, start + 1);
            context.sanitizedContents = "";
            return true;
        }
        int offset = context.caretOffset;
        if (sanitizing == Sanitize.ERROR_DOT) {
            offset = context.errorOffset + 1;
        } else if (sanitizing == Sanitize.ERROR_LINE || sanitizing == Sanitize.PRIOR_ERROR_LINE) {
            offset = context.errorOffset;
        }
        if (offset == -1) {
            return false;
        }
        String doc = context.source;
        if (offset > doc.length()) {
            return false;
        }
        try {
            if ((GroovyUtils.isRowEmpty(doc, offset) || GroovyUtils.isRowWhite(doc, offset)) && (offset = GroovyUtils.getRowStart(doc, offset) - 1) < 0) {
                offset = 0;
            }
            if (!GroovyUtils.isRowEmpty(doc, offset) && !GroovyUtils.isRowWhite(doc, offset)) {
                if (sanitizing == Sanitize.EDITED_LINE || sanitizing == Sanitize.ERROR_LINE) {
                    int lineEnd;
                    if (sanitizing == Sanitize.ERROR_LINE) {
                        Token<GroovyTokenId> token;
                        TokenSequence<GroovyTokenId> ts;
                        TokenSequence<GroovyTokenId> tokenSequence = ts = context.document != null ? LexUtilities.getPositionedSequence(context.document, offset) : null;
                        if (ts != null && (token = LexUtilities.findPreviousNonWsNonComment(ts)).id() == GroovyTokenId.DOT) {
                            int removeStart = ts.offset();
                            int removeEnd = removeStart + 1;
                            StringBuilder sb = new StringBuilder(doc.length());
                            sb.append(doc.substring(0, removeStart));
                            sb.append(' ');
                            if (removeEnd < doc.length()) {
                                sb.append(doc.substring(removeEnd));
                            }
                            assert (sb.length() == doc.length());
                            context.sanitizedRange = new OffsetRange(removeStart, removeEnd);
                            context.sanitizedSource = sb.toString();
                            context.sanitizedContents = doc.substring(removeStart, removeEnd);
                            return true;
                        }
                    }
                    if ((lineEnd = GroovyUtils.getRowLastNonWhite(doc, offset)) != -1) {
                        StringBuilder sb = new StringBuilder(doc.length());
                        int lineStart = GroovyUtils.getRowStart(doc, offset);
                        if (++lineEnd >= lineStart + 2) {
                            sb.append(doc.substring(0, lineStart));
                            sb.append("//");
                            int rest = lineStart + 2;
                            if (rest < doc.length()) {
                                sb.append(doc.substring(rest));
                            }
                        } else {
                            sb.append(doc.substring(0, lineStart));
                            sb.append(" ");
                            int rest = lineStart + 1;
                            if (rest < doc.length()) {
                                sb.append(doc.substring(rest));
                            }
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(lineStart, lineEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(lineStart, lineEnd);
                        return true;
                    }
                } else if (sanitizing == Sanitize.PRIOR_ERROR_LINE) {
                    int lineEnd;
                    int errRowStart = GroovyUtils.getRowStart(doc, offset);
                    if (errRowStart > 0 && (lineEnd = GroovyUtils.getRowLastNonWhite(doc, errRowStart - 1)) != -1) {
                        StringBuilder sb = new StringBuilder(doc.length());
                        int lineStart = GroovyUtils.getRowStart(doc, errRowStart - 1);
                        if (++lineEnd >= lineStart + 2) {
                            sb.append(doc.substring(0, lineStart));
                            sb.append("//");
                            int rest = lineStart + 2;
                            if (rest < doc.length()) {
                                sb.append(doc.substring(rest));
                            }
                        } else {
                            sb.append(doc.substring(0, lineStart));
                            sb.append(" ");
                            int rest = lineStart + 1;
                            if (rest < doc.length()) {
                                sb.append(doc.substring(rest));
                            }
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(lineStart, lineEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(lineStart, lineEnd);
                        return true;
                    }
                } else {
                    int lineEnd;
                    assert (sanitizing == Sanitize.ERROR_DOT || sanitizing == Sanitize.EDITED_DOT);
                    int lineStart = GroovyUtils.getRowStart(doc, offset);
                    for (lineEnd = offset - 1; lineEnd >= lineStart && lineEnd < doc.length() && Character.isWhitespace(doc.charAt(lineEnd)); --lineEnd) {
                    }
                    if (lineEnd > lineStart) {
                        StringBuilder sb = new StringBuilder(doc.length());
                        String line = doc.substring(lineStart, lineEnd + 1);
                        int removeChars = 0;
                        int removeEnd = lineEnd + 1;
                        if (line.endsWith(GroovyTokenId.SPREAD_DOT.fixedText() + GroovyTokenId.AT.fixedText())) {
                            removeChars = 3;
                        } else if (line.endsWith(GroovyTokenId.OPTIONAL_DOT.fixedText()) || line.endsWith(GroovyTokenId.ELVIS_OPERATOR.fixedText()) || line.endsWith(GroovyTokenId.MEMBER_POINTER.fixedText()) || line.endsWith(GroovyTokenId.SPREAD_DOT.fixedText()) || line.endsWith(GroovyTokenId.DOT.fixedText() + GroovyTokenId.AT.fixedText())) {
                            removeChars = 2;
                        } else if (line.endsWith(".") || line.endsWith("(")) {
                            removeChars = 1;
                        } else if (line.endsWith(",")) {
                            removeChars = 1;
                        } else if (line.endsWith(", ")) {
                            removeChars = 2;
                        } else if (line.endsWith(",)")) {
                            removeChars = 1;
                            --removeEnd;
                        } else if (line.endsWith(", )")) {
                            removeChars = 1;
                            removeEnd -= 2;
                        }
                        if (removeChars == 0) {
                            return false;
                        }
                        int removeStart = removeEnd - removeChars;
                        sb.append(doc.substring(0, removeStart));
                        for (int i = 0; i < removeChars; ++i) {
                            sb.append(' ');
                        }
                        if (removeEnd < doc.length()) {
                            sb.append(doc.substring(removeEnd));
                        }
                        assert (sb.length() == doc.length());
                        context.sanitizedRange = new OffsetRange(removeStart, removeEnd);
                        context.sanitizedSource = sb.toString();
                        context.sanitizedContents = doc.substring(removeStart, removeEnd);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        return false;
    }

    private GroovyParserResult sanitize(Context context, Sanitize sanitizing) {
        switch (sanitizing) {
            case NEVER: {
                return this.createParseResult(context.snapshot, null, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.PRIOR_ERROR_LINE);
                }
            }
            case PRIOR_ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.snapshot, null, null);
    }

    private static CompilerConfiguration makeConfiguration(CompilerConfiguration configuration, Context context, boolean isIndexing) {
        Map opts = configuration.getOptimizationOptions();
        opts.put("classLoaderResolving", Boolean.FALSE);
        for (ParsingCompilerCustomizer pcc : context.compilerCustomizers) {
            configuration = pcc.configureParsingCompiler(context.customizerCtx, configuration);
        }
        return configuration;
    }

    /*
     * Exception decompiling
     */
    GroovyParserResult parseBuffer(Context context, Sanitize sanitizing) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logParsingTime(Context context, long start, boolean cancelled) {
        long diff = System.currentTimeMillis() - start;
        long full = PARSING_TIME.addAndGet(diff);
        if (cancelled) {
            LOG.log(Level.FINEST, "Compilation cancelled in {0} for file {3}; total time spent {1}; total count {2}", new Object[]{diff, full, PARSING_COUNT.intValue(), context.snapshot.getSource().getFileObject()});
        } else {
            LOG.log(Level.FINEST, "Compilation finished in {0} for file {3}; total time spent {1}; total count {2}", new Object[]{diff, full, PARSING_COUNT.intValue(), context.snapshot.getSource().getFileObject()});
        }
        Class<GroovyParser> clazz = GroovyParser.class;
        synchronized (GroovyParser.class) {
            if (diff > maximumParsingTime) {
                maximumParsingTime = diff;
                LOG.log(Level.FINEST, "Maximum parsing time has been updated to {0}; file {1}", new Object[]{diff, context.snapshot.getSource().getFileObject()});
            }
            // ** MonitorExit[var8_5] (shouldn't be in output)
            return;
        }
    }

    private static String asString(CharSequence sequence) {
        if (sequence instanceof String) {
            return (String)sequence;
        }
        return sequence.toString();
    }

    private static void notifyError(Context context, String key, Severity severity, String description, String details, int offset, Sanitize sanitizing) {
        GroovyParser.notifyError(context, key, severity, description, details, offset, offset, sanitizing);
    }

    private static void notifyError(Context context, String key, Severity severity, String description, String displayName, int startOffset, int endOffset, Sanitize sanitizing) {
        LOG.log(Level.FINEST, "---------------------------------------------------");
        LOG.log(Level.FINEST, "key         : {0}\n", key);
        LOG.log(Level.FINEST, "description : {0}\n", description);
        LOG.log(Level.FINEST, "displayName : {0}\n", displayName);
        LOG.log(Level.FINEST, "startOffset : {0}\n", startOffset);
        LOG.log(Level.FINEST, "endOffset   : {0}\n", endOffset);
        if (description == null) {
            LOG.log(Level.FINEST, "dropping error");
            return;
        }
        if (key == null) {
            key = description;
        }
        if (displayName == null) {
            displayName = description;
        }
        GroovyError error = new GroovyError(key, displayName, description, context.snapshot.getSource().getFileObject(), startOffset, endOffset, severity, CompilerErrorResolver.getId(description));
        context.errorHandler.error((Error)error);
        if (sanitizing == Sanitize.NONE) {
            context.errorOffset = startOffset;
        }
    }

    private void handleErrorCollector(ErrorCollector errorCollector, Context context, ModuleNode moduleNode, boolean ignoreErrors, Sanitize sanitizing) {
        List errors;
        if (!ignoreErrors && errorCollector != null && (errors = errorCollector.getErrors()) != null) {
            for (Object object : errors) {
                LOG.log(Level.FINEST, "Error found in collector: {0}", object);
                if (object instanceof SyntaxErrorMessage) {
                    SyntaxException ex = ((SyntaxErrorMessage)object).getCause();
                    String sourceLocator = ex.getSourceLocator();
                    String name = null;
                    if (moduleNode != null) {
                        name = moduleNode.getContext().getName();
                    } else if (context.snapshot.getSource().getFileObject() != null) {
                        name = context.snapshot.getSource().getFileObject().getNameExt();
                    }
                    if (sourceLocator == null || name == null || !sourceLocator.equals(name)) continue;
                    int startLine = ex.getStartLine();
                    int startColumn = ex.getStartColumn();
                    int line = ex.getLine();
                    int endColumn = ex.getEndColumn();
                    int startOffset = 0;
                    int endOffset = 0;
                    if (context.document != null) {
                        startOffset = ASTUtils.getOffset(context.document, startLine > 0 ? startLine : 1, startColumn > 0 ? startColumn : 1);
                        endOffset = ASTUtils.getOffset(context.document, line > 0 ? line : 1, endColumn > 0 ? endColumn : 1);
                    }
                    GroovyParser.notifyError(context, null, Severity.ERROR, ex.getMessage(), null, startOffset, endOffset, sanitizing);
                    continue;
                }
                if (object instanceof SimpleMessage) {
                    String message = ((SimpleMessage)object).getMessage();
                    GroovyParser.notifyError(context, null, Severity.ERROR, message, null, -1, sanitizing);
                    continue;
                }
                GroovyParser.notifyError(context, null, Severity.ERROR, "Error", null, -1, sanitizing);
            }
        }
    }

    static ParsingCompilerCustomizer customizeTransformsFromLayer(Map<String, Object> attributes) {
        return SimpleTransformationCustomizer.fromLayer(attributes);
    }

    private static /* synthetic */ Object lambda$parseBuffer$1(CU compilationUnit) throws Exception {
        compilationUnit.compile(7);
        return null;
    }

    private static /* synthetic */ String lambda$parseBuffer$0(FileObject f) {
        return "\t" + f.getPath();
    }

    static {
        phaseCounters = new HashMap<Integer, Long>();
    }

    public static final class Context {
        private final Snapshot snapshot;
        private final SourceModificationEvent event;
        private final BaseDocument document;
        private Task parserTask;
        private ParseErrorHandler errorHandler;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        final List<ParsingCompilerCustomizer> compilerCustomizers;
        final ParsingCompilerCustomizer.Context customizerCtx;
        final PerfData perfData = new PerfData();

        public Context(Snapshot snapshot, SourceModificationEvent event) {
            this.snapshot = snapshot;
            this.event = event;
            this.source = GroovyParser.asString(snapshot.getText());
            this.caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)event);
            this.document = LexUtilities.getDocument(snapshot.getSource(), true);
            Lookup mlkp = MimeLookup.getLookup((MimePath)snapshot.getMimePath());
            ArrayList<ParsingCompilerCustomizer> cc = new ArrayList<ParsingCompilerCustomizer>(mlkp.lookupAll(ParsingCompilerCustomizer.class));
            this.compilerCustomizers = cc;
            this.customizerCtx = !cc.isEmpty() ? new ParsingCompilerCustomizer.Context(snapshot, this.parserTask) : null;
        }

        void setIndexingTask(Task t) {
            this.parserTask = t;
            if (this.customizerCtx != null) {
                this.customizerCtx.setConsumerTask(t);
            }
        }

        public String toString() {
            return "GroovyParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    private static interface ParseErrorHandler {
        public void error(Error var1);
    }

    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        ERROR_LINE,
        PRIOR_ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }

    static class CU
    extends PerfStatCompilationUnit {
        final boolean indexing;
        StaticTypesTransformation typesXform = new StaticTypesTransformation(){

            protected StaticTypeCheckingVisitor newVisitor(SourceUnit unit, ClassNode node) {
                return new NbGroovyErrorCollector.NbStaticTypeCheckingVisitor(unit, node, (NbGroovyErrorCollector)errorCollector);
            }
        };
        boolean inited;

        public CU(boolean indexing, GroovyParser parser, CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader, GroovyClassLoader transformationLoader, ClasspathInfo cpInfo, ClassNodeCache classNodeCache, boolean isIndexing, Snapshot snap, PerfData perfData) {
            super(perfData, parser, configuration, security, loader, transformationLoader, cpInfo, classNodeCache, isIndexing, snap);
            this.indexing = indexing;
            this.errorCollector = new NbGroovyErrorCollector(configuration);
        }

        @Override
        public void addPhaseOperation(CompilationUnit.ISourceUnitOperation op, int phase) {
            if (!this.inited) {
                ((ClassNodeCache.TransformationClassLoader)this.getTransformLoader()).setUnit(this);
                this.inited = true;
            }
            super.addPhaseOperation(op, phase);
        }

        @Override
        public void gotoPhase(int phase) throws CompilationFailedException {
            super.gotoPhase(phase);
            if (phase > 3) {
                ((NbGroovyErrorCollector)this.errorCollector).setDisableErrors(true);
            }
            if (phase != 6) {
                return;
            }
            if (this.indexing) {
                return;
            }
            this.typesXform.setCompilationUnit((CompilationUnit)this);
            ClassNode annoClass = this.getClassNodeResolver().resolveName("groovy.transform.TypeChecked", (CompilationUnit)this).getClassNode();
            this.runSourceVisitor("Parsing - static type analysis", su -> {
                for (ClassNode cn : su.getAST().getClasses()) {
                    AnnotationNode fakeTypeChecked = new AnnotationNode(annoClass);
                    cn.addAnnotation(fakeTypeChecked);
                    this.typesXform.visit(new ASTNode[]{fakeTypeChecked, cn}, su);
                }
            });
        }
    }
}

