/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class OnewayOperationParameterMode
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    public ErrorDescription[] apply(ExecutableElement subject, ProblemContext ctx) {
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.Oneway");
        Tree problemTree = ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
        for (VariableElement variableElement : subject.getParameters()) {
            WebParam.Mode value;
            AnnotationMirror paramAnn = Utilities.findAnnotation(variableElement, "javax.jws.WebParam");
            if (paramAnn == null) continue;
            AnnotationValue val = Utilities.getAnnotationAttrValue(paramAnn, "mode");
            WebParam.Mode mode = value = val == null ? null : WebParam.Mode.valueOf((String)val.getValue().toString());
            if (WebParam.Mode.INOUT != value && WebParam.Mode.OUT != value) continue;
            String label = NbBundle.getMessage(OnewayOperationParameterMode.class, (String)"MSG_OnewayNotAllowed_HasOutParams");
            RemoveAnnotation removeFix = new RemoveAnnotation(ctx.getFileObject(), subject, annEntity);
            ctx.setElementToAnnotate(problemTree);
            ErrorDescription problem = OnewayOperationParameterMode.createProblem((Element)subject, ctx, label, removeFix);
            ctx.setElementToAnnotate(null);
            return new ErrorDescription[]{problem};
        }
        return null;
    }

    @Override
    protected final boolean isApplicable(ExecutableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.Oneway");
    }
}

