/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.completion.Utilities;
import org.netbeans.modules.java.editor.base.javadoc.JavadocImports;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public final class ComputeImports {
    private static final String ERROR = "<error>";
    private final CompilationInfo info;
    private CompilationInfo allInfo;
    private final PreferenceChangeListener pcl = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            ComputeImports.this.info.putCachedValue(IMPORT_CANDIDATES_KEY, null, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        }
    };
    private boolean cancelled;
    Map<String, List<Element>> candidates = new HashMap<String, List<Element>>();
    Map<String, List<Element>> notFilteredCandidates = new HashMap<String, List<Element>>();
    Map<String, Set<String>> possibleMethodFQNs = new HashMap<String, Set<String>>();
    private static final Object IMPORT_CANDIDATES_KEY = new Object();
    private TreeVisitorImpl visitor;
    private static final String INIT = "<init>";
    private static EnumSet<TypeKind> INVALID_TYPES = EnumSet.of(TypeKind.NULL, TypeKind.NONE, TypeKind.OTHER, TypeKind.ERROR);

    public ComputeImports(CompilationInfo info) {
        this.info = info;
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
        preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.pcl, (Object)preferences));
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.visitor != null) {
            this.visitor.cancel();
        }
    }

    public Set<String> getMethodFQNs(String simpleName) {
        return this.possibleMethodFQNs.get(simpleName);
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public List<Element> getCandidates(String simpleName) {
        return this.candidates.get(simpleName);
    }

    public List<Element> getRawCandidates(String simpleName) {
        return this.notFilteredCandidates.get(simpleName);
    }

    public ComputeImports computeCandidatesEx() {
        return this.computeCandidatesEx(Collections.emptySet());
    }

    private ComputeImports computeCandidatesEx(final Set<String> forcedUnresolved) {
        ComputeImports cache = (ComputeImports)this.info.getCachedValue(IMPORT_CANDIDATES_KEY);
        if (cache != null) {
            return cache;
        }
        boolean modules = false;
        if (this.info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) <= 0 && this.info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource("module-info.java") != null) {
            modules = true;
        }
        if (modules) {
            ClasspathInfo cpInfo = this.info.getClasspathInfo();
            ClasspathInfo extraInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT)}), (ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS)}), (ClassPath)cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
            JavaSource src = JavaSource.create((ClasspathInfo)extraInfo, (FileObject[])new FileObject[]{this.info.getSnapshot().getSource().getFileObject()});
            try {
                src.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        ComputeImports.this.allInfo = parameter;
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        ComputeImports.this.doComputeCandidates(forcedUnresolved);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.allInfo = this.info;
            this.doComputeCandidates(forcedUnresolved);
        }
        this.info.putCachedValue(IMPORT_CANDIDATES_KEY, (Object)this, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        return this;
    }

    public Pair<Map<String, List<Element>>, Map<String, List<Element>>> getSimpleCandidates() {
        return new Pair<Map<String, List<Element>>, Map<String, List<Element>>>(this.candidates, this.notFilteredCandidates);
    }

    public Pair<Map<String, List<Element>>, Map<String, List<Element>>> computeCandidates() {
        return this.computeCandidates(Collections.emptySet());
    }

    public Pair<Map<String, List<Element>>, Map<String, List<Element>>> computeCandidates(Set<String> forcedUnresolved) {
        return this.computeCandidatesEx(forcedUnresolved).getSimpleCandidates();
    }

    private synchronized void setVisitor(TreeVisitorImpl visitor) {
        this.visitor = visitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComputeCandidates(Set<String> forcedUnresolved) {
        CompilationUnitTree cut = this.info.getCompilationUnit();
        ClasspathInfo cpInfo = this.allInfo.getClasspathInfo();
        TreeVisitorImpl v = new TreeVisitorImpl(this.info);
        this.setVisitor(v);
        try {
            v.scan(cut, new HashMap());
        }
        finally {
            this.setVisitor(null);
        }
        HashSet<String> unresolvedNames = new HashSet<String>(v.unresolved);
        unresolvedNames.addAll(forcedUnresolved);
        unresolvedNames.addAll(JavadocImports.computeUnresolvedImports((CompilationInfo)this.info));
        HashSet<String> unresolvedNonTypes = new HashSet<String>(v.unresolvedNonTypes);
        unresolvedNonTypes.addAll(forcedUnresolved);
        for (String unresolved : unresolvedNames) {
            if (this.isCancelled()) {
                return;
            }
            ArrayList<Element> classes = new ArrayList<Element>();
            Set typeNames = cpInfo.getClassIndex().getDeclaredTypes(unresolved, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
            if (typeNames == null) {
                return;
            }
            for (Object typeName : typeNames) {
                if (this.isCancelled()) {
                    return;
                }
                TypeElement te = (TypeElement)typeName.resolve(this.allInfo);
                if (te == null) {
                    Logger.getLogger(ComputeImports.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + (ElementHandle)typeName + "\".");
                    continue;
                }
                if (this.info.getElements().getPackageOf(te).getQualifiedName().length() == 0 || Utilities.isExcluded((CharSequence)te.getQualifiedName())) continue;
                classes.add(te);
            }
            if (unresolvedNonTypes.contains(unresolved)) {
                Object typeName;
                Iterable simpleNames = cpInfo.getClassIndex().getDeclaredSymbols(unresolved, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
                if (simpleNames == null) {
                    return;
                }
                typeName = simpleNames.iterator();
                while (typeName.hasNext()) {
                    ClassIndex.Symbols p = (ClassIndex.Symbols)typeName.next();
                    if (this.isCancelled()) {
                        return;
                    }
                    TypeElement te = (TypeElement)p.getEnclosingType().resolve(this.allInfo);
                    Set idents = p.getSymbols();
                    if (te == null) continue;
                    for (Element element : te.getEnclosedElements()) {
                        if (!element.getModifiers().contains((Object)Modifier.STATIC) || !idents.contains(this.getSimpleName(element, te))) continue;
                        classes.add(element);
                    }
                }
            }
            this.candidates.put(unresolved, new ArrayList(classes));
            this.notFilteredCandidates.put(unresolved, classes);
        }
        boolean wasChanged = true;
        while (wasChanged) {
            if (this.isCancelled()) {
                return;
            }
            wasChanged = false;
            this.possibleMethodFQNs.clear();
            for (Hint hint : v.hints) {
                wasChanged |= hint.filter(this.allInfo, this);
            }
        }
        for (Map.Entry<String, Set<String>> entry : this.possibleMethodFQNs.entrySet()) {
            String fq;
            Element x;
            Iterator<Element> itE;
            String sn = entry.getKey();
            Set<String> fqns = entry.getValue();
            List<Element> cands = this.candidates.get(sn);
            List<Element> rawCands = this.notFilteredCandidates.get(sn);
            if (cands != null) {
                itE = cands.iterator();
                while (itE.hasNext()) {
                    x = itE.next();
                    if (x.getKind() != ElementKind.METHOD || fqns.contains(fq = this.info.getElementUtilities().getElementName(x, true).toString())) continue;
                    itE.remove();
                }
            }
            if (rawCands == null) continue;
            itE = rawCands.iterator();
            while (itE.hasNext()) {
                x = itE.next();
                if (x.getKind() != ElementKind.METHOD || fqns.contains(fq = this.info.getElementUtilities().getElementName(x, true).toString())) continue;
                itE.remove();
            }
        }
    }

    public void addMethodFqn(Element el) {
        if (el.getKind() != ElementKind.METHOD) {
            return;
        }
        String fqn = this.info.getElementUtilities().getElementName(el, true).toString();
        String simpleName = ((ExecutableElement)el).getSimpleName().toString();
        Set<String> col = this.possibleMethodFQNs.get(simpleName);
        if (col == null) {
            col = new HashSet<String>(3);
            this.possibleMethodFQNs.put(simpleName, col);
        }
        col.add(fqn);
    }

    public String displayNameForImport(@NonNull Element element) {
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            return ((TypeElement)element).getQualifiedName().toString();
        }
        StringBuilder fqnSB = new StringBuilder();
        fqnSB.append(this.info.getElementUtilities().getElementName(element, true));
        if (element.getKind() == ElementKind.METHOD) {
            fqnSB.append("(...)");
        }
        return fqnSB.toString();
    }

    private String getSimpleName(@NonNull Element element, @NullAllowed Element enclosingElement) {
        String result = element.getSimpleName().toString();
        if (enclosingElement != null && INIT.equals(result)) {
            result = enclosingElement.getSimpleName().toString();
        }
        return result;
    }

    private static boolean filter(Types types, List<Element> left, List<Element> right, boolean leftReadOnly, boolean rightReadOnly) {
        boolean changed = false;
        HashMap validPairs = new HashMap();
        for (TypeElement l : ElementFilter.typesIn(left)) {
            ArrayList<TypeElement> valid = new ArrayList<TypeElement>();
            for (TypeElement r : ElementFilter.typesIn(right)) {
                TypeMirror t1 = types.erasure(l.asType());
                TypeMirror t2 = types.erasure(r.asType());
                if (!types.isAssignable(t2, t1)) continue;
                valid.add(r);
            }
            validPairs.put(l, valid);
        }
        HashSet validRights = new HashSet();
        for (Map.Entry entry : validPairs.entrySet()) {
            TypeElement l = (TypeElement)entry.getKey();
            List valid = (List)entry.getValue();
            if (valid.isEmpty() && !leftReadOnly) {
                left.remove(l);
                changed = true;
            }
            validRights.addAll(valid);
        }
        if (!rightReadOnly) {
            changed = right.retainAll(validRights) | changed;
        }
        return changed;
    }

    private static class TreeVisitorImpl
    extends CancellableTreePathScanner<Void, Map<String, Object>> {
        private final CompilationInfo info;
        private boolean onlyTypes;
        private Set<String> unresolved;
        private Set<String> unresolvedNonTypes;
        private List<Hint> hints;
        private Scope topLevelScope;

        public TreeVisitorImpl(CompilationInfo info) {
            this.info = info;
            this.unresolved = new HashSet<String>();
            this.unresolvedNonTypes = new HashSet<String>();
            this.hints = new ArrayList<Hint>();
        }

        public Void visitMemberSelect(MemberSelectTree tree, Map<String, Object> p) {
            if (tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                p.put("request", null);
            }
            this.scan(tree.getExpression(), p);
            Union2 leftSide = (Union2)p.remove("result");
            p.remove("request");
            if (leftSide != null && leftSide.hasFirst()) {
                boolean isMethodInvocation;
                String rightSide = tree.getIdentifier().toString();
                if (ComputeImports.ERROR.equals(rightSide)) {
                    rightSide = "";
                }
                boolean bl = isMethodInvocation = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION;
                if (!"class".equals(rightSide)) {
                    this.hints.add(new EnclosedHint((String)leftSide.first(), rightSide, !isMethodInvocation));
                }
            }
            return null;
        }

        public Void visitVariable(VariableTree tree, Map<String, Object> p) {
            this.scan(tree.getModifiers(), p);
            if (tree.getType() != null && tree.getType().getKind() == Tree.Kind.IDENTIFIER) {
                p.put("request", null);
            }
            this.scan(tree.getType(), p, true);
            Union2 leftSide = (Union2)p.remove("result");
            p.remove("request");
            Union2 rightSide = null;
            if (leftSide != null && tree.getInitializer() != null) {
                TypeMirror rightType;
                Element el = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree.getInitializer()));
                TypeMirror typeMirror = rightType = el != null ? el.asType() : null;
                if (rightType != null && rightType.getKind() == TypeKind.DECLARED) {
                    rightSide = Union2.createSecond((Object)((DeclaredType)rightType));
                } else if (tree.getInitializer().getKind() == Tree.Kind.NEW_CLASS || tree.getInitializer().getKind() == Tree.Kind.NEW_ARRAY) {
                    p.put("request", null);
                }
            }
            this.scan(tree.getInitializer(), p);
            rightSide = rightSide == null ? (Union2)p.remove("result") : rightSide;
            p.remove("result");
            p.remove("request");
            if (!(leftSide == null || rightSide == null || leftSide instanceof TypeMirror && rightSide instanceof TypeMirror)) {
                this.hints.add(new TypeHint((Union2<String, DeclaredType>)leftSide, (Union2<String, DeclaredType>)rightSide));
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Void visitIdentifier(IdentifierTree tree, Map<String, Object> p) {
            Element el;
            MethodInvocationTree mit;
            boolean methodInvocation;
            super.visitIdentifier(tree, p);
            boolean bl = methodInvocation = this.getCurrentPath().getParentPath() != null && this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION;
            if (methodInvocation && (mit = (MethodInvocationTree)this.getCurrentPath().getParentPath().getLeaf()).getMethodSelect() == tree) {
                ArrayList<TypeMirror> params = new ArrayList<TypeMirror>();
                for (ExpressionTree expressionTree : mit.getArguments()) {
                    TypeMirror tm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath().getParentPath(), expressionTree));
                    if (tm != null && tm.getKind() == TypeKind.NONE && (expressionTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION || expressionTree.getKind() == Tree.Kind.MEMBER_REFERENCE)) {
                        tm = this.info.getTypes().getNullType();
                    }
                    params.add(tm);
                }
                this.hints.add(new MethodParamsHint(tree.getName().toString(), params));
            }
            if ((el = this.info.getTrees().getElement(this.getCurrentPath())) != null && (el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.PACKAGE)) {
                TypeMirror type = el.asType();
                String simpleName = null;
                if (type != null) {
                    if (type.getKind() == TypeKind.ERROR) {
                        int n;
                        boolean bl2 = true;
                        if (this.getCurrentPath().getParentPath() != null && this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                            boolean bl3;
                            AssignmentTree at = (AssignmentTree)this.getCurrentPath().getParentPath().getLeaf();
                            boolean bl4 = bl3 = at.getVariable() != tree;
                        }
                        if (methodInvocation) {
                            for (Scope s = this.info.getTrees().getScope(this.getCurrentPath()); s != null; s = s.getEnclosingScope()) {
                                n &= !this.info.getElementUtilities().getLocalMembersAndVars(s, new ElementUtilities.ElementAcceptor(){

                                    public boolean accept(Element e, TypeMirror type) {
                                        return e.getSimpleName().contentEquals(el.getSimpleName()) && (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR);
                                    }
                                }).iterator().hasNext() ? 1 : 0;
                            }
                        }
                        if (n != 0) {
                            simpleName = el.getSimpleName().toString();
                        }
                    }
                    if (type.getKind() == TypeKind.PACKAGE) {
                        PackageElement pack;
                        Element parentElement;
                        void var7_12;
                        TreePath treePath = this.getCurrentPath().getParentPath();
                        Element fullPackage = el;
                        while (var7_12 != null && (parentElement = this.info.getTrees().getElement((TreePath)var7_12)) != null && parentElement.getKind() == ElementKind.PACKAGE) {
                            fullPackage = parentElement;
                            TreePath treePath2 = var7_12.getParentPath();
                        }
                        String s = ((PackageElement)fullPackage).getQualifiedName().toString();
                        Element thisPack = this.info.getTrees().getElement(new TreePath(this.info.getCompilationUnit()));
                        ModuleElement module = thisPack != null ? this.info.getElements().getModuleOf(thisPack) : null;
                        PackageElement packageElement = pack = module != null ? this.info.getElements().getPackageElement(module, s) : this.info.getElements().getPackageElement(s);
                        if (pack == null) {
                            simpleName = el.getSimpleName().toString();
                        }
                    }
                    if (simpleName == null || !SourceVersion.isIdentifier(simpleName) || SourceVersion.isKeyword(simpleName)) {
                        simpleName = null;
                    }
                    if (simpleName != null) {
                        this.unresolved.add(simpleName);
                        if (!this.onlyTypes) {
                            this.unresolvedNonTypes.add(simpleName);
                        }
                        Scope scope = this.getScope();
                        this.hints.add(new AccessibleHint(simpleName, scope));
                        if (p.containsKey("request")) {
                            p.put("result", Union2.createFirst((Object)simpleName));
                        }
                    } else if (p.containsKey("request") && type.getKind() == TypeKind.DECLARED) {
                        p.put("result", Union2.createSecond((Object)((DeclaredType)type)));
                    }
                }
            }
            p.remove("request");
            return null;
        }

        public Void visitNewClass(NewClassTree node, Map<String, Object> p) {
            this.filterByNotAcceptedKind(node.getIdentifier(), ElementKind.ENUM, new ElementKind[0]);
            this.scan(node.getEnclosingExpression(), new HashMap());
            this.scan(node.getIdentifier(), p, true);
            this.scan(node.getTypeArguments(), new HashMap<String, Object>(), true);
            this.scan(node.getArguments(), new HashMap());
            this.scan(node.getClassBody(), new HashMap());
            return null;
        }

        public Void visitMethodInvocation(MethodInvocationTree node, Map<String, Object> p) {
            this.scan(node.getTypeArguments(), new HashMap<String, Object>(), true);
            this.scan(node.getMethodSelect(), p);
            this.scan(node.getArguments(), new HashMap());
            return null;
        }

        public Void visitNewArray(NewArrayTree node, Map<String, Object> p) {
            this.scan(node.getType(), p, true);
            this.scan(node.getDimensions(), new HashMap());
            this.scan(node.getInitializers(), new HashMap());
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree node, Map<String, Object> p) {
            this.scan(node.getType(), p);
            this.scan(node.getTypeArguments(), new HashMap());
            return null;
        }

        public Void visitClass(ClassTree node, Map<String, Object> p) {
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                this.filterByAcceptedKind(node.getExtendsClause(), ElementKind.CLASS, new ElementKind[0]);
                for (Tree tree : node.getImplementsClause()) {
                    this.filterByAcceptedKind(tree, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE);
                }
            }
            this.scan(node.getModifiers(), p);
            this.scan(node.getTypeParameters(), p, true);
            this.scan(node.getExtendsClause(), p, true);
            this.scan(node.getImplementsClause(), p, true);
            this.scan(node.getMembers(), p);
            return null;
        }

        public Void visitAnnotation(AnnotationTree node, Map<String, Object> p) {
            this.filterByAcceptedKind(node.getAnnotationType(), ElementKind.ANNOTATION_TYPE, new ElementKind[0]);
            this.scan(node.getAnnotationType(), p, true);
            this.scan(node.getArguments(), p, false);
            return null;
        }

        public Void visitMethod(MethodTree node, Map<String, Object> p) {
            this.scan(node.getModifiers(), p);
            this.scan(node.getTypeParameters(), p, true);
            this.scan(node.getReturnType(), p, true);
            this.scan(node.getReceiverParameter(), p);
            this.scan(node.getParameters(), p);
            this.scan(node.getThrows(), p, true);
            this.scan(node.getDefaultValue(), p);
            this.scan(node.getBody(), p);
            return null;
        }

        private void scan(Iterable<? extends Tree> trees, Map<String, Object> p, boolean onlyTypes) {
            for (Tree tree : trees) {
                this.scan(tree, p, onlyTypes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan(Tree tree, Map<String, Object> p, boolean onlyTypes) {
            boolean oldOnlyTypes = this.onlyTypes;
            try {
                this.onlyTypes = onlyTypes;
                this.scan(tree, p);
            }
            finally {
                this.onlyTypes = oldOnlyTypes;
            }
        }

        private Scope getScope() {
            if (this.topLevelScope == null) {
                this.topLevelScope = this.info.getTrees().getScope(new TreePath(this.getCurrentPath().getCompilationUnit()));
            }
            return this.topLevelScope;
        }

        private void filterByAcceptedKind(Tree toFilter, ElementKind acceptedKind, ElementKind ... otherAcceptedKinds) {
            this.filterByKind(toFilter, EnumSet.of(acceptedKind, otherAcceptedKinds), EnumSet.noneOf(ElementKind.class));
        }

        private void filterByNotAcceptedKind(Tree toFilter, ElementKind notAcceptedKind, ElementKind ... otherNotAcceptedKinds) {
            this.filterByKind(toFilter, EnumSet.noneOf(ElementKind.class), EnumSet.of(notAcceptedKind, otherNotAcceptedKinds));
        }

        private void filterByKind(Tree toFilter, Set<ElementKind> acceptedKinds, Set<ElementKind> notAcceptedKinds) {
            if (toFilter == null) {
                return;
            }
            switch (toFilter.getKind()) {
                case IDENTIFIER: {
                    this.hints.add(new KindHint(((IdentifierTree)toFilter).getName().toString(), acceptedKinds, notAcceptedKinds));
                    break;
                }
                case PARAMETERIZED_TYPE: {
                    this.filterByKind(((ParameterizedTypeTree)toFilter).getType(), acceptedKinds, notAcceptedKinds);
                }
            }
        }
    }

    public static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    public static interface Hint {
        public boolean filter(CompilationInfo var1, ComputeImports var2);
    }

    public static final class MethodParamsHint
    implements Hint {
        private final String simpleName;
        private final List<TypeMirror> paramTypes;

        public MethodParamsHint(String simpleName, List<TypeMirror> paramTypes) {
            this.simpleName = simpleName;
            this.paramTypes = paramTypes;
        }

        @Override
        public boolean filter(CompilationInfo info, ComputeImports state) {
            List<Element> rawCands = state.notFilteredCandidates.get(this.simpleName);
            List<Element> cands = state.candidates.get(this.simpleName);
            if (rawCands == null || cands == null) {
                return false;
            }
            boolean modified = false;
            boolean someMatch = false;
            for (Element c : new ArrayList<Element>(rawCands)) {
                if (c.getKind() != ElementKind.METHOD) {
                    rawCands.remove(c);
                    cands.remove(c);
                    modified |= true;
                    continue;
                }
                Iterator<TypeMirror> real = this.paramTypes.iterator();
                Iterator<? extends TypeMirror> formal = ((ExecutableType)c.asType()).getParameterTypes().iterator();
                boolean matches = true;
                boolean inVarArgs = false;
                TypeMirror currentFormal = null;
                while (real.hasNext() && (formal.hasNext() || inVarArgs)) {
                    TypeMirror currentReal = real.next();
                    if (!inVarArgs) {
                        currentFormal = formal.next();
                    }
                    if (info.getTypes().isAssignable(info.getTypes().erasure(currentReal), info.getTypes().erasure(currentFormal))) continue;
                    if (((ExecutableElement)c).isVarArgs() && !formal.hasNext() && currentFormal.getKind() == TypeKind.ARRAY) {
                        currentFormal = ((ArrayType)currentFormal).getComponentType();
                        if (!info.getTypes().isAssignable(info.getTypes().erasure(currentReal), info.getTypes().erasure(currentFormal))) {
                            matches = false;
                            break;
                        }
                        inVarArgs = true;
                        continue;
                    }
                    matches = false;
                    break;
                }
                if (!(matches &= real.hasNext() == formal.hasNext())) continue;
                state.addMethodFqn(c);
                someMatch = true;
            }
            if (!someMatch && !rawCands.isEmpty()) {
                cands.clear();
                rawCands.clear();
                modified = true;
            }
            return modified;
        }
    }

    public static final class AccessibleHint
    implements Hint {
        private String simpleName;
        private Scope scope;

        public AccessibleHint(String simpleName, Scope scope) {
            this.simpleName = simpleName;
            this.scope = scope;
        }

        @Override
        public boolean filter(CompilationInfo info, ComputeImports state) {
            Map<String, List<Element>> rawCandidates = state.notFilteredCandidates;
            Map<String, List<Element>> candidates = state.candidates;
            List<Element> cands = rawCandidates.get(this.simpleName);
            if (cands == null || cands.isEmpty()) {
                return false;
            }
            ArrayList<Element> toRemove = new ArrayList<Element>();
            for (Element te : cands) {
                if (!(te.getKind().isClass() || te.getKind().isInterface() ? !info.getTrees().isAccessible(this.scope, (TypeElement)te) : !info.getTrees().isAccessible(this.scope, te, (DeclaredType)te.getEnclosingElement().asType()))) continue;
                toRemove.add(te);
            }
            candidates.get(this.simpleName).removeAll(toRemove);
            return cands.removeAll(toRemove);
        }
    }

    public static final class KindHint
    implements Hint {
        private String simpleName;
        private Set<ElementKind> acceptedKinds;
        private Set<ElementKind> notAcceptedKinds;

        public KindHint(String simpleName, Set<ElementKind> acceptedKinds, Set<ElementKind> notAcceptedKinds) {
            this.simpleName = simpleName;
            this.acceptedKinds = acceptedKinds;
            this.notAcceptedKinds = notAcceptedKinds;
        }

        @Override
        public boolean filter(CompilationInfo info, ComputeImports state) {
            Map<String, List<Element>> rawCandidates = state.notFilteredCandidates;
            Map<String, List<Element>> candidates = state.candidates;
            if (this.acceptedKinds.contains((Object)ElementKind.ANNOTATION_TYPE) && this.acceptedKinds.size() == 1) {
                this.doFilter(info, rawCandidates);
            }
            return this.doFilter(info, candidates);
        }

        private boolean doFilter(CompilationInfo info, Map<String, List<Element>> candidates) {
            List<Element> cands = candidates.get(this.simpleName);
            if (cands == null || cands.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> toRemove = new ArrayList<TypeElement>();
            for (TypeElement te : ElementFilter.typesIn(cands)) {
                if (!this.acceptedKinds.isEmpty() && !this.acceptedKinds.contains((Object)te.getKind())) {
                    toRemove.add(te);
                    continue;
                }
                if (this.notAcceptedKinds.isEmpty() || !this.notAcceptedKinds.contains((Object)te.getKind())) continue;
                toRemove.add(te);
            }
            return cands.removeAll(toRemove);
        }
    }

    public static final class EnclosedHint
    implements Hint {
        private String simpleName;
        private String methodName;
        private boolean allowPrefix;

        public EnclosedHint(String simpleName, String methodName, boolean allowPrefix) {
            this.simpleName = simpleName;
            this.methodName = methodName;
            this.allowPrefix = allowPrefix;
        }

        @Override
        public boolean filter(CompilationInfo info, ComputeImports state) {
            Map<String, List<Element>> candidates = state.candidates;
            List<Element> cands = candidates.get(this.simpleName);
            if (cands == null || cands.isEmpty()) {
                return false;
            }
            ArrayList<TypeElement> toRemove = new ArrayList<TypeElement>();
            for (TypeElement te : ElementFilter.typesIn(cands)) {
                boolean found = false;
                for (Element element : te.getEnclosedElements()) {
                    String simpleName = element.getSimpleName().toString();
                    if (this.methodName.contentEquals(simpleName)) {
                        found = true;
                        break;
                    }
                    if (!this.allowPrefix || !simpleName.startsWith(this.methodName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(te);
            }
            return cands.removeAll(toRemove);
        }
    }

    public static final class TypeHint
    implements Hint {
        private Union2<String, DeclaredType> left;
        private Union2<String, DeclaredType> right;

        public TypeHint(Union2<String, DeclaredType> left, Union2<String, DeclaredType> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean filter(CompilationInfo info, ComputeImports state) {
            Element el;
            Map<String, List<Element>> candidates = state.candidates;
            List<Element> left = null;
            List<Element> right = null;
            boolean leftReadOnly = false;
            boolean rightReadOnly = false;
            if (this.left.hasSecond()) {
                el = ((DeclaredType)this.left.second()).asElement();
                if (el instanceof TypeElement) {
                    left = Collections.singletonList(el);
                    leftReadOnly = true;
                }
            } else {
                left = candidates.get(this.left.first());
            }
            if (this.right.hasSecond()) {
                el = ((DeclaredType)this.right.second()).asElement();
                if (el instanceof TypeElement) {
                    right = Collections.singletonList(el);
                    rightReadOnly = true;
                }
            } else {
                right = candidates.get(this.right.first());
            }
            if (left != null && right != null && !left.isEmpty() && !right.isEmpty()) {
                return ComputeImports.filter(info.getTypes(), left, right, leftReadOnly, rightReadOnly);
            }
            return false;
        }
    }
}

