/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.Bundle;
import org.netbeans.modules.maven.repository.GroupListChildren;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class RepositoryNode
extends AbstractNode {
    private static final String LOCAL_REPO = "org/netbeans/modules/maven/repository/localrepo.png";
    private static final String REMOTE_REPO = "org/netbeans/modules/maven/repository/remoterepo.png";
    private RepositoryInfo info;
    private final GroupListChildren children;
    private static final RequestProcessor RPrefreshindex = new RequestProcessor(RefreshIndexAction.class.getName(), 1);

    public RepositoryNode(RepositoryInfo info) {
        this(info, new GroupListChildren(info));
    }

    private RepositoryNode(RepositoryInfo info, GroupListChildren children) {
        super(Children.create((ChildFactory)children, (boolean)true));
        this.info = info;
        this.children = children;
        this.setName(info.getId());
        this.setDisplayName(info.getName());
    }

    public Image getIcon(int arg0) {
        if (this.info.isRemoteDownloadable()) {
            return ImageUtilities.loadImage((String)REMOTE_REPO, (boolean)true);
        }
        return ImageUtilities.loadImage((String)LOCAL_REPO, (boolean)true);
    }

    public Image getOpenedIcon(int arg0) {
        return this.getIcon(arg0);
    }

    public String getHtmlDisplayName() {
        StringBuilder base = new StringBuilder().append(this.getDisplayName());
        if (this.info.isMirror()) {
            base.append(" <font color='!controlShadow'>[");
            for (RepositoryInfo nf : this.info.getMirroredRepositories()) {
                base.append(nf.getName()).append(",");
            }
            base.setLength(base.length() - 1);
            base.append("]</font>");
        }
        return base.toString();
    }

    public String getShortDescription() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>");
        buffer.append(Bundle.LBL_REPO_ID(this.info.getId()));
        buffer.append(Bundle.LBL_REPO_Name(this.info.getName()));
        if (this.info.getRepositoryUrl() != null) {
            buffer.append(Bundle.LBL_REPO_Url(this.info.getRepositoryUrl()));
        }
        buffer.append(Bundle.LBL_ORIGIN(RepositoryPreferences.getInstance().isPersistent(this.info.getId()) ? Bundle.LBL_ORIGIN_PERSISTENT() : Bundle.LBL_ORIGIN_TRANSIENT()));
        if (this.info.isMirror()) {
            StringBuilder s = new StringBuilder();
            for (RepositoryInfo nf : this.info.getMirroredRepositories()) {
                s.append(nf.getName()).append(",");
            }
            s.setLength(s.length() - 1);
            buffer.append(Bundle.LBL_Mirrors(s.toString()));
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public void destroy() throws IOException {
        RepositoryPreferences.getInstance().removeRepositoryInfo(this.info);
        super.destroy();
    }

    public boolean canDestroy() {
        return RepositoryPreferences.getInstance().isPersistent(this.info.getId());
    }

    public Action[] getActions(boolean arg0) {
        return new Action[]{new RefreshIndexAction(), new EditAction(), DeleteAction.get(DeleteAction.class), null, PropertiesAction.get(PropertiesAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set basicProps = sheet.get("properties");
        try {
            PropertySupport.Reflection id = new PropertySupport.Reflection((Object)this.info, String.class, "getId", null);
            id.setDisplayName(Bundle.LBL_Id());
            id.setShortDescription("");
            PropertySupport.Reflection name = new PropertySupport.Reflection((Object)this.info, String.class, "getName", null);
            name.setDisplayName(Bundle.LBL_Name());
            name.setShortDescription("");
            PropertySupport.Reflection local = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isLocal", null);
            local.setName("local");
            local.setDisplayName(Bundle.LBL_Local());
            local.setShortDescription("");
            PropertySupport.Reflection localRepoLocation = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryPath", null);
            localRepoLocation.setDisplayName(Bundle.LBL_Local_repository_path());
            PropertySupport.Reflection remoteDownloadable = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isRemoteDownloadable", null);
            remoteDownloadable.setDisplayName(Bundle.LBL_Remote_Index());
            PropertySupport.Reflection repoURL = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryUrl", null);
            repoURL.setDisplayName(Bundle.LBL_Remote_URL());
            PropertySupport.Reflection indexURL = new PropertySupport.Reflection((Object)this.info, String.class, "getIndexUpdateUrl", null);
            indexURL.setDisplayName(Bundle.LBL_Remote_Index_URL());
            PropertySupport.ReadOnly<Date> lastIndexed = new PropertySupport.ReadOnly<Date>("lastIndexed", Date.class, Bundle.LBL_last_indexed(), null){

                public Date getValue() throws IllegalAccessException, InvocationTargetException {
                    return RepositoryPreferences.getLastIndexUpdate((String)RepositoryNode.this.info.getId());
                }
            };
            basicProps.put(new Node.Property[]{id, name, local, localRepoLocation, remoteDownloadable, repoURL, indexURL, lastIndexed});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        return sheet;
    }

    public class RefreshIndexAction
    extends AbstractAction {
        public RefreshIndexAction() {
            this.putValue("Name", Bundle.LBL_REPO_Update_Index());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RPrefreshindex.post(new Runnable(){

                @Override
                public void run() {
                    RepositoryIndexer.indexRepo((RepositoryInfo)RepositoryNode.this.info);
                }
            });
        }
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            this.putValue("Name", Bundle.ACT_Edit());
        }

        @Override
        public boolean isEnabled() {
            return RepositoryPreferences.getInstance().isPersistent(RepositoryNode.this.info.getId()) && RepositoryNode.this.info.isRemoteDownloadable();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryRegisterUI rrui = new RepositoryRegisterUI(RepositoryNode.this.info);
            rrui.getAccessibleContext().setAccessibleDescription(Bundle.LBL_Edit_Repo());
            DialogDescriptor dd = new DialogDescriptor((Object)rrui, Bundle.LBL_Edit_Repo());
            dd.setClosingOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            dd.setOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (rrui.getButton() == ret) {
                RepositoryInfo info;
                try {
                    info = rrui.getRepositoryInfo();
                }
                catch (URISyntaxException x) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0));
                    return;
                }
                RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(info);
                RepositoryNode.this.info = info;
                RepositoryNode.this.setDisplayName(info.getName());
                RepositoryNode.this.fireIconChange();
                RepositoryNode.this.fireOpenedIconChange();
                RepositoryNode.this.children.setInfo(info);
            }
        }
    }
}

