/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.wizard;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class CDIBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;

    public void initialize(TemplateWizard wizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        WizardDescriptor.Panel javaPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, null);
        this.panels = new WizardDescriptor.Panel[]{javaPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        ClassPath cp = ClassPath.getClassPath((FileObject)df.getPrimaryFile(), (String)"classpath/compile");
        boolean jakartaInjectPresent = cp.findResource("jakarta/inject/Qualifier.class") != null;
        boolean javaxInjectPresent = cp.findResource("javax/inject/Qualifier.class") != null;
        parameters.put("jakartaNamespace", jakartaInjectPresent || !javaxInjectPresent);
        DataObject dobj = dTemplate.createFromTemplate(df, targetName, parameters);
        return Collections.singleton(dobj);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(CDIBeanIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }
}

