/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.scenebuilder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.javafx2.scenebuilder.Home;
import org.netbeans.modules.javafx2.scenebuilder.impl.SBHomeFactory;
import org.openide.util.NbPreferences;

public final class Settings {
    private static final String SAVE_BEFORE_LAUNCH = "saveBeforeLaunch";
    private static final String SELECTED_HOME = "selectedHome";
    private static final String USER_DEFINED_HOMES = "userDefinedHomes";
    private Home selectedHome;
    private Home predefinedHome;
    private boolean saveBeforeLaunch;
    private List<Home> userDefinedHomes = new ArrayList<Home>();

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    public static Settings getInstance() {
        return Singleton.INSTANCE;
    }

    private Settings() {
        boolean isDefault;
        String homeDef = Settings.getPreferences().get(SELECTED_HOME, null);
        this.predefinedHome = SBHomeFactory.getDefault().defaultHome();
        boolean bl = isDefault = homeDef != null && this.predefinedHome != null && homeDef.equals(this.predefinedHome.getPath());
        if (isDefault || homeDef == null) {
            this.selectedHome = this.predefinedHome;
        } else {
            StringTokenizer st = new StringTokenizer(homeDef, "#");
            if (st.countTokens() > 0) {
                this.selectedHome = SBHomeFactory.getDefault().loadHome(st.nextToken());
            }
        }
        this.loadUserDefinedHomes();
        this.saveBeforeLaunch = Settings.getPreferences().getBoolean(SAVE_BEFORE_LAUNCH, false);
    }

    public Home getSelectedHome() {
        return this.selectedHome;
    }

    public void setSelectedHome(Home home) {
        this.selectedHome = home;
    }

    public Home getPredefinedHome() {
        return this.predefinedHome;
    }

    public List<Home> getUserDefinedHomes() {
        return Collections.unmodifiableList(this.userDefinedHomes);
    }

    public void setUserDefinedHomes(List<Home> homes) {
        this.userDefinedHomes = new ArrayList<Home>(homes);
    }

    public boolean isSaveBeforeLaunch() {
        return this.saveBeforeLaunch;
    }

    public void setSaveBeforeLaunch(boolean val) {
        this.saveBeforeLaunch = val;
    }

    public void store() {
        if (this.selectedHome != null) {
            Settings.getPreferences().put(SELECTED_HOME, this.selectedHome.getPath() + "#" + this.selectedHome.getVersion());
        } else {
            Settings.getPreferences().remove(SELECTED_HOME);
        }
        this.storeUserDefinedHomes();
        Settings.getPreferences().putBoolean(SAVE_BEFORE_LAUNCH, this.saveBeforeLaunch);
        try {
            Settings.getPreferences().sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void loadUserDefinedHomes() {
        String userDefinedHomesStr = Settings.getPreferences().get(USER_DEFINED_HOMES, "");
        StringTokenizer st = new StringTokenizer(userDefinedHomesStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            Home h;
            String homeDef = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(homeDef, "#");
            if (st1.countTokens() != 4 || !(h = new Home(st1.nextToken(), st1.nextToken(), st1.nextToken(), st1.nextToken())).isValid()) continue;
            this.userDefinedHomes.add(h);
        }
    }

    private void storeUserDefinedHomes() {
        if (this.userDefinedHomes.isEmpty()) {
            Settings.getPreferences().put(USER_DEFINED_HOMES, "");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Home h : this.userDefinedHomes) {
            if (!h.isValid()) continue;
            sb.append(sb.length() > 0 ? File.pathSeparator : "");
            sb.append(h.getPath()).append("#");
            sb.append(h.getLauncherPath(true)).append("#");
            sb.append(h.getPropertiesPath(true)).append("#");
            sb.append(h.getVersion());
        }
        Settings.getPreferences().put(USER_DEFINED_HOMES, sb.toString());
    }

    private static class Singleton {
        private static final Settings INSTANCE = new Settings();

        private Singleton() {
        }
    }
}

