/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;

public final class AnnotationPostContruct {
    private AnnotationPostContruct() {
    }

    public static List<ErrorDescription> run(HintContext hintCtx) {
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintCtx);
        if (ctx != null) {
            EjbJar ejbModule = ctx.getEjbModule();
            Profile profile = ejbModule.getJ2eeProfile();
            if (profile == null || !profile.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                return Collections.emptyList();
            }
            List<ExecutableElement> allMethods = ElementFilter.methodsIn(ctx.getClazz().getEnclosedElements());
            ArrayList<ExecutableElement> eligibleMethods = new ArrayList<ExecutableElement>();
            ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
            for (ExecutableElement method : allMethods) {
                if (!AnnotationPostContruct.isEligibleMethod(method)) continue;
                eligibleMethods.add(method);
            }
            if (eligibleMethods.size() > 1) {
                for (ExecutableElement problematicMethods : eligibleMethods) {
                    problems.add(HintsUtils.createProblem(problematicMethods, hintCtx.getInfo(), Bundle.AnnotationPostContruct_too_much_annotations()));
                }
            }
            for (ExecutableElement method : eligibleMethods) {
                List<? extends VariableElement> parameters;
                if (!"void".equals(method.getReturnType().toString())) {
                    problems.add(HintsUtils.createProblem(method, hintCtx.getInfo(), Bundle.AnnotationPostContruct_wrong_return_type()));
                }
                if (!method.getThrownTypes().isEmpty() && AnnotationPostContruct.throwsCheckedException(hintCtx.getInfo(), method.getThrownTypes())) {
                    problems.add(HintsUtils.createProblem(method, hintCtx.getInfo(), Bundle.AnnotationPostContruct_thrown_checked_exceptions()));
                }
                if ((parameters = method.getParameters()).isEmpty() || parameters.size() <= 1 && AnnotationPostContruct.isEjbInterceptor(hintCtx.getInfo(), method)) continue;
                problems.add(HintsUtils.createProblem(method, hintCtx.getInfo(), Bundle.AnnotationPostContruct_wrong_parameters()));
            }
            return problems;
        }
        return Collections.emptyList();
    }

    private static boolean isEjbInterceptor(CompilationInfo info, ExecutableElement method) {
        VariableElement parameter = method.getParameters().get(0);
        String paramType = parameter.asType().toString();
        TypeElement element = info.getElements().getTypeElement(paramType);
        return element != null && (JavaUtils.isTypeOf(info, element, "javax.interceptor.InvocationContext") || JavaUtils.isTypeOf(info, element, "jakarta.interceptor.InvocationContext"));
    }

    private static boolean throwsCheckedException(CompilationInfo info, List<? extends TypeMirror> thrownTypes) {
        for (TypeMirror typeMirror : thrownTypes) {
            boolean runtimeException = false;
            TypeElement element = info.getElements().getTypeElement(typeMirror.toString());
            if (element != null && JavaUtils.isTypeOf(info, element, "java.lang.RuntimeException")) {
                runtimeException = true;
            }
            if (runtimeException) continue;
            return true;
        }
        return false;
    }

    private static boolean isEligibleMethod(ExecutableElement method) {
        boolean knownClasses = HintsUtils.isContainingKnownClasses(method);
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            if (!"javax.annotation.PostConstruct".equals(annotationMirror.getAnnotationType().asElement().toString()) && !"jakarta.annotation.PostConstruct".equals(annotationMirror.getAnnotationType().asElement().toString()) || !knownClasses) continue;
            return true;
        }
        return false;
    }
}

