/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.debugger.jpda.projects.ASTOperationCreationDelegate;
import org.netbeans.modules.debugger.jpda.projects.Bundle;
import org.netbeans.modules.debugger.jpda.projects.ClassToInvoke;
import org.netbeans.modules.debugger.jpda.projects.CodeSnippetCompiler;
import org.netbeans.modules.debugger.jpda.projects.EditorContextSupport;
import org.netbeans.modules.debugger.jpda.projects.ParsedData;
import org.netbeans.modules.debugger.jpda.projects.WeakHashMapActive;
import org.netbeans.modules.java.preprocessorbridge.api.JavaSourceUtil;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

class PreferredCCParser {
    private static final Logger LOG = Logger.getLogger(PreferredCCParser.class.getName());
    private final Map<JavaSource, JavaSourceUtil.Handle> sourceHandles = new WeakHashMapActive<JavaSource, JavaSourceUtil.Handle>();
    private final Map<JavaSource, Date> sourceModifStamps = new WeakHashMapActive<JavaSource, Date>();
    private DebuggerManagerListener sessionsListener = new SessionsListener();

    PreferredCCParser() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.sessionsListener, (Object)new SessionsListenerRemoval()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationController getPreferredCompilationController(FileObject fo, JavaSource js) throws IOException {
        CompilationController preferredCI;
        if (fo != null) {
            Date storedStamp;
            JavaSourceUtil.Handle handle;
            if (JavaSource.forFileObject((FileObject)fo) == null) {
                return null;
            }
            Date lastModified = fo.lastModified();
            Map<JavaSource, JavaSourceUtil.Handle> map = this.sourceHandles;
            synchronized (map) {
                handle = this.sourceHandles.get(js);
                storedStamp = this.sourceModifStamps.get(js);
            }
            if (handle == null || storedStamp != null && lastModified.after(storedStamp)) {
                handle = JavaSourceUtil.createControllerHandle((FileObject)fo, (JavaSourceUtil.Handle)handle);
                map = this.sourceHandles;
                synchronized (map) {
                    this.sourceHandles.put(js, handle);
                    this.sourceModifStamps.put(js, lastModified);
                }
            }
            preferredCI = (CompilationController)handle.getCompilationController();
            PreferredCCParser.runGuarded(preferredCI, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PreferredCCParser.toPhase(preferredCI, JavaSource.Phase.PARSED, LOG);
                    return null;
                }
            });
        } else {
            preferredCI = null;
        }
        return preferredCI;
    }

    public EditorContext.Operation[] getOperations(String url, final int lineNumber, final EditorContext.BytecodeProvider bytecodeProvider, final ASTOperationCreationDelegate opCreationDelegate) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return null;
        }
        final Object[] result = new Object[1];
        if (SourceUtils.isScanInProgress()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)file)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                        if (ci == null) {
                            return;
                        }
                        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                            return;
                        }
                        LineMap lineMap = ci.getCompilationUnit().getLineMap();
                        int offset = PreferredCCParser.findLineOffset(lineMap, ci.getSnapshot().getText(), lineNumber);
                        result[0] = EditorContextSupport.computeOperations(ci, offset, lineNumber, bytecodeProvider, opCreationDelegate);
                    }
                });
            }
            catch (ParseException pex) {
                Exceptions.printStackTrace((Throwable)pex);
                return null;
            }
        }
        try {
            final CompilationController ci = this.getPreferredCompilationController(file, js);
            result[0] = PreferredCCParser.runGuarded(ci, new Callable<EditorContext.Operation[]>(){

                @Override
                public EditorContext.Operation[] call() throws Exception {
                    if (ci == null || !PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return new EditorContext.Operation[0];
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    int offset = PreferredCCParser.findLineOffset(lineMap, ci.getSnapshot().getText(), lineNumber);
                    return EditorContextSupport.computeOperations(ci, offset, lineNumber, bytecodeProvider, opCreationDelegate);
                }
            });
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            return null;
        }
        return (EditorContext.Operation[])result[0];
    }

    public EditorContext.MethodArgument[] getArguments(String url, final EditorContext.Operation operation, final ASTOperationCreationDelegate opCreationDelegate) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return null;
        }
        final EditorContext.MethodArgument[][] args = new EditorContext.MethodArgument[1][];
        if (SourceUtils.isScanInProgress()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)file)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                        if (ci == null) {
                            return;
                        }
                        args[0] = EditorContextSupport.computeMethodArguments(ci, operation, opCreationDelegate);
                    }
                });
            }
            catch (ParseException pex) {
                Exceptions.printStackTrace((Throwable)pex);
                return null;
            }
        }
        try {
            final CompilationController ci = this.getPreferredCompilationController(file, js);
            if (ci == null) {
                return null;
            }
            args[0] = PreferredCCParser.runGuarded(ci, new Callable<EditorContext.MethodArgument[]>(){

                @Override
                public EditorContext.MethodArgument[] call() throws Exception {
                    return EditorContextSupport.computeMethodArguments(ci, operation, opCreationDelegate);
                }
            });
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            return null;
        }
        return args[0];
    }

    public EditorContext.MethodArgument[] getArguments(String url, final int methodLineNumber, final ASTOperationCreationDelegate opCreationDelegate) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return null;
        }
        final EditorContext.MethodArgument[][] args = new EditorContext.MethodArgument[1][];
        if (SourceUtils.isScanInProgress()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)file)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                        if (ci == null || !PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                            return;
                        }
                        LineMap lineMap = ci.getCompilationUnit().getLineMap();
                        int offset = PreferredCCParser.findLineOffset(lineMap, ci.getSnapshot().getText(), methodLineNumber);
                        args[0] = EditorContextSupport.computeMethodArguments(ci, methodLineNumber, offset, opCreationDelegate);
                    }
                });
            }
            catch (ParseException pex) {
                Exceptions.printStackTrace((Throwable)pex);
                return null;
            }
        }
        try {
            final CompilationController ci = this.getPreferredCompilationController(file, js);
            args[0] = PreferredCCParser.runGuarded(ci, new Callable<EditorContext.MethodArgument[]>(){

                @Override
                public EditorContext.MethodArgument[] call() throws Exception {
                    if (ci == null || !PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
                        return null;
                    }
                    LineMap lineMap = ci.getCompilationUnit().getLineMap();
                    int offset = PreferredCCParser.findLineOffset(lineMap, ci.getSnapshot().getText(), methodLineNumber);
                    return EditorContextSupport.computeMethodArguments(ci, methodLineNumber, offset, opCreationDelegate);
                }
            });
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            return null;
        }
        return args[0];
    }

    public String[] getImports(String url) {
        JavaSource js;
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null || (js = JavaSource.forFileObject((FileObject)file)) == null) {
            return new String[0];
        }
        final ArrayList imports = new ArrayList();
        if (SourceUtils.isScanInProgress()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)file)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                        if (ci == null) {
                            return;
                        }
                        PreferredCCParser.computeImports(ci, imports);
                    }
                });
            }
            catch (ParseException pex) {
                Exceptions.printStackTrace((Throwable)pex);
                return new String[0];
            }
        }
        try {
            final CompilationController ci = this.getPreferredCompilationController(file, js);
            if (ci == null) {
                return null;
            }
            PreferredCCParser.runGuarded(ci, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PreferredCCParser.computeImports(ci, imports);
                    return null;
                }
            });
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            return null;
        }
        return imports.toArray(new String[0]);
    }

    private static void computeImports(CompilationController ci, List<String> imports) throws IOException {
        if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.RESOLVED, LOG)) {
            return;
        }
        List<? extends ImportTree> importDecl = ci.getCompilationUnit().getImports();
        int i = 0;
        for (ImportTree importTree : importDecl) {
            String importStr = importTree.getQualifiedIdentifier().toString();
            imports.add(importStr);
            ++i;
        }
    }

    private static JavaSource getJavaSource(SourcePathProvider sp) {
        String[] roots = sp.getOriginalSourceRoots();
        ArrayList<FileObject> sourcePathFiles = new ArrayList<FileObject>();
        for (String root : roots) {
            FileObject fo = FileUtil.toFileObject((File)new File(root));
            if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
                fo = FileUtil.getArchiveRoot((FileObject)fo);
            }
            sourcePathFiles.add(fo);
        }
        ClassPath bootPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourcePathFiles.toArray(new FileObject[0]));
        return JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)bootPath, (ClassPath)classPath, (ClassPath)sourcePath), (FileObject[])new FileObject[0]);
    }

    public <R, D> R interpretOrCompileCode(Evaluator.Expression<Object> expression, String url, int line, ErrorAwareTreePathScanner<Boolean, D> canInterpret, ErrorAwareTreePathScanner<R, D> interpreter, D context, boolean staticContext, Function<Pair<String, byte[]>, Boolean> compiledClassHandler, SourcePathProvider sp) throws InvalidExpressionException {
        Object retValue;
        Tree tree;
        TreePath treePath;
        String code = expression.getExpression();
        ParsedData parsedData = (ParsedData)expression.getPreprocessedObject();
        if (parsedData == null) {
            Trees trees;
            JavaSource js = null;
            FileObject fo = null;
            if (url != null) {
                try {
                    fo = URLMapper.findFileObject((URL)new URL(url));
                    if (fo != null) {
                        js = JavaSource.forFileObject((FileObject)fo);
                    }
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING));
                }
            }
            if (js == null) {
                js = PreferredCCParser.getJavaSource(sp);
            }
            try {
                Boolean canIntrpt;
                CompilationController ci = this.getPreferredCompilationController(fo, js);
                ParseExpressionTask<D> task = new ParseExpressionTask<D>(code, line, context);
                boolean parsed = task.parse(fo, js, ci);
                if (!parsed) {
                    return null;
                }
                treePath = task.getTreePath();
                tree = task.getTree();
                trees = task.getTrees();
                if (treePath != null) {
                    canIntrpt = (Boolean)canInterpret.scan(treePath, context);
                } else {
                    if (tree == null) {
                        throw new InvalidExpressionException(Bundle.MSG_NoParseNoEval() + " URL=" + url + ":" + line);
                    }
                    canIntrpt = true;
                }
                if (Boolean.FALSE.equals(canIntrpt)) {
                    ClassToInvoke compiledClass = CodeSnippetCompiler.compileToClass((CompilationInfo)ci, code, task.getCodeOffset(), js, fo, line, treePath, tree, staticContext);
                    LOG.log(Level.FINE, "Compiled to: {0}", compiledClass);
                    if (compiledClass != null) {
                        boolean success = compiledClassHandler.apply((Pair<String, byte[]>)Pair.of((Object)compiledClass.className, (Object)compiledClass.bytecode));
                        if (compiledClass.innerClasses != null && !compiledClass.innerClasses.isEmpty()) {
                            Map.Entry<String, byte[]> entry;
                            Iterator<Map.Entry<String, byte[]>> iterator = compiledClass.innerClasses.entrySet().iterator();
                            while (iterator.hasNext() && (success = compiledClassHandler.apply((Pair<String, byte[]>)Pair.of((Object)(entry = iterator.next()).getKey(), (Object)entry.getValue())).booleanValue())) {
                            }
                        }
                        if (success) {
                            task = new ParseExpressionTask<D>(compiledClass.methodInvoke, line, context);
                            parsed = task.parse(fo, js, ci);
                            if (!parsed) {
                                return null;
                            }
                            treePath = task.getTreePath();
                            tree = task.getTree();
                            trees = task.getTrees();
                        }
                    }
                }
            }
            catch (IOException ioex) {
                Exceptions.printStackTrace((Throwable)ioex);
                return null;
            }
            expression.setPreprocessedObject((Object)new ParsedData(treePath, tree, trees));
        } else {
            treePath = parsedData.getTreePath();
            tree = parsedData.getTree();
            Trees trees = parsedData.getTrees();
            try {
                Method setTreesMethod = context.getClass().getMethod("setTrees", Trees.class);
                setTreesMethod.invoke(context, trees);
            }
            catch (Exception setTreesMethod) {
                // empty catch block
            }
            if (treePath != null) {
                try {
                    Method setTreePathMethod = context.getClass().getMethod("setTreePath", TreePath.class);
                    setTreePathMethod.invoke(context, treePath);
                }
                catch (Exception setTreePathMethod) {
                    // empty catch block
                }
            }
        }
        if (treePath != null) {
            retValue = interpreter.scan(treePath, context);
        } else {
            if (tree == null) {
                throw new InvalidExpressionException(Bundle.MSG_NoParseNoEval() + " URL=" + url + ":" + line);
            }
            retValue = tree.accept(interpreter, context);
        }
        return (R)retValue;
    }

    private static boolean isErroneous(Tree tree) {
        class TreeChecker
        extends ErrorAwareTreePathScanner<Boolean, Void> {
            TreeChecker() {
            }

            public Boolean scan(Tree tree, Void p) {
                if (tree == null) {
                    return Boolean.FALSE;
                }
                if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                    return Boolean.TRUE;
                }
                return (Boolean)tree.accept(this, p);
            }

            public Boolean visitErrorneous(ErroneousTree tree, Void p) {
                return Boolean.TRUE;
            }
        }
        Boolean result = new TreeChecker().scan(tree, null);
        return result != null && result != false;
    }

    private static int findLineOffset(LineMap lineMap, CharSequence text, int lineNumber) {
        int offset;
        try {
            offset = (int)lineMap.getStartPosition(lineNumber);
            int offset2 = (int)lineMap.getStartPosition(lineNumber + 1);
            CharSequence lineStr = text.subSequence(offset, offset2);
            for (int i = 0; i < lineStr.length(); ++i) {
                if (Character.isWhitespace(lineStr.charAt(i))) continue;
                offset += i;
                break;
            }
        }
        catch (IndexOutOfBoundsException ioobex) {
            return -1;
        }
        return offset;
    }

    static boolean toPhase(CompilationController ci, JavaSource.Phase phase, Logger log) throws IOException {
        return PreferredCCParser.toPhaseCheck(ci, phase, ci.toPhase(phase).compareTo((Enum)phase), log);
    }

    private static boolean toPhaseCheck(CompilationController ci, JavaSource.Phase phase, int compareToPhase, Logger log) {
        if (compareToPhase < 0) {
            log.log(Level.WARNING, "Unable to resolve {0} to phase {1}, current phase = {2}\nDiagnostics = {3}\nFree memory = {4}", new Object[]{ci.getFileObject(), phase, ci.getPhase(), ci.getDiagnostics(), Runtime.getRuntime().freeMemory()});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T runGuarded(@NullAllowed Object mutex, @NonNull Callable<T> action) throws IOException {
        try {
            if (mutex != null) {
                Object object = mutex;
                synchronized (object) {
                    return action.call();
                }
            }
            return action.call();
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private class SessionsListener
    extends DebuggerManagerAdapter {
        private SessionsListener() {
        }

        public void sessionRemoved(Session session) {
            int numSession = DebuggerManager.getDebuggerManager().getSessions().length;
            if (numSession > 0) {
                PreferredCCParser.this.sourceHandles.size();
                PreferredCCParser.this.sourceModifStamps.size();
            } else {
                PreferredCCParser.this.sourceHandles.clear();
                PreferredCCParser.this.sourceModifStamps.clear();
            }
        }
    }

    private static class SessionsListenerRemoval {
        private SessionsListenerRemoval() {
        }

        public void removeDebuggerListener(DebuggerManagerListener l) {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("sessions", l);
        }
    }

    private static class ParseExpressionTask<D>
    implements Task<CompilationController> {
        private final int line;
        private final String expression;
        private final D context;
        private TreePath treePath;
        private Tree tree;
        private Trees trees;
        private int codeOffset;

        public ParseExpressionTask(String expression, int line, D context) {
            this.expression = expression;
            this.line = line;
            this.context = context;
        }

        boolean parse(FileObject fo, JavaSource js, final CompilationController ci) throws IOException {
            if (fo != null && SourceUtils.isScanInProgress()) {
                try {
                    final FileObject file = fo;
                    ParserManager.parse(Collections.singleton(Source.create((FileObject)fo)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            CompilationController ci = EditorContextSupport.retrieveController(resultIterator, file);
                            if (ci != null) {
                                this.run(ci);
                            }
                        }
                    });
                }
                catch (ParseException pex) {
                    Exceptions.printStackTrace((Throwable)pex);
                    return false;
                }
            }
            if (ci == null) {
                js.runUserActionTask((Task)this, false);
            } else {
                try {
                    PreferredCCParser.runGuarded(ci, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            this.run(ci);
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return false;
                }
            }
            return true;
        }

        public void run(CompilationController ci) throws Exception {
            if (!PreferredCCParser.toPhase(ci, JavaSource.Phase.PARSED, LOG)) {
                return;
            }
            TreeUtilities treeUtilities = ci.getTreeUtilities();
            Scope scope = null;
            int offset = 0;
            LineMap lineMap = ci.getFileObject() != null ? ci.getCompilationUnit().getLineMap() : null;
            if (lineMap != null) {
                offset = PreferredCCParser.findLineOffset(lineMap, ci.getSnapshot().getText(), this.line);
                scope = treeUtilities.scopeFor(offset);
            }
            SourcePositions[] sourcePtr = new SourcePositions[]{null};
            this.tree = treeUtilities.parseStatement("{\n" + this.expression + ";\n}", sourcePtr);
            this.codeOffset = 2;
            if (PreferredCCParser.isErroneous(this.tree)) {
                Tree asBlockTree = this.tree;
                this.tree = treeUtilities.parseExpression(this.expression, sourcePtr);
                if (PreferredCCParser.isErroneous(this.tree)) {
                    this.tree = asBlockTree;
                } else {
                    this.codeOffset = 0;
                }
            }
            if (scope != null) {
                scope = treeUtilities.toScopeWithDisabledAccessibilityChecks(scope);
                treeUtilities.attributeTree(this.tree, scope);
            }
            this.trees = ci.getTrees();
            try {
                Method setTreesMethod = this.context.getClass().getMethod("setTrees", Trees.class);
                setTreesMethod.invoke(this.context, this.trees);
            }
            catch (Exception setTreesMethod) {
                // empty catch block
            }
            this.treePath = null;
            try {
                Method setTreePathMethod = this.context.getClass().getMethod("setTreePath", TreePath.class);
                if (lineMap != null) {
                    this.treePath = treeUtilities.pathFor(offset);
                    this.treePath = new TreePath(this.treePath, this.tree);
                    setTreePathMethod.invoke(this.context, this.treePath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public Tree getTree() {
            return this.tree;
        }

        public Trees getTrees() {
            return this.trees;
        }

        public int getCodeOffset() {
            return this.codeOffset;
        }
    }
}

