/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.imperative;

import java.util.Collection;
import java.util.stream.Collectors;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.expression.BooleanExpression;
import org.logstash.config.ir.expression.ExpressionSubstitution;
import org.logstash.config.ir.graph.BooleanEdge;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.IfVertex;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.config.ir.imperative.Statement;
import org.logstash.plugins.ConfigVariableExpander;

public class IfStatement
extends Statement {
    private final BooleanExpression booleanExpression;
    private final Statement trueStatement;
    private final Statement falseStatement;

    public BooleanExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    public Statement getTrueStatement() {
        return this.trueStatement;
    }

    public Statement getFalseStatement() {
        return this.falseStatement;
    }

    public IfStatement(SourceWithMetadata meta, BooleanExpression booleanExpression, Statement trueStatement, Statement falseStatement) throws InvalidIRException {
        super(meta);
        if (booleanExpression == null) {
            throw new InvalidIRException("Boolean expr must eNot be null!");
        }
        if (trueStatement == null) {
            throw new InvalidIRException("If Statement needs true statement!");
        }
        if (falseStatement == null) {
            throw new InvalidIRException("If Statement needs false statement!");
        }
        this.booleanExpression = booleanExpression;
        this.trueStatement = trueStatement;
        this.falseStatement = falseStatement;
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (sourceComponent == this) {
            return true;
        }
        if (sourceComponent instanceof IfStatement) {
            IfStatement other = (IfStatement)sourceComponent;
            return this.booleanExpression.sourceComponentEquals(other.getBooleanExpression()) && this.trueStatement.sourceComponentEquals(other.trueStatement) && this.falseStatement.sourceComponentEquals(other.falseStatement);
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        return IfStatement.indentPadding(indent) + "(if " + this.booleanExpression.toString(0) + "\n" + String.valueOf(this.trueStatement) + "\n" + String.valueOf(this.falseStatement) + ")";
    }

    @Override
    public Graph toGraph(ConfigVariableExpander cve) throws InvalidIRException {
        Graph trueGraph = this.getTrueStatement().toGraph(cve);
        Graph falseGraph = this.getFalseStatement().toGraph(cve);
        if (trueGraph.isEmpty() && falseGraph.isEmpty()) {
            return new Graph();
        }
        Graph.GraphCombinationResult combination = Graph.combine(trueGraph, falseGraph);
        Graph newGraph = combination.graph;
        Collection trueRoots = trueGraph.roots().map(combination.oldToNewVertices::get).collect(Collectors.toList());
        Collection falseRoots = falseGraph.roots().map(combination.oldToNewVertices::get).collect(Collectors.toList());
        IfVertex ifVertex = new IfVertex(this.getSourceWithMetadata(), (BooleanExpression)ExpressionSubstitution.substituteBoolExpression(cve, this.booleanExpression));
        newGraph.addVertex(ifVertex);
        for (Vertex v : trueRoots) {
            newGraph.chainVerticesUnsafe(BooleanEdge.trueFactory, ifVertex, v);
        }
        for (Vertex v : falseRoots) {
            newGraph.chainVerticesUnsafe(BooleanEdge.falseFactory, ifVertex, v);
        }
        return newGraph;
    }
}

