/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import com.github.luben.zstd.Zstd;
import java.util.Locale;
import org.logstash.ackedqueue.AbstractZstdAwareCompressionCodec;
import org.logstash.ackedqueue.AtomicIORatioMetric;
import org.logstash.ackedqueue.CalculatedRelativeSpendMetric;
import org.logstash.ackedqueue.CompressionCodec;
import org.logstash.ackedqueue.IORatioMetric;
import org.logstash.ackedqueue.RelativeSpendMetric;

class ZstdEnabledCompressionCodec
extends AbstractZstdAwareCompressionCodec
implements CompressionCodec {
    private final int internalLevel;
    private final IORatioMetric encodeRatioMetric;
    private final RelativeSpendMetric encodeTimerMetric;

    ZstdEnabledCompressionCodec(Goal internalLevel, Metric queueMetric) {
        super(queueMetric);
        this.internalLevel = internalLevel.internalLevel;
        NamespacedMetric encodeNamespace = queueMetric.namespace("compression", "encode");
        encodeNamespace.gauge("goal", internalLevel.name().toLowerCase(Locale.ROOT));
        this.encodeRatioMetric = encodeNamespace.namespace("ratio").register("lifetime", AtomicIORatioMetric.FACTORY);
        this.encodeTimerMetric = encodeNamespace.namespace("spend").register("lifetime", CalculatedRelativeSpendMetric.FACTORY);
    }

    @Override
    public byte[] encode(byte[] data) {
        try {
            byte[] encoded = this.encodeTimerMetric.time(() -> Zstd.compress((byte[])data, (int)this.internalLevel));
            this.encodeRatioMetric.incrementBy(data.length, encoded.length);
            this.logger.trace("encoded {} -> {}", (Object)data.length, (Object)encoded.length);
            return encoded;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while encoding", e);
        }
    }

    public static enum Goal {
        FASTEST(-7),
        SPEED(-1),
        BALANCED(3),
        HIGH(14),
        SIZE(22);

        private int internalLevel;

        private Goal(int internalLevel) {
            this.internalLevel = internalLevel;
        }
    }
}

