/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.StandardLevel;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class Log4jLogAdapter
implements LogAdapter,
Comparable {
    private final Logger logger;

    public Log4jLogAdapter(Logger logger) {
        this.logger = logger;
    }

    public void debug(Serializable message) {
        this.logger.log(Level.DEBUG, (Object)message, null);
    }

    public void error(Serializable message) {
        this.logger.log(Level.ERROR, (Object)message, null);
    }

    public void error(CharSequence message, Throwable throwable) {
        this.logger.log(Level.ERROR, message, throwable);
    }

    public void info(CharSequence message) {
        this.logger.log(Level.INFO, message, null);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(Serializable message) {
        this.logger.log(Level.WARN, (Object)message, null);
    }

    public void fatal(Object message) {
        this.logger.log(Level.FATAL, message, null);
    }

    public void fatal(CharSequence message, Throwable throwable) {
        this.logger.log(Level.FATAL, message, throwable);
    }

    public void setLogLevel(LogLevel level) {
        Level l;
        switch (level.getLevel()) {
            case 1: {
                l = Level.OFF;
                break;
            }
            case 2: {
                l = Level.ALL;
                break;
            }
            case 3: {
                l = Level.DEBUG;
                break;
            }
            case 4: {
                l = Level.DEBUG;
                break;
            }
            case 5: {
                l = Level.INFO;
                break;
            }
            case 6: {
                l = Level.WARN;
                break;
            }
            case 7: {
                l = Level.ERROR;
                break;
            }
            case 8: {
                l = Level.FATAL;
                break;
            }
            default: {
                l = null;
            }
        }
        Configurator.setLevel((String)this.logger.getName(), (Level)l);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public LogLevel getLogLevel() {
        Level l = this.logger.getLevel();
        return this.toLogLevel(l);
    }

    private LogLevel toLogLevel(Level l) {
        if (l == null) {
            return LogLevel.NONE;
        }
        switch (StandardLevel.getStandardLevel((int)l.intLevel())) {
            case OFF: {
                return LogLevel.OFF;
            }
            case ALL: {
                return LogLevel.ALL;
            }
            case DEBUG: {
                return LogLevel.DEBUG;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case WARN: {
                return LogLevel.WARN;
            }
            case ERROR: {
                return LogLevel.ERROR;
            }
            case FATAL: {
                return LogLevel.FATAL;
            }
        }
        return LogLevel.DEBUG;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Log4jLogAdapter)o).getName());
    }

    public LogLevel getEffectiveLogLevel() {
        Level l = this.logger.getLevel();
        return this.toLogLevel(l);
    }

    public Iterator<Appender> getLogHandler() {
        return LoggerContext.getContext().getConfiguration().getAppenders().values().iterator();
    }
}

