/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.geoip;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.logstash.filters.geoip.Field;

enum Database {
    CITY("City", EnumSet.of(Field.IP, new Field[]{Field.CITY_NAME, Field.CONTINENT_CODE, Field.COUNTRY_NAME, Field.COUNTRY_CODE2, Field.COUNTRY_CODE3, Field.POSTAL_CODE, Field.DMA_CODE, Field.REGION_NAME, Field.REGION_ISO_CODE, Field.TIMEZONE, Field.LOCATION, Field.LATITUDE, Field.LONGITUDE})),
    COUNTRY("Country", EnumSet.of(Field.IP, Field.COUNTRY_CODE2, Field.COUNTRY_NAME, Field.CONTINENT_NAME)),
    DOMAIN("GeoIP2-Domain", EnumSet.of(Field.DOMAIN)),
    ASN("GeoLite2-ASN", EnumSet.of(Field.IP, Field.AUTONOMOUS_SYSTEM_NUMBER, Field.AUTONOMOUS_SYSTEM_ORGANIZATION)),
    ISP("GeoIP2-ISP", EnumSet.of(Field.IP, Field.AUTONOMOUS_SYSTEM_NUMBER, Field.AUTONOMOUS_SYSTEM_ORGANIZATION, Field.ISP, Field.ORGANIZATION)),
    ANONYMOUS_IP("GeoIP2-Anonymous-IP", EnumSet.of(Field.HOSTING_PROVIDER, new Field[]{Field.TOR_EXIT_NODE, Field.ANONYMOUS_VPN, Field.ANONYMOUS, Field.PUBLIC_PROXY, Field.RESIDENTIAL_PROXY})),
    ENTERPRISE("Enterprise", EnumSet.of(Field.IP, new Field[]{Field.COUNTRY_CODE2, Field.COUNTRY_NAME, Field.CONTINENT_NAME, Field.REGION_ISO_CODE, Field.REGION_NAME, Field.CITY_NAME, Field.LOCATION})),
    UNKNOWN("Unknown", EnumSet.noneOf(Field.class));

    private final String databaseType;
    private final Set<Field> defaultFields;

    private Database(String databaseType, Set<Field> defaultFields) {
        this.databaseType = databaseType;
        this.defaultFields = defaultFields;
    }

    public Set<Field> getDefaultFields() {
        return Collections.unmodifiableSet(this.defaultFields);
    }

    public static Database fromDatabaseType(String type) {
        if (type.contains(Database.CITY.databaseType)) {
            return CITY;
        }
        if (type.contains(Database.COUNTRY.databaseType)) {
            return COUNTRY;
        }
        if (type.contains(Database.DOMAIN.databaseType)) {
            return DOMAIN;
        }
        if (type.contains(Database.ASN.databaseType)) {
            return ASN;
        }
        if (type.contains(Database.ISP.databaseType)) {
            return ISP;
        }
        if (type.contains(Database.ENTERPRISE.databaseType)) {
            return ENTERPRISE;
        }
        if (type.contains(Database.ANONYMOUS_IP.databaseType)) {
            return ANONYMOUS_IP;
        }
        return UNKNOWN;
    }
}

