/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.slave;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.ReplicationMessageReceive;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.slave.ReplicationLogScan;
import org.apache.derby.shared.common.error.StandardException;

public class SlaveController
implements SlaveFactory,
ModuleControl,
ModuleSupportable {
    private static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private RawStoreFactory rawStoreFactory;
    private LogToFile logToFile;
    private ReplicationMessageReceive receiver;
    private ReplicationLogger repLogger;
    private SlaveAddress slaveAddr;
    private String dbname;
    private volatile long highestLogInstant = -1L;
    private volatile boolean inReplicationSlaveMode = true;
    private volatile boolean startupSuccessful = false;
    private ReplicationLogScan logScan;
    private SlaveLogReceiverThread logReceiverThread;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        String port = properties.getProperty("slavePort");
        try {
            int slavePort = -1;
            if (port != null) {
                slavePort = Integer.parseInt(port);
            }
            this.slaveAddr = new SlaveAddress(properties.getProperty("slaveHost"), slavePort);
        }
        catch (UnknownHostException uhe) {
            throw StandardException.newException((String)"XRE04.C.1", (Throwable)uhe, (Object[])new Object[]{this.dbname, this.getHostName(), String.valueOf(this.getPortNumber())});
        }
        this.dbname = properties.getProperty("replication.slave.dbname");
        this.repLogger = new ReplicationLogger(this.dbname);
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode) {
            try {
                this.stopSlave(true);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canSupport(Properties startParams) {
        String modeParam = startParams.getProperty("replication.slave.mode");
        return modeParam != null && modeParam.equals("slavemode");
    }

    @Override
    public void startSlave(RawStoreFactory rawStore, LogFactory logFac) throws StandardException {
        this.rawStoreFactory = rawStore;
        try {
            this.logToFile = (LogToFile)logFac;
        }
        catch (ClassCastException cce) {
            throw StandardException.newException((String)"XRE00", (Object[])new Object[0]);
        }
        this.logToFile.initializeReplicationSlaveRole();
        this.receiver = new ReplicationMessageReceive(this.slaveAddr, this.dbname);
        while (!this.setupConnection()) {
            if (this.inReplicationSlaveMode) continue;
            return;
        }
        this.logScan = new ReplicationLogScan();
        this.startLogReceiverThread();
        this.startupSuccessful = true;
        Monitor.logTextMessage("R003", this.dbname);
    }

    private void stopSlave() throws StandardException {
        this.inReplicationSlaveMode = false;
        this.teardownNetwork();
        this.logToFile.stopReplicationSlaveRole();
        Monitor.logTextMessage("R004", this.dbname);
    }

    @Override
    public void stopSlave(boolean forcedStop) throws StandardException {
        if (!forcedStop && this.isConnectedToMaster()) {
            throw StandardException.newException((String)"XRE41.C", (Object[])new Object[0]);
        }
        this.stopSlave();
    }

    @Override
    public void failover() throws StandardException {
        if (this.isConnectedToMaster()) {
            throw StandardException.newException((String)"XRE41.C", (Object[])new Object[0]);
        }
        this.doFailover();
        this.teardownNetwork();
    }

    private void doFailover() {
        this.inReplicationSlaveMode = false;
        this.logToFile.failoverSlave();
        Monitor.logTextMessage("R020", this.dbname);
    }

    @Override
    public boolean isStarted() {
        return this.startupSuccessful;
    }

    private boolean setupConnection() throws StandardException {
        try {
            if (this.highestLogInstant != -1L) {
                this.receiver.initConnection(1000, this.highestLogInstant, this.dbname);
            } else {
                this.receiver.initConnection(1000, this.logToFile.getFirstUnflushedInstantAsLong(), this.dbname);
            }
            return true;
        }
        catch (StandardException se) {
            throw se;
        }
        catch (SocketTimeoutException ste) {
            return false;
        }
        catch (Exception e) {
            throw StandardException.newException((String)"XRE04.C.1", (Throwable)e, (Object[])new Object[]{this.dbname, this.getHostName(), String.valueOf(this.getPortNumber())});
        }
    }

    private void handleDisconnect(Exception e) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R006", e);
        try {
            while (!this.setupConnection()) {
                if (this.inReplicationSlaveMode) continue;
                return;
            }
            this.startLogReceiverThread();
        }
        catch (StandardException se) {
            this.handleFatalException((Exception)((Object)se));
        }
    }

    private boolean isConnectedToMaster() {
        if (this.receiver == null) {
            return false;
        }
        return this.receiver.isConnectedToMaster();
    }

    private void startLogReceiverThread() {
        this.logReceiverThread = new SlaveLogReceiverThread();
        this.logReceiverThread.setDaemon(true);
        this.logReceiverThread.start();
    }

    private void handleFatalException(Exception e) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R005", e);
        try {
            this.stopSlave();
        }
        catch (StandardException se) {
            this.repLogger.logError("R005", se);
        }
    }

    private void teardownNetwork() {
        try {
            if (this.receiver != null) {
                this.receiver.tearDown();
                this.receiver = null;
            }
        }
        catch (IOException ioe) {
            this.repLogger.logError(null, ioe);
        }
    }

    private String getHostName() {
        return this.slaveAddr.getHostAddress().getHostName();
    }

    private int getPortNumber() {
        return this.slaveAddr.getPortNumber();
    }

    private class SlaveLogReceiverThread
    extends Thread {
        SlaveLogReceiverThread() {
            super("derby.slave.logger-" + SlaveController.this.dbname);
        }

        @Override
        public void run() {
            try {
                block9: while (SlaveController.this.inReplicationSlaveMode) {
                    ReplicationMessage message = SlaveController.this.receiver.readMessage();
                    switch (message.getType()) {
                        case 10: {
                            byte[] logChunk = (byte[])message.getMessage();
                            this.handleLogChunk(logChunk);
                            continue block9;
                        }
                        case 21: {
                            SlaveController.this.doFailover();
                            ReplicationMessage ack = new ReplicationMessage(11, "failover succeeded");
                            SlaveController.this.receiver.sendMessage(ack);
                            SlaveController.this.teardownNetwork();
                            continue block9;
                        }
                        case 20: {
                            SlaveController.this.stopSlave();
                            continue block9;
                        }
                    }
                    System.out.println("Not handling non-log messages yet - got a type " + message.getType());
                }
            }
            catch (EOFException eofe) {
                SlaveController.this.handleDisconnect(eofe);
            }
            catch (StandardException se) {
                SlaveController.this.handleFatalException((Exception)((Object)se));
            }
            catch (Exception e) {
                StandardException se = StandardException.newException((String)"XRE03", (Throwable)e, (Object[])new Object[0]);
                SlaveController.this.handleFatalException((Exception)((Object)se));
            }
        }

        private void handleLogChunk(byte[] logChunk) throws StandardException {
            SlaveController.this.logScan.init(logChunk);
            while (SlaveController.this.logScan.next()) {
                if (SlaveController.this.logScan.isLogFileSwitch()) {
                    SlaveController.this.logToFile.switchLogFile();
                    continue;
                }
                long localInstant = SlaveController.this.logToFile.appendLogRecord(SlaveController.this.logScan.getData(), 0, SlaveController.this.logScan.getDataLength(), null, 0, 0);
                if (SlaveController.this.logScan.getInstant() != localInstant) {
                    throw StandardException.newException((String)"XRE05.C", (Object[])new Object[]{SlaveController.this.dbname, LogCounter.getLogFileNumber(SlaveController.this.logScan.getInstant()), LogCounter.getLogFilePosition(SlaveController.this.logScan.getInstant()), LogCounter.getLogFileNumber(localInstant), LogCounter.getLogFilePosition(localInstant)});
                }
                SlaveController.this.highestLogInstant = localInstant;
            }
        }
    }
}

