/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            this.pos = this.control.write(b, this.pos);
        }
        catch (StandardException se) {
            throw Util.newIOException(se);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            this.pos = this.control.write(b, off, len, this.pos);
        }
        catch (StandardException se) {
            if (se.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(se.getMessage());
            }
            throw Util.newIOException(se);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

