/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaUtil {
    private FormulaUtil() {
    }

    public static Object[] getReferences(String formula) throws ParseException {
        int separator;
        String formulaExpression = formula.length() > 0 && formula.charAt(0) == '=' ? formula.substring(1) : ((separator = formula.indexOf(58)) <= 0 || separator + 1 == formula.length() ? null : formula.substring(separator + 1));
        if (formulaExpression == null) {
            throw new ParseException("Formula is invalid");
        }
        return FormulaUtil.getReferences(new Formula(formulaExpression));
    }

    public static Object[] getReferences(Formula formula) {
        LinkedMap map = new LinkedMap();
        LValue lValue = formula.getRootReference();
        FormulaUtil.collectReferences(lValue, map);
        return map.keys();
    }

    private static void collectReferences(LValue lval, LinkedMap map) {
        if (lval instanceof Term) {
            Term t = (Term)lval;
            LValue[] childValues = t.getChildValues();
            for (int i = 0; i < childValues.length; ++i) {
                LValue childValue = childValues[i];
                FormulaUtil.collectReferences(childValue, map);
            }
        } else if (lval instanceof ContextLookup) {
            ContextLookup cl = (ContextLookup)lval;
            map.put((Object)cl.getName(), (Object)Boolean.TRUE);
        }
    }
}

