/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;

@RequestScoped
public class RequestScopedStatelessSessionHolder {
    private final Map<String, StatelessSession> sessions = new HashMap<String, StatelessSession>();

    public StatelessSession getOrCreateSession(String name, SessionFactory factory) {
        return this.sessions.computeIfAbsent(name, n -> factory.openStatelessSession());
    }

    @PreDestroy
    public void destroy() {
        for (Map.Entry<String, StatelessSession> entry : this.sessions.entrySet()) {
            entry.getValue().close();
        }
    }
}

