/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Hashtable;

public class Primitive
extends ASN1Object
implements Serializable {
    private Class basicType;
    private Object value;
    private static Hashtable checkup = new Hashtable(20);

    private static void register(ASN1Type type, Class r) {
        checkup.put(type, r);
    }

    public void init(ASN1Type type) {
        this.asn1Type = type;
        this.byteArray = null;
        this.basicType = (Class)checkup.get(type);
        this.value = null;
    }

    public Class getType() {
        return this.basicType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object v) {
        if (!this.ofType(v, this.basicType)) {
            throw new IllegalArgumentException("Incompatible type");
        }
        this.value = v;
    }

    public String toString() {
        String result = super.toString();
        result = result + "\n\t" + this.basicType.toString();
        result = result + "\tvalue " + this.value;
        return result;
    }

    private boolean ofType(Object o, Class t) {
        if (t.getName().equals("java.lang.Boolean") && o instanceof Boolean) {
            return true;
        }
        if (t.getName().equals("java.lang.String") && o instanceof String) {
            return true;
        }
        if (t.getName().equals("java.math.BigInteger") && o instanceof BigInteger) {
            return true;
        }
        return t.getName().equals("java.lang.Object") && o instanceof Object;
    }

    static {
        Primitive.register(ASN1Type.BOOLEAN, new Boolean(true).getClass());
        Primitive.register(ASN1Type.INTEGER, new BigInteger("0").getClass());
        Primitive.register(ASN1Type.OCTET_STRING, new Object().getClass());
        Primitive.register(ASN1Type.NULL, new Object().getClass());
        Primitive.register(ASN1Type.OBJECT_ID, new String().getClass());
        Primitive.register(ASN1Type.BIT_STRING, new Object().getClass());
        Primitive.register(ASN1Type.IA5String, new String().getClass());
        Primitive.register(ASN1Type.T61String, new String().getClass());
        Primitive.register(ASN1Type.PrintableString, new String().getClass());
        Primitive.register(ASN1Type.UTCTime, new String().getClass());
        Primitive.register(ASN1Type.GENERALIZEDTIME, new String().getClass());
        Primitive.register(ASN1Type.UniversalString, new Object().getClass());
        Primitive.register(ASN1Type.BMPString, new Object().getClass());
        Primitive.register(ASN1Type.ENUMERATED, new BigInteger("0").getClass());
    }
}

