/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.StringsCompleter;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ManagedItemProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class ItemConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private static final String SUBCMD_ADDTAG = "addTag";
    private static final String SUBCMD_RMTAG = "rmTag";
    private static final StringsCompleter SUBCMD_COMPLETER = new StringsCompleter(List.of("list", "clear", "remove", "addTag", "rmTag"), false);
    private final ItemRegistry itemRegistry;
    private final ManagedItemProvider managedItemProvider;

    @Activate
    public ItemConsoleCommandExtension(@Reference ItemRegistry itemRegistry, @Reference ManagedItemProvider managedItemProvider) {
        super("items", "Access the item registry.");
        this.itemRegistry = itemRegistry;
        this.managedItemProvider = managedItemProvider;
    }

    @Override
    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("list [<pattern>]", "lists names and types of all items (matching the pattern, if given)"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all items"), this.buildCommandUsage("remove <itemName>", "removes the given item"), this.buildCommandUsage("addTag <itemName> <tag>", "adds a tag to the given item"), this.buildCommandUsage("rmTag <itemName> <tag>", "removes a tag from the given item"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String[] args, Console console) {
        block23: {
            String subCommand;
            if (args.length <= 0) break block23;
            switch (subCommand = args[0]) {
                case "list": {
                    this.listItems(console, args.length < 2 ? "*" : args[1]);
                    return;
                }
                case "clear": {
                    this.removeItems(console, this.itemRegistry.getAll());
                    return;
                }
                case "remove": {
                    if (args.length > 1) {
                        Item item = (Item)this.itemRegistry.get((Object)args[1]);
                        if (item != null) {
                            this.removeItems(console, Set.of(item));
                            return;
                        }
                        console.println("0 item(s) removed.");
                        return;
                    }
                    console.println("Specify the name of the item to remove: " + this.getCommand() + " remove <itemName>");
                    return;
                }
                case "addTag": {
                    if (args.length > 2) {
                        Item item = (Item)this.itemRegistry.get((Object)args[1]);
                        if (!(item instanceof GenericItem)) return;
                        GenericItem gItem = (GenericItem)item;
                        this.handleTags(arg_0 -> ((GenericItem)gItem).addTag(arg_0), args[2], gItem, console);
                        return;
                    }
                    console.println("Specify the name of the item and the tag: " + this.getCommand() + " addTag <itemName> <tag>");
                    return;
                }
                case "rmTag": {
                    if (args.length > 2) {
                        Item item = (Item)this.itemRegistry.get((Object)args[1]);
                        if (!(item instanceof GenericItem)) return;
                        GenericItem gItem = (GenericItem)item;
                        this.handleTags(arg_0 -> ((GenericItem)gItem).removeTag(arg_0), args[2], gItem, console);
                        return;
                    }
                    console.println("Specify the name of the item and the tag: " + this.getCommand() + " rmTag <itemName> <tag>");
                    return;
                }
                default: {
                    console.println("Unknown command '" + subCommand + "'");
                    this.printUsage(console);
                    return;
                }
            }
        }
        this.printUsage(console);
    }

    @Override
    public @Nullable ConsoleCommandCompleter getCompleter() {
        return new ItemConsoleCommandCompleter();
    }

    private <T> void handleTags(Consumer<T> func, T tag, GenericItem gItem, Console console) {
        if (this.managedItemProvider.get((Object)gItem.getName()) != null) {
            func.accept(tag);
            Item oldItem = (Item)this.itemRegistry.update((Identifiable)gItem);
            if (oldItem != null) {
                console.println("Successfully changed tag " + String.valueOf(tag) + " on item " + gItem.getName());
            }
        } else {
            console.println("Error: Cannot change tag " + String.valueOf(tag) + " on item " + gItem.getName() + " because this item does not belong to a ManagedProvider");
        }
    }

    private void removeItems(Console console, Collection<Item> items) {
        int count = items.size();
        for (Item item : items) {
            this.itemRegistry.remove((Object)item.getName());
        }
        console.println(count + " item(s) removed successfully.");
    }

    private void listItems(Console console, String pattern) {
        Collection items = this.itemRegistry.getItems(pattern);
        if (!items.isEmpty()) {
            for (Item item : items) {
                console.println(item.toString());
            }
        } else if (pattern.isEmpty()) {
            console.println("No item found.");
        } else {
            console.println("No item found for this pattern.");
        }
    }

    private class ItemConsoleCommandCompleter
    implements ConsoleCommandCompleter {
        private ItemConsoleCommandCompleter() {
        }

        @Override
        public boolean complete(String[] args, int cursorArgumentIndex, int cursorPosition, List<String> candidates) {
            block15: {
                Collection items;
                if (cursorArgumentIndex <= 0) {
                    return SUBCMD_COMPLETER.complete(args, cursorArgumentIndex, cursorPosition, candidates);
                }
                if (cursorArgumentIndex != 1) break block15;
                switch (args[0]) {
                    case "addTag": 
                    case "rmTag": {
                        items = ItemConsoleCommandExtension.this.managedItemProvider.getAll();
                        break;
                    }
                    case "remove": {
                        items = ItemConsoleCommandExtension.this.itemRegistry.getAll();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return new StringsCompleter(items.stream().map(Item::getName).toList(), true).complete(args, cursorArgumentIndex, cursorPosition, candidates);
            }
            if (cursorArgumentIndex == 2 && args[0].equals(ItemConsoleCommandExtension.SUBCMD_RMTAG)) {
                Item item = (Item)ItemConsoleCommandExtension.this.managedItemProvider.get((Object)args[1]);
                if (item == null) {
                    return false;
                }
                return new StringsCompleter(item.getTags(), true).complete(args, cursorArgumentIndex, cursorPosition, candidates);
            }
            return false;
        }
    }
}

