/*	
    MAValue - Protocols for NSValue and NSNumber, plus complex numbers
   
    Copyright (C) 1995, Adam Fedor

*/

#ifndef __MAValue_INCLUDE_
#define __MAValue_INCLUDE_

#ifndef GNUSTEP
#import <Foundation/Foundation.h>
#else
#include <Foundation/NSValue.h>
#endif
#include <MathArray/complex.h>

@protocol NSNumber

- (signed char)charValue;
- (unsigned char)unsignedCharValue;
- (short)shortValue;
- (unsigned short)unsignedShortValue;
- (int)intValue;
- (unsigned int)unsignedIntValue;
- (long)longValue;
- (unsigned long)unsignedLongValue;
- (long long)longLongValue;
- (unsigned long long)unsignedLongLongValue;
- (float)floatValue;
- (double)doubleValue;
- (BOOL)boolValue;
- (NSString *)stringValue;

- (NSComparisonResult)compare:(NSNumber *)otherNumber;
@end

@interface NSNumber (ProtocolExtensions) <NSNumber>
@end

@protocol ComplexNumber

- (complex_float)complexFloatValue;
- (complex_double)complexDoubleValue;

@end

@interface NSNumber (ComplexExtensions) <ComplexNumber>
@end

@interface MANumber : NSNumber

+ (id <NSNumber,ComplexNumber>)numberWithComplexFloat:(complex_float)value;
+ (id <NSNumber,ComplexNumber>)numberWithComplexDouble:(complex_double)value;

@end

#endif
