/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.plain;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.time.DateUtils;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.opensearch.index.fielddata.plain.LeafDoubleFieldData;
import org.opensearch.index.fielddata.plain.LeafLongFieldData;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public class SortedNumericIndexFieldData
extends IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    public SortedNumericIndexFieldData(String fieldName, IndexNumericFieldData.NumericType numericType) {
        this.fieldName = fieldName;
        this.numericType = Objects.requireNonNull(numericType);
        this.valuesSourceType = numericType.getValuesSourceType();
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return this.numericType == IndexNumericFieldData.NumericType.HALF_FLOAT || this.numericType == IndexNumericFieldData.NumericType.UNSIGNED_LONG;
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toMilliSeconds));
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds));
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public LeafNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        switch (this.numericType) {
            case HALF_FLOAT: {
                return new SortedNumericHalfFloatFieldData(reader, field);
            }
            case FLOAT: {
                return new SortedNumericFloatFieldData(reader, field);
            }
            case DOUBLE: {
                return new SortedNumericDoubleFieldData(reader, field);
            }
            case DATE_NANOSECONDS: {
                return new NanoSecondFieldData(reader, field, this.numericType);
            }
            case UNSIGNED_LONG: {
                return new SortedNumericUnsignedLongFieldData(reader, field);
            }
        }
        return new SortedNumericLongFieldData(reader, field, this.numericType);
    }

    static final class SortedNumericHalfFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericHalfFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                NumericDocValues single = DocValues.unwrapSingleton((SortedNumericDocValues)raw);
                if (single != null) {
                    return FieldData.singleton(new SingleHalfFloatValues(single));
                }
                return new MultiHalfFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericFloatFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                NumericDocValues single = DocValues.unwrapSingleton((SortedNumericDocValues)raw);
                if (single != null) {
                    return FieldData.singleton(new SingleFloatValues(single));
                }
                return new MultiFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericDoubleFieldData
    extends LeafDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericDoubleFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                return FieldData.sortableLongBitsToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    public final class NanoSecondFieldData
    extends LeafLongFieldData {
        private final LeafReader reader;
        private final String fieldName;

        NanoSecondFieldData(LeafReader reader, String fieldName, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.fieldName = fieldName;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return SortedNumericIndexFieldData.convertNumeric(this.getLongValuesAsNanos(), DateUtils::toMilliSeconds);
        }

        public SortedNumericDocValues getLongValuesAsNanos() {
            try {
                return DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.fieldName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValueFetcher.Leaf getLeafValueFetcher(DocValueFormat format) {
            final DocValueFormat nanosFormat = DocValueFormat.withNanosecondResolution(format);
            final SortedNumericDocValues values = this.getLongValuesAsNanos();
            return new DocValueFetcher.Leaf(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    return values.advanceExact(docId);
                }

                @Override
                public int docValueCount() throws IOException {
                    return values.docValueCount();
                }

                @Override
                public Object nextValue() throws IOException {
                    return nanosFormat.format(values.nextValue());
                }
            };
        }
    }

    static final class SortedNumericUnsignedLongFieldData
    implements LeafNumericFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericUnsignedLongFieldData(LeafReader reader, String field) {
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
                return FieldData.unsignedLongToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public final ScriptDocValues<BigInteger> getScriptValues() {
            return new ScriptDocValues.UnsignedLongs(this.getLongValues());
        }

        @Override
        public final SortedBinaryDocValues getBytesValues() {
            return FieldData.toUnsignedString(this.getLongValues());
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public void close() {
        }
    }

    static final class SortedNumericLongFieldData
    extends LeafLongFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericLongFieldData(LeafReader reader, String field, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)((int)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }
    }

    static final class SingleFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleFloatValues(NumericDocValues in) {
            this.in = in;
        }

        public double doubleValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)((int)this.in.longValue()));
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }
    }

    static final class MultiHalfFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiHalfFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.nextValue()));
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }
    }

    static final class SingleHalfFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleHalfFloatValues(NumericDocValues in) {
            this.in = in;
        }

        public double doubleValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)((short)this.in.longValue()));
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }

        @Override
        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IndexNumericFieldData.NumericType numericType;

        public Builder(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
        }

        public SortedNumericIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SortedNumericIndexFieldData(this.name, this.numericType);
        }
    }
}

