/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.env;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.OpenSearchFileStore;

@PublicApi(since="1.0.0")
@SuppressForbidden(reason="configures paths for the system")
public class Environment {
    private static final Path[] EMPTY_PATH_ARRAY = new Path[0];
    public static final Setting<String> PATH_HOME_SETTING = Setting.simpleString("path.home", Setting.Property.NodeScope);
    public static final Setting<List<String>> PATH_DATA_SETTING = Setting.listSetting("path.data", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> PATH_LOGS_SETTING = new Setting("path.logs", "", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> PATH_REPO_SETTING = Setting.listSetting("path.repo", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> PATH_SHARED_DATA_SETTING = Setting.simpleString("path.shared_data", Setting.Property.NodeScope);
    public static final Setting<String> PIDFILE_SETTING = Setting.simpleString("pidfile", Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<String> NODE_PIDFILE_SETTING = Setting.simpleString("node.pidfile", PIDFILE_SETTING, Setting.Property.NodeScope);
    private final Settings settings;
    private final Path[] dataFiles;
    private final Path[] repoFiles;
    private final Path configFile;
    private final Path pluginsFile;
    private final Path extensionsDir;
    private final Path modulesFile;
    private final Path sharedDataFile;
    private final Path binFile;
    private final Path libFile;
    private final Path logsFile;
    private final Path pidFile;
    private final Path tmpFile;

    public Environment(Settings settings, Path configPath) {
        this(settings, configPath, true);
    }

    public Environment(Settings settings, Path configPath, boolean nodeLocalStorage) {
        this(settings, configPath, nodeLocalStorage, PathUtils.get((String)System.getProperty("java.io.tmpdir"), (String[])new String[0]));
    }

    Environment(Settings settings, Path configPath, boolean nodeLocalStorage, Path tmpPath) {
        if (!PATH_HOME_SETTING.exists(settings)) {
            throw new IllegalStateException(PATH_HOME_SETTING.getKey() + " is not configured");
        }
        Path homeFile = PathUtils.get((String)PATH_HOME_SETTING.get(settings), (String[])new String[0]).toAbsolutePath().normalize();
        this.configFile = configPath != null ? configPath.toAbsolutePath().normalize() : homeFile.resolve("config");
        this.tmpFile = Objects.requireNonNull(tmpPath);
        this.pluginsFile = homeFile.resolve("plugins");
        this.extensionsDir = homeFile.resolve("extensions");
        List<String> dataPaths = PATH_DATA_SETTING.get(settings);
        if (nodeLocalStorage) {
            if (!dataPaths.isEmpty()) {
                this.dataFiles = new Path[dataPaths.size()];
                for (int i = 0; i < dataPaths.size(); ++i) {
                    this.dataFiles[i] = PathUtils.get((String)dataPaths.get(i), (String[])new String[0]).toAbsolutePath().normalize();
                }
            } else {
                this.dataFiles = new Path[]{homeFile.resolve("data")};
            }
        } else if (dataPaths.isEmpty()) {
            this.dataFiles = EMPTY_PATH_ARRAY;
        } else {
            String paths = String.join((CharSequence)",", dataPaths);
            throw new IllegalStateException("node does not require local storage yet path.data is set to [" + paths + "]");
        }
        this.sharedDataFile = PATH_SHARED_DATA_SETTING.exists(settings) ? PathUtils.get((String)PATH_SHARED_DATA_SETTING.get(settings), (String[])new String[0]).toAbsolutePath().normalize() : null;
        List<String> repoPaths = PATH_REPO_SETTING.get(settings);
        if (repoPaths.isEmpty()) {
            this.repoFiles = EMPTY_PATH_ARRAY;
        } else {
            this.repoFiles = new Path[repoPaths.size()];
            for (int i = 0; i < repoPaths.size(); ++i) {
                this.repoFiles[i] = PathUtils.get((String)repoPaths.get(i), (String[])new String[0]).toAbsolutePath().normalize();
            }
        }
        this.logsFile = PATH_LOGS_SETTING.exists(settings) ? PathUtils.get((String)PATH_LOGS_SETTING.get(settings), (String[])new String[0]).toAbsolutePath().normalize() : homeFile.resolve("logs");
        this.pidFile = NODE_PIDFILE_SETTING.exists(settings) || PIDFILE_SETTING.exists(settings) ? PathUtils.get((String)NODE_PIDFILE_SETTING.get(settings), (String[])new String[0]).toAbsolutePath().normalize() : null;
        this.binFile = homeFile.resolve("bin");
        this.libFile = homeFile.resolve("lib");
        this.modulesFile = homeFile.resolve("modules");
        Settings.Builder finalSettings = Settings.builder().put(settings);
        if (PATH_DATA_SETTING.exists(settings)) {
            finalSettings.putList(PATH_DATA_SETTING.getKey(), Arrays.stream(this.dataFiles).map(Path::toString).collect(Collectors.toList()));
        }
        finalSettings.put(PATH_HOME_SETTING.getKey(), homeFile);
        finalSettings.put(PATH_LOGS_SETTING.getKey(), this.logsFile.toString());
        if (PATH_REPO_SETTING.exists(settings)) {
            finalSettings.putList(PATH_REPO_SETTING.getKey(), Arrays.stream(this.repoFiles).map(Path::toString).collect(Collectors.toList()));
        }
        if (PATH_SHARED_DATA_SETTING.exists(settings)) {
            assert (this.sharedDataFile != null);
            finalSettings.put(PATH_SHARED_DATA_SETTING.getKey(), this.sharedDataFile.toString());
        }
        if (NODE_PIDFILE_SETTING.exists(settings)) {
            assert (this.pidFile != null);
            finalSettings.put(NODE_PIDFILE_SETTING.getKey(), this.pidFile.toString());
        } else if (PIDFILE_SETTING.exists(settings)) {
            assert (this.pidFile != null);
            finalSettings.put(PIDFILE_SETTING.getKey(), this.pidFile.toString());
        }
        this.settings = finalSettings.build();
    }

    public Settings settings() {
        return this.settings;
    }

    public Path[] dataFiles() {
        return this.dataFiles;
    }

    public Path sharedDataFile() {
        return this.sharedDataFile;
    }

    public Path[] repoFiles() {
        return this.repoFiles;
    }

    public Path resolveRepoFile(String location) {
        return PathUtils.get((Path[])this.repoFiles, (String)location);
    }

    public URL resolveRepoURL(URL url) {
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                if (url.getHost() == null || "".equals(url.getHost())) {
                    Path path = PathUtils.get((Path[])this.repoFiles, (URI)url.toURI());
                    if (path == null) {
                        return null;
                    }
                    return path.toUri().toURL();
                }
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                String file = url.getFile();
                int pos = file.indexOf("!/");
                if (pos < 0) {
                    return null;
                }
                String jarTail = file.substring(pos);
                String filePath = file.substring(0, pos);
                URL internalUrl = new URL(filePath);
                URL normalizedUrl = this.resolveRepoURL(internalUrl);
                if (normalizedUrl == null) {
                    return null;
                }
                return new URL("jar", "", normalizedUrl.toExternalForm() + jarTail);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public Path configFile() {
        return this.configFile;
    }

    public Path pluginsFile() {
        return this.pluginsFile;
    }

    public Path binFile() {
        return this.binFile;
    }

    public Path libFile() {
        return this.libFile;
    }

    public Path modulesFile() {
        return this.modulesFile;
    }

    public Path logsFile() {
        return this.logsFile;
    }

    public Path pidFile() {
        return this.pidFile;
    }

    public Path tmpFile() {
        return this.tmpFile;
    }

    public void validateTmpFile() throws IOException {
        if (!Files.exists(this.tmpFile, new LinkOption[0])) {
            throw new FileNotFoundException("Temporary file directory [" + String.valueOf(this.tmpFile) + "] does not exist or is not accessible");
        }
        if (!Files.isDirectory(this.tmpFile, new LinkOption[0])) {
            throw new IOException("Configured temporary file directory [" + String.valueOf(this.tmpFile) + "] is not a directory");
        }
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return new OpenSearchFileStore(Files.getFileStore(path));
    }

    public static void assertEquivalent(Environment actual, Environment expected) {
        Environment.assertEquals(actual.dataFiles(), expected.dataFiles(), "dataFiles");
        Environment.assertEquals(actual.repoFiles(), expected.repoFiles(), "repoFiles");
        Environment.assertEquals(actual.configFile(), expected.configFile(), "configFile");
        Environment.assertEquals(actual.pluginsFile(), expected.pluginsFile(), "pluginsFile");
        Environment.assertEquals(actual.binFile(), expected.binFile(), "binFile");
        Environment.assertEquals(actual.libFile(), expected.libFile(), "libFile");
        Environment.assertEquals(actual.modulesFile(), expected.modulesFile(), "modulesFile");
        Environment.assertEquals(actual.logsFile(), expected.logsFile(), "logsFile");
        Environment.assertEquals(actual.pidFile(), expected.pidFile(), "pidFile");
        Environment.assertEquals(actual.tmpFile(), expected.tmpFile(), "tmpFile");
    }

    private static void assertEquals(Object actual, Object expected, String name) {
        assert (Objects.deepEquals(actual, expected)) : "actual " + name + " [" + String.valueOf(actual) + "] is different than [ " + String.valueOf(expected) + "]";
    }
}

