/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent.support;

import org.opensearch.common.Nullable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.http.HttpChunk;

public final class XContentHttpChunk
implements HttpChunk {
    private final BytesReference content;

    public static HttpChunk from(@Nullable XContentBuilder builder) {
        return new XContentHttpChunk(builder);
    }

    public static HttpChunk last() {
        return new XContentHttpChunk(null);
    }

    private XContentHttpChunk(@Nullable XContentBuilder builder) {
        this.content = builder == null ? BytesArray.EMPTY : BytesReference.bytes((XContentBuilder)builder);
    }

    @Override
    public boolean isLast() {
        return this.content == BytesArray.EMPTY;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    public void close() {
        if (this.content instanceof Releasable) {
            ((Releasable)this.content).close();
        }
    }
}

