/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;

public enum RoutingPool {
    LOCAL_ONLY,
    REMOTE_CAPABLE;


    public static RoutingPool getNodePool(RoutingNode node) {
        return RoutingPool.getNodePool(node.node());
    }

    public static RoutingPool getNodePool(DiscoveryNode node) {
        if (node.isSearchNode()) {
            return REMOTE_CAPABLE;
        }
        return LOCAL_ONLY;
    }

    public static RoutingPool getShardPool(ShardRouting shard, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shard.index());
        return RoutingPool.getIndexPool(indexMetadata);
    }

    public static RoutingPool getIndexPool(IndexMetadata indexMetadata) {
        return indexMetadata.isRemoteSnapshot() ? REMOTE_CAPABLE : LOCAL_ONLY;
    }
}

