/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class ClusterStatsRequest
extends BaseNodesRequest<ClusterStatsRequest> {
    private Boolean useAggregatedNodeLevelResponses = false;

    public ClusterStatsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_2_16_0)) {
            this.useAggregatedNodeLevelResponses = in.readOptionalBoolean();
        }
    }

    public ClusterStatsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public boolean useAggregatedNodeLevelResponses() {
        return this.useAggregatedNodeLevelResponses;
    }

    public void useAggregatedNodeLevelResponses(boolean useAggregatedNodeLevelResponses) {
        this.useAggregatedNodeLevelResponses = useAggregatedNodeLevelResponses;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_16_0)) {
            out.writeOptionalBoolean(this.useAggregatedNodeLevelResponses);
        }
    }
}

