/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.awarenesshealth.ClusterAwarenessHealth;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.health.ClusterStateHealth;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class ClusterHealthResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final String CLUSTER_NAME = "cluster_name";
    private static final String STATUS = "status";
    private static final String TIMED_OUT = "timed_out";
    private static final String NUMBER_OF_NODES = "number_of_nodes";
    private static final String NUMBER_OF_DATA_NODES = "number_of_data_nodes";
    @Deprecated
    private static final String DISCOVERED_MASTER = "discovered_master";
    private static final String DISCOVERED_CLUSTER_MANAGER = "discovered_cluster_manager";
    private static final String NUMBER_OF_PENDING_TASKS = "number_of_pending_tasks";
    private static final String NUMBER_OF_IN_FLIGHT_FETCH = "number_of_in_flight_fetch";
    private static final String DELAYED_UNASSIGNED_SHARDS = "delayed_unassigned_shards";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE = "task_max_waiting_in_queue";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = "task_max_waiting_in_queue_millis";
    private static final String ACTIVE_SHARDS_PERCENT_AS_NUMBER = "active_shards_percent_as_number";
    private static final String ACTIVE_SHARDS_PERCENT = "active_shards_percent";
    private static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String INDICES = "indices";
    private static final ConstructingObjectParser<ClusterHealthResponse, Void> PARSER = new ConstructingObjectParser("cluster_health_response", true, parsedObjects -> {
        Map<String, ClusterIndexHealth> indices;
        List indexList;
        int i = 0;
        int numberOfNodes = (Integer)parsedObjects[i++];
        int numberOfDataNodes = (Integer)parsedObjects[i++];
        boolean hasDiscoveredMaster = Boolean.TRUE.equals(parsedObjects[i++]);
        boolean hasDiscoveredClusterManager = Boolean.TRUE.equals(parsedObjects[i++]);
        int activeShards = (Integer)parsedObjects[i++];
        int relocatingShards = (Integer)parsedObjects[i++];
        int activePrimaryShards = (Integer)parsedObjects[i++];
        int initializingShards = (Integer)parsedObjects[i++];
        int unassignedShards = (Integer)parsedObjects[i++];
        double activeShardsPercent = (Double)parsedObjects[i++];
        String statusStr = (String)parsedObjects[i++];
        ClusterHealthStatus status = ClusterHealthStatus.fromString(statusStr);
        if ((indexList = (List)parsedObjects[i++]) == null || indexList.isEmpty()) {
            indices = Collections.emptyMap();
        } else {
            indices = new HashMap(indexList.size());
            for (ClusterIndexHealth indexHealth : indexList) {
                indices.put(indexHealth.getIndex(), indexHealth);
            }
        }
        ClusterStateHealth stateHealth = new ClusterStateHealth(activePrimaryShards, activeShards, relocatingShards, initializingShards, unassignedShards, numberOfNodes, numberOfDataNodes, hasDiscoveredClusterManager || hasDiscoveredMaster, activeShardsPercent, status, indices);
        String clusterName = (String)parsedObjects[i++];
        int numberOfPendingTasks = (Integer)parsedObjects[i++];
        int numberOfInFlightFetch = (Integer)parsedObjects[i++];
        int delayedUnassignedShards = (Integer)parsedObjects[i++];
        long taskMaxWaitingTimeMillis = (Long)parsedObjects[i++];
        boolean timedOut = (Boolean)parsedObjects[i];
        return new ClusterHealthResponse(clusterName, numberOfPendingTasks, numberOfInFlightFetch, delayedUnassignedShards, TimeValue.timeValueMillis((long)taskMaxWaitingTimeMillis), timedOut, stateHealth);
    });
    private static final ObjectParser.NamedObjectParser<ClusterIndexHealth, Void> INDEX_PARSER = (parser, context, index) -> ClusterIndexHealth.innerFromXContent(parser, index);
    private String clusterName;
    private int numberOfPendingTasks = 0;
    private int numberOfInFlightFetch = 0;
    private int delayedUnassignedShards = 0;
    private TimeValue taskMaxWaitingTime = TimeValue.timeValueMillis((long)0L);
    private boolean timedOut = false;
    private ClusterStateHealth clusterStateHealth;
    private ClusterHealthStatus clusterHealthStatus;
    private ClusterAwarenessHealth clusterAwarenessHealth;

    public ClusterHealthResponse() {
    }

    public ClusterHealthResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = in.readString();
        this.clusterHealthStatus = ClusterHealthStatus.fromValue(in.readByte());
        this.clusterStateHealth = new ClusterStateHealth(in);
        this.numberOfPendingTasks = in.readInt();
        this.timedOut = in.readBoolean();
        this.numberOfInFlightFetch = in.readInt();
        this.delayedUnassignedShards = in.readInt();
        this.taskMaxWaitingTime = in.readTimeValue();
        if (in.getVersion().onOrAfter(Version.V_2_5_0) && in.readBoolean()) {
            this.clusterAwarenessHealth = new ClusterAwarenessHealth(in);
        }
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this(clusterName, concreteIndices, clusterState, -1, -1, -1, TimeValue.timeValueHours((long)0L));
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.clusterStateHealth = new ClusterStateHealth(clusterState, concreteIndices);
        this.clusterHealthStatus = this.clusterStateHealth.getStatus();
    }

    public ClusterHealthResponse(String clusterName, ClusterState clusterState, ClusterSettings clusterSettings, String[] concreteIndices, String awarenessAttributeName, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this(clusterName, concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, delayedUnassignedShards, taskMaxWaitingTime);
        this.clusterAwarenessHealth = new ClusterAwarenessHealth(clusterState, clusterSettings, awarenessAttributeName);
    }

    ClusterHealthResponse(String clusterName, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime, boolean timedOut, ClusterStateHealth clusterStateHealth) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.timedOut = timedOut;
        this.clusterStateHealth = clusterStateHealth;
        this.clusterHealthStatus = clusterStateHealth.getStatus();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    ClusterStateHealth getClusterStateHealth() {
        return this.clusterStateHealth;
    }

    public int getActiveShards() {
        return this.clusterStateHealth.getActiveShards();
    }

    public int getRelocatingShards() {
        return this.clusterStateHealth.getRelocatingShards();
    }

    public int getActivePrimaryShards() {
        return this.clusterStateHealth.getActivePrimaryShards();
    }

    public int getInitializingShards() {
        return this.clusterStateHealth.getInitializingShards();
    }

    public int getUnassignedShards() {
        return this.clusterStateHealth.getUnassignedShards();
    }

    public int getNumberOfNodes() {
        return this.clusterStateHealth.getNumberOfNodes();
    }

    public int getNumberOfDataNodes() {
        return this.clusterStateHealth.getNumberOfDataNodes();
    }

    public boolean hasDiscoveredClusterManager() {
        return this.clusterStateHealth.hasDiscoveredClusterManager();
    }

    @Deprecated
    public boolean hasDiscoveredMaster() {
        return this.hasDiscoveredClusterManager();
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.clusterHealthStatus;
    }

    public void setStatus(ClusterHealthStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' must not be null");
        }
        this.clusterHealthStatus = status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.clusterStateHealth.getIndices();
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.clusterStateHealth.getActiveShardsPercent();
    }

    public ClusterAwarenessHealth getClusterAwarenessHealth() {
        return this.clusterAwarenessHealth;
    }

    public static ClusterHealthResponse readResponseFrom(StreamInput in) throws IOException {
        return new ClusterHealthResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.clusterName);
        out.writeByte(this.clusterHealthStatus.value());
        this.clusterStateHealth.writeTo(out);
        out.writeInt(this.numberOfPendingTasks);
        out.writeBoolean(this.timedOut);
        out.writeInt(this.numberOfInFlightFetch);
        out.writeInt(this.delayedUnassignedShards);
        out.writeTimeValue(this.taskMaxWaitingTime);
        if (out.getVersion().onOrAfter(Version.V_2_5_0)) {
            if (this.clusterAwarenessHealth != null) {
                out.writeBoolean(true);
                this.clusterAwarenessHealth.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    @Override
    public RestStatus status() {
        return this.isTimedOut() ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLUSTER_NAME, this.getClusterName());
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(TIMED_OUT, this.isTimedOut());
        builder.field(NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(DISCOVERED_MASTER, this.hasDiscoveredClusterManager());
        builder.field(DISCOVERED_CLUSTER_MANAGER, this.hasDiscoveredClusterManager());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(DELAYED_UNASSIGNED_SHARDS, this.getDelayedUnassignedShards());
        builder.field(NUMBER_OF_PENDING_TASKS, this.getNumberOfPendingTasks());
        builder.field(NUMBER_OF_IN_FLIGHT_FETCH, this.getNumberOfInFlightFetch());
        builder.humanReadableField(TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, TASK_MAX_WAIT_TIME_IN_QUEUE, (Object)this.getTaskMaxWaitingTime());
        builder.percentageField(ACTIVE_SHARDS_PERCENT_AS_NUMBER, ACTIVE_SHARDS_PERCENT, this.getActiveShardsPercent());
        String level = params.param("level", "cluster");
        boolean outputIndices = INDICES.equals(level) || "shards".equals(level);
        boolean outputAwarenessHealth = "awareness_attributes".equals(level);
        if (outputIndices) {
            builder.startObject(INDICES);
            for (ClusterIndexHealth indexHealth : this.clusterStateHealth.getIndices().values()) {
                indexHealth.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (outputAwarenessHealth && this.clusterAwarenessHealth != null) {
            this.clusterAwarenessHealth.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static ClusterHealthResponse fromXContent(XContentParser parser) {
        return (ClusterHealthResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterHealthResponse that = (ClusterHealthResponse)o;
        return Objects.equals(this.clusterName, that.clusterName) && this.numberOfPendingTasks == that.numberOfPendingTasks && this.numberOfInFlightFetch == that.numberOfInFlightFetch && this.delayedUnassignedShards == that.delayedUnassignedShards && Objects.equals(this.taskMaxWaitingTime, that.taskMaxWaitingTime) && this.timedOut == that.timedOut && Objects.equals(this.clusterStateHealth, that.clusterStateHealth) && this.clusterHealthStatus == that.clusterHealthStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterName, this.numberOfPendingTasks, this.numberOfInFlightFetch, this.delayedUnassignedShards, this.taskMaxWaitingTime, this.timedOut, this.clusterStateHealth, this.clusterHealthStatus});
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_NODES, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_DATA_NODES, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DISCOVERED_MASTER, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DISCOVERED_CLUSTER_MANAGER, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(RELOCATING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_PRIMARY_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(INITIALIZING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS_PERCENT_AS_NUMBER, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATUS, new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), INDEX_PARSER, new ParseField(INDICES, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(CLUSTER_NAME, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_PENDING_TASKS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_IN_FLIGHT_FETCH, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(DELAYED_UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(TIMED_OUT, new String[0]));
    }
}

