/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport;

import java.util.ConcurrentModificationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigRequest;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigResponse;
import org.opensearch.securityanalytics.threatIntel.common.SourceConfigType;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;
import org.opensearch.securityanalytics.threatIntel.model.UrlDownloadSource;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigManagementService;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndexTIFSourceConfigAction
extends HandledTransportAction<SAIndexTIFSourceConfigRequest, SAIndexTIFSourceConfigResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportIndexTIFSourceConfigAction.class);
    private final SATIFSourceConfigManagementService saTifSourceConfigManagementService;
    private final TIFLockService lockService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexTIFSourceConfigAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, SATIFSourceConfigManagementService saTifSourceConfigManagementService, TIFLockService lockService, Settings settings) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/sources/write", transportService, actionFilters, SAIndexTIFSourceConfigRequest::new);
        this.threadPool = threadPool;
        this.saTifSourceConfigManagementService = saTifSourceConfigManagementService;
        this.lockService = lockService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
    }

    protected void doExecute(Task task, SAIndexTIFSourceConfigRequest request, ActionListener<SAIndexTIFSourceConfigResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0]))));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        this.retrieveLockAndCreateTIFConfig(request, listener, user);
    }

    private void retrieveLockAndCreateTIFConfig(SAIndexTIFSourceConfigRequest request, ActionListener<SAIndexTIFSourceConfigResponse> listener, User user) {
        try {
            this.lockService.acquireLock(request.getTIFConfigDto().getId(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> {
                if (lock == null) {
                    listener.onFailure((Exception)new ConcurrentModificationException("another processor is holding a lock on the resource. Try again later"));
                    log.error("another processor is a lock, BAD_REQUEST error", (Object)RestStatus.BAD_REQUEST);
                    return;
                }
                try {
                    SATIFSourceConfigDto saTifSourceConfigDto = request.getTIFConfigDto();
                    if (SourceConfigType.URL_DOWNLOAD.equals((Object)saTifSourceConfigDto.getType()) || saTifSourceConfigDto.getSource() instanceof UrlDownloadSource && request.getMethod().equals((Object)RestRequest.Method.POST)) {
                        listener.onFailure((Exception)new UnsupportedOperationException("Unsupported Threat intel Source Config Type passed - " + String.valueOf((Object)saTifSourceConfigDto.getType())));
                        return;
                    }
                    this.saTifSourceConfigManagementService.createOrUpdateTifSourceConfig(saTifSourceConfigDto, (LockModel)lock, request.getMethod(), user, (ActionListener<SATIFSourceConfigDto>)ActionListener.wrap(saTifSourceConfigDtoResponse -> {
                        this.lockService.releaseLock((LockModel)lock);
                        listener.onResponse((Object)new SAIndexTIFSourceConfigResponse(saTifSourceConfigDtoResponse.getId(), saTifSourceConfigDtoResponse.getVersion(), RestStatus.OK, (SATIFSourceConfigDto)saTifSourceConfigDtoResponse));
                    }, e -> {
                        this.lockService.releaseLock((LockModel)lock);
                        log.error("Failed to create IOCs and threat intel source config");
                        listener.onFailure(e);
                    }));
                }
                catch (Exception e2) {
                    this.lockService.releaseLock((LockModel)lock);
                    listener.onFailure(e2);
                    log.error("listener failed when executing", (Throwable)e2);
                }
            }, exception -> {
                listener.onFailure(exception);
                log.error("execution failed", (Throwable)exception);
            }));
        }
        catch (Exception e) {
            log.error("Failed to acquire lock for job", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

