/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.Config;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.model.WorkflowNode;
import org.opensearch.flowframework.util.ParseUtils;

public class EncryptorUtils {
    private static final Logger logger = LogManager.getLogger(EncryptorUtils.class);
    private static final String ALGORITHM = "AES";
    private static final String PROVIDER = "Custom";
    private static final String WRAPPING_ALGORITHM = "AES/GCM/NOPADDING";
    private final ClusterService clusterService;
    private final Client client;
    private String masterKey = null;
    private final NamedXContentRegistry xContentRegistry;

    public EncryptorUtils(ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    void setMasterKey(String masterKey) {
        this.masterKey = masterKey;
    }

    String getMasterKey() {
        return this.masterKey;
    }

    String generateMasterKey() {
        byte[] masterKeyBytes = new byte[32];
        new SecureRandom().nextBytes(masterKeyBytes);
        return Base64.getEncoder().encodeToString(masterKeyBytes);
    }

    public Template encryptTemplateCredentials(Template template) {
        return this.processTemplateCredentials(template, this::encrypt);
    }

    public Template decryptTemplateCredentials(Template template) {
        return this.processTemplateCredentials(template, this::decrypt);
    }

    private Template processTemplateCredentials(Template template, Function<String, String> cipherFunction) {
        HashMap<String, Workflow> processedWorkflows = new HashMap<String, Workflow>();
        for (Map.Entry<String, Workflow> entry : template.workflows().entrySet()) {
            ArrayList<WorkflowNode> processedNodes = new ArrayList<WorkflowNode>();
            for (WorkflowNode node : entry.getValue().nodes()) {
                if (node.userInputs().containsKey("credential")) {
                    HashMap<String, String> credentials = new HashMap<String, String>((Map)node.userInputs().get("credential"));
                    credentials.replaceAll((key, cred) -> (String)cipherFunction.apply((String)cred));
                    HashMap<String, Object> processedUserInputs = new HashMap<String, Object>();
                    processedUserInputs.putAll(node.userInputs());
                    processedUserInputs.replace("credential", credentials);
                    WorkflowNode processedWorkflowNode = new WorkflowNode(node.id(), node.type(), node.previousNodeInputs(), processedUserInputs);
                    processedNodes.add(processedWorkflowNode);
                    continue;
                }
                processedNodes.add(node);
            }
            processedWorkflows.put(entry.getKey(), new Workflow(entry.getValue().userParams(), processedNodes, entry.getValue().edges()));
        }
        return Template.builder(template).workflows(processedWorkflows).build();
    }

    String encrypt(String credential) {
        this.initializeMasterKeyIfAbsent();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, ALGORITHM), (String)PROVIDER, (String)"", (String)WRAPPING_ALGORITHM);
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, credential.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    String decrypt(String encryptedCredential) {
        this.initializeMasterKeyIfAbsent();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, ALGORITHM), (String)PROVIDER, (String)"", (String)WRAPPING_ALGORITHM);
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedCredential));
        return new String((byte[])decryptedResult.getResult(), StandardCharsets.UTF_8);
    }

    public Template redactTemplateSecuredFields(User user, Template template) {
        HashMap<String, Workflow> processedWorkflows = new HashMap<String, Workflow>();
        for (Map.Entry<String, Workflow> entry : template.workflows().entrySet()) {
            ArrayList<WorkflowNode> processedNodes = new ArrayList<WorkflowNode>();
            for (WorkflowNode node : entry.getValue().nodes()) {
                if (node.userInputs().containsKey("credential")) {
                    HashMap<String, Object> processedUserInputs = new HashMap<String, Object>(node.userInputs());
                    processedUserInputs.remove("credential");
                    processedNodes.add(new WorkflowNode(node.id(), node.type(), node.previousNodeInputs(), processedUserInputs));
                    continue;
                }
                processedNodes.add(node);
            }
            processedWorkflows.put(entry.getKey(), new Workflow(entry.getValue().userParams(), processedNodes, entry.getValue().edges()));
        }
        if (ParseUtils.isAdmin(user)) {
            return Template.builder(template).workflows(processedWorkflows).build();
        }
        return Template.builder(template).user(null).workflows(processedWorkflows).build();
    }

    public void initializeMasterKey(ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            GetRequest getRequest = new GetRequest(".plugins-flow-framework-config").id("master_key");
            this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    Config config = new Config(this.generateMasterKey(), Instant.now());
                    IndexRequest masterKeyIndexRequest = (IndexRequest)new IndexRequest(".plugins-flow-framework-config").id("master_key").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                        masterKeyIndexRequest.source(config.toXContent(builder, ToXContent.EMPTY_PARAMS));
                    }
                    this.client.index(masterKeyIndexRequest, ActionListener.wrap(indexResponse -> {
                        context.restore();
                        logger.info("Config has been initialized successfully");
                        this.masterKey = config.masterKey();
                        listener.onResponse((Object)true);
                    }, indexException -> {
                        logger.error("Failed to index config", (Throwable)indexException);
                        listener.onFailure(indexException);
                    }));
                } else {
                    context.restore();
                    logger.debug("Config has already been initialized, fetching key");
                    try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, getResponse.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        Config config = Config.parse(parser);
                        this.masterKey = config.masterKey();
                        listener.onResponse((Object)true);
                    }
                    catch (FlowFrameworkException e) {
                        listener.onFailure((Exception)((Object)e));
                    }
                }
            }, getRequestException -> {
                logger.error("Failed to search for config from config index", (Throwable)getRequestException);
                listener.onFailure(getRequestException);
            }));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve config from config index", (Throwable)e);
            listener.onFailure(e);
        }
    }

    void initializeMasterKeyIfAbsent() {
        if (this.masterKey != null) {
            return;
        }
        if (!this.clusterService.state().metadata().hasIndex(".plugins-flow-framework-config")) {
            throw new FlowFrameworkException("Config Index has not been initialized", RestStatus.INTERNAL_SERVER_ERROR);
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            GetRequest getRequest = new GetRequest(".plugins-flow-framework-config").id("master_key");
            this.client.get(getRequest, ActionListener.wrap(response -> {
                context.restore();
                if (response.isExists()) {
                    try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        Config config = Config.parse(parser);
                        this.masterKey = config.masterKey();
                    }
                } else {
                    throw new FlowFrameworkException("Master key has not been initialized in config index", RestStatus.NOT_FOUND);
                }
            }, exception -> {
                throw new FlowFrameworkException("Failed to get master key from config index", ExceptionsHelper.status((Throwable)exception));
            }));
        }
    }
}

