/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.model.Template;

public class WorkflowRequest
extends ActionRequest {
    @Nullable
    private String workflowId;
    @Nullable
    private Template template;
    private String[] validation;
    private boolean provision;
    private boolean updateFields;
    private Map<String, String> params;
    private String useCase;
    private Map<String, String> defaultParams;

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template) {
        this(workflowId, template, new String[]{"all"}, false, Collections.emptyMap(), null, Collections.emptyMap());
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, Map<String, String> params) {
        this(workflowId, template, new String[]{"all"}, true, params, null, Collections.emptyMap());
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String useCase, Map<String, String> defaultParams) {
        this(workflowId, template, new String[]{"all"}, false, Collections.emptyMap(), useCase, defaultParams);
    }

    public WorkflowRequest(@Nullable String workflowId, @Nullable Template template, String[] validation, boolean provisionOrUpdate, Map<String, String> params, String useCase, Map<String, String> defaultParams) {
        this.workflowId = workflowId;
        this.template = template;
        this.validation = validation;
        this.provision = provisionOrUpdate && !params.containsKey("update_fields");
        boolean bl = this.updateFields = !this.provision && Boolean.parseBoolean(params.get("update_fields"));
        if (!this.provision && params.keySet().stream().anyMatch(k -> !"update_fields".equals(k))) {
            throw new IllegalArgumentException("Params may only be included when provisioning.");
        }
        this.params = this.updateFields ? Collections.emptyMap() : params;
        this.useCase = useCase;
        this.defaultParams = defaultParams;
    }

    public WorkflowRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readOptionalString();
        String templateJson = in.readOptionalString();
        this.template = templateJson == null ? null : Template.parse(templateJson);
        this.validation = in.readStringArray();
        boolean provisionOrUpdate = in.readBoolean();
        this.params = provisionOrUpdate ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
        this.provision = provisionOrUpdate && !this.params.containsKey("update_fields");
        boolean bl = this.updateFields = !this.provision && Boolean.parseBoolean(this.params.get("update_fields"));
        if (this.updateFields) {
            this.params = Collections.emptyMap();
        }
    }

    @Nullable
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Nullable
    public Template getTemplate() {
        return this.template;
    }

    public String[] getValidation() {
        return this.validation;
    }

    public boolean isProvision() {
        return this.provision;
    }

    public boolean isUpdateFields() {
        return this.updateFields;
    }

    public Map<String, String> getParams() {
        return Map.copyOf(this.params);
    }

    public String getUseCase() {
        return this.useCase;
    }

    public Map<String, String> getDefaultParams() {
        return Map.copyOf(this.defaultParams);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.workflowId);
        out.writeOptionalString(this.template == null ? null : this.template.toJson());
        out.writeStringArray(this.validation);
        out.writeBoolean(this.provision || this.updateFields);
        if (this.provision) {
            out.writeMap(this.params, StreamOutput::writeString, StreamOutput::writeString);
        } else if (this.updateFields) {
            out.writeMap(Map.of("update_fields", "true"), StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

