/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.upgrade;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.cli.Terminal;
import org.opensearch.common.collect.Tuple;
import org.opensearch.upgrade.TaskInput;
import org.opensearch.upgrade.UpgradeTask;

class ImportJvmOptionsTask
implements UpgradeTask {
    private static final String JVM_OPTIONS_D = "jvm.options.d";

    ImportJvmOptionsTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        try {
            Path esJvmOptionsDir;
            terminal.println("Importing JVM options ...");
            Path jvmOptionsDir = taskInput.getOpenSearchConfig().resolve(JVM_OPTIONS_D);
            if (!Files.exists(jvmOptionsDir, new LinkOption[0])) {
                Files.createDirectory(jvmOptionsDir, new FileAttribute[0]);
            }
            if (Files.exists(esJvmOptionsDir = taskInput.getEsConfig().resolve(JVM_OPTIONS_D), new LinkOption[0]) && Files.isDirectory(esJvmOptionsDir, new LinkOption[0])) {
                List esJvmOptionsFiles = Files.list(esJvmOptionsDir).collect(Collectors.toList());
                for (Path esJvmOptFile : esJvmOptionsFiles) {
                    Path jvmOptFile = jvmOptionsDir.resolve(esJvmOptFile.getFileName().toString());
                    Files.copy(esJvmOptFile, jvmOptFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            terminal.println("Success!" + System.lineSeparator());
        }
        catch (Exception e) {
            throw new RuntimeException("Error importing JVM options. " + String.valueOf(e));
        }
    }
}

